/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda;

import java.util.LinkedList;
import java.util.List;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.hooks.IEventManager;

public class JDABuilder {
    protected static boolean proxySet = false;
    protected static boolean jdaCreated = false;
    protected static String proxyUrl = null;
    protected static int proxyPort = -1;
    protected final List<Object> listeners = new LinkedList<Object>();
    protected String token = null;
    protected boolean enableVoice = true;
    protected boolean enableShutdownHook = true;
    protected boolean enableBulkDeleteSplitting = true;
    protected IEventManager eventManager = null;
    protected boolean reconnect = true;
    protected int[] sharding = null;

    public JDABuilder setBotToken(String botToken) {
        this.token = "Bot " + botToken;
        return this;
    }

    public JDABuilder setProxy(String proxyUrl, int proxyPort) {
        if (proxySet || jdaCreated) {
            throw new UnsupportedOperationException("You cannot change the proxy after a proxy has been set or a JDA object has been created. Proxy settings are global among all instances!");
        }
        proxySet = true;
        JDABuilder.proxyUrl = proxyUrl;
        JDABuilder.proxyPort = proxyPort;
        return this;
    }

    public JDABuilder setAudioEnabled(boolean enabled) {
        this.enableVoice = enabled;
        return this;
    }

    public JDABuilder setBulkDeleteSplittingEnabled(boolean enabled) {
        this.enableBulkDeleteSplitting = enabled;
        return this;
    }

    public JDABuilder setEnableShutdownHook(boolean enable) {
        this.enableShutdownHook = enable;
        return this;
    }

    public JDABuilder setAutoReconnect(boolean reconnect) {
        this.reconnect = reconnect;
        return this;
    }

    public JDABuilder setEventManager(IEventManager manager) {
        this.eventManager = manager;
        return this;
    }

    public JDABuilder addListener(Object listener) {
        this.listeners.add(listener);
        return this;
    }

    public JDABuilder removeListener(Object listener) {
        this.listeners.remove(listener);
        return this;
    }

    public JDABuilder useSharding(int shardId, int numShards) {
        if (shardId < 0 || numShards < 2 || shardId >= numShards) {
            throw new RuntimeException("This configuration of shardId and numShards is not allowed! 0 <= shardId < numShards with numShards > 1");
        }
        this.sharding = new int[]{shardId, numShards};
        return this;
    }

    public JDA buildAsync() throws LoginException, IllegalArgumentException {
        jdaCreated = true;
        JDAImpl jda = proxySet ? new JDAImpl(proxyUrl, proxyPort, this.enableVoice, this.enableShutdownHook, this.enableBulkDeleteSplitting) : new JDAImpl(this.enableVoice, this.enableShutdownHook, this.enableBulkDeleteSplitting);
        jda.setAutoReconnect(this.reconnect);
        if (this.eventManager != null) {
            jda.setEventManager(this.eventManager);
        }
        this.listeners.forEach(jda::addEventListener);
        jda.setStatus(JDA.Status.INITIALIZED);
        jda.login(this.token, this.sharding);
        return jda;
    }

    public JDA buildBlocking() throws LoginException, IllegalArgumentException, InterruptedException {
        JDA jda = this.buildAsync();
        while (jda.getStatus() != JDA.Status.CONNECTED) {
            Thread.sleep(50L);
        }
        return jda;
    }
}

