/*
 * Decompiled with CFR 0.152.
 */
package com.neovisionaries.ws.client;

import com.neovisionaries.ws.client.ByteArray;
import com.neovisionaries.ws.client.DeflateDecompressor;
import com.neovisionaries.ws.client.PerMessageCompressionExtension;
import com.neovisionaries.ws.client.WebSocketError;
import com.neovisionaries.ws.client.WebSocketException;
import java.util.Map;

class PerMessageDeflateExtension
extends PerMessageCompressionExtension {
    public static final String EXTENSION_NAME = "permessage-deflate";
    private static final String SERVER_NO_CONTEXT_TAKEOVER = "server_no_context_takeover";
    private static final String CLIENT_NO_CONTEXT_TAKEOVER = "client_no_context_takeover";
    private static final String SERVER_MAX_WINDOW_BITS = "server_max_window_bits";
    private static final String CLIENT_MAX_WINDOW_BITS = "client_max_window_bits";
    private static final byte[] COMPRESSION_TERMINATOR = new byte[]{0, 0, -1, -1};
    private static final int MIN_BITS = 8;
    private static final int MAX_BITS = 15;
    private static final int MIN_WINDOW_SIZE = 256;
    private static final int DEFAULT_WINDOW_SIZE = 32768;
    private static final int INCOMING_SLIDING_WINDOW_MARGIN = 1024;
    private boolean mServerNoContextTakeover;
    private boolean mClientNoContextTakeover;
    private int mServerWindowSize = 32768;
    private int mClientWindowSize = 32768;
    private int mIncomingSlidingWindowBufferSize;
    private ByteArray mIncomingSlidingWindow;

    public PerMessageDeflateExtension(String name) {
        super(name);
    }

    void validate() throws WebSocketException {
        for (Map.Entry<String, String> entry : this.getParameters().entrySet()) {
            this.validateParameter(entry.getKey(), entry.getValue());
        }
        this.mIncomingSlidingWindowBufferSize = this.mServerWindowSize + 1024;
    }

    public boolean isServerNoContextTakeover() {
        return this.mServerNoContextTakeover;
    }

    public boolean isClientNoContextTakeover() {
        return this.mClientNoContextTakeover;
    }

    public int getServerWindowSize() {
        return this.mServerWindowSize;
    }

    public int getClientWindowSize() {
        return this.mClientWindowSize;
    }

    private void validateParameter(String key, String value) throws WebSocketException {
        if (SERVER_NO_CONTEXT_TAKEOVER.equals(key)) {
            this.mServerNoContextTakeover = true;
        } else if (CLIENT_NO_CONTEXT_TAKEOVER.equals(key)) {
            this.mClientNoContextTakeover = true;
        } else if (SERVER_MAX_WINDOW_BITS.equals(key)) {
            this.mServerWindowSize = this.computeWindowSize(key, value);
        } else if (CLIENT_MAX_WINDOW_BITS.equals(key)) {
            this.mClientWindowSize = this.computeWindowSize(key, value);
        } else {
            throw new WebSocketException(WebSocketError.PERMESSAGE_DEFLATE_UNSUPPORTED_PARAMETER, "permessage-deflate extension contains an unsupported parameter: " + key);
        }
    }

    private int computeWindowSize(String key, String value) throws WebSocketException {
        int bits = this.extractMaxWindowBits(key, value);
        int size = 256;
        for (int i = 8; i < bits; ++i) {
            size *= 2;
        }
        return size;
    }

    private int extractMaxWindowBits(String key, String value) throws WebSocketException {
        int bits = this.parseMaxWindowBits(value);
        if (bits < 0) {
            String message = String.format("The value of %s parameter of permessage-deflate extension is invalid: %s", key, value);
            throw new WebSocketException(WebSocketError.PERMESSAGE_DEFLATE_INVALID_MAX_WINDOW_BITS, message);
        }
        return bits;
    }

    private int parseMaxWindowBits(String value) {
        int bits;
        if (value == null) {
            return -1;
        }
        try {
            bits = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
        if (bits < 8 || 15 < bits) {
            return -1;
        }
        return bits;
    }

    protected byte[] decompress(byte[] compressed) throws WebSocketException {
        int inputLen = compressed.length + COMPRESSION_TERMINATOR.length;
        ByteArray input = new ByteArray(inputLen);
        input.put(compressed);
        input.put(COMPRESSION_TERMINATOR);
        if (this.mIncomingSlidingWindow == null) {
            this.mIncomingSlidingWindow = new ByteArray(this.mIncomingSlidingWindowBufferSize);
        }
        int outPos = this.mIncomingSlidingWindow.length();
        try {
            DeflateDecompressor.decompress(input, 0, this.mIncomingSlidingWindow);
        }
        catch (Exception e) {
            throw new WebSocketException(WebSocketError.DECOMPRESSION_ERROR, String.format("Failed to decompress the message: %s", e.getMessage()), e);
        }
        byte[] output = this.mIncomingSlidingWindow.toBytes(outPos);
        this.mIncomingSlidingWindow.shrink(this.mIncomingSlidingWindowBufferSize);
        if (this.mServerNoContextTakeover) {
            this.mIncomingSlidingWindow.clear();
        }
        return output;
    }
}

