/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.midi.file;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;
import javax.sound.midi.spi.MidiFileReader;
import org.tritonus.share.TDebug;
import org.tritonus.share.midi.TMidiFileFormat;

public class StandardMidiFileReader
extends MidiFileReader {
    public static boolean CANCEL_RUNNING_STATUS_ON_META_AND_SYSEX = true;
    private static final int STATUS_NONE = 0;
    private static final int STATUS_ONE_BYTE = 1;
    private static final int STATUS_TWO_BYTES = 2;
    private static final int STATUS_SYSEX = 3;
    private static final int STATUS_META = 4;

    @Override
    public MidiFileFormat getMidiFileFormat(InputStream inputStream) throws InvalidMidiDataException, IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int nHeaderMagic = dataInputStream.readInt();
        if (nHeaderMagic != 1297377380) {
            throw new InvalidMidiDataException("not a MIDI file: wrong header magic");
        }
        int nHeaderLength = dataInputStream.readInt();
        if (nHeaderLength < 6) {
            throw new InvalidMidiDataException("corrupt MIDI file: wrong header length");
        }
        short nType = dataInputStream.readShort();
        if (nType < 0 || nType > 2) {
            throw new InvalidMidiDataException("corrupt MIDI file: illegal type");
        }
        if (nType == 2) {
            throw new InvalidMidiDataException("this implementation doesn't support type 2 MIDI files");
        }
        short nNumTracks = dataInputStream.readShort();
        if (nNumTracks <= 0) {
            throw new InvalidMidiDataException("corrupt MIDI file: number of tracks must be positive");
        }
        if (nType == 0 && nNumTracks != 1) {
            throw new InvalidMidiDataException("corrupt MIDI file:  type 0 files must contain exactely one track");
        }
        int nDivision = dataInputStream.readUnsignedShort();
        float fDivisionType = -1.0f;
        int nResolution = -1;
        if ((nDivision & 0x8000) != 0) {
            int nFrameType = -(nDivision >>> 8 & 0xFF);
            switch (nFrameType) {
                case 24: {
                    fDivisionType = 24.0f;
                    break;
                }
                case 25: {
                    fDivisionType = 25.0f;
                    break;
                }
                case 29: {
                    fDivisionType = 29.97f;
                    break;
                }
                case 30: {
                    fDivisionType = 30.0f;
                    break;
                }
                default: {
                    throw new InvalidMidiDataException("corrupt MIDI file: illegal frame division type");
                }
            }
            nResolution = nDivision & 0xFF;
        } else {
            fDivisionType = 0.0f;
            nResolution = nDivision & Short.MAX_VALUE;
        }
        dataInputStream.skip(nHeaderLength - 6);
        TMidiFileFormat midiFileFormat = new TMidiFileFormat((int)nType, fDivisionType, nResolution, -1, -1L, nNumTracks);
        return midiFileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MidiFileFormat getMidiFileFormat(URL url) throws InvalidMidiDataException, IOException {
        try (InputStream inputStream = url.openStream();){
            MidiFileFormat midiFileFormat = this.getMidiFileFormat(inputStream);
            return midiFileFormat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            MidiFileFormat midiFileFormat = this.getMidiFileFormat(inputStream);
            return midiFileFormat;
        }
    }

    @Override
    public Sequence getSequence(URL url) throws InvalidMidiDataException, IOException {
        InputStream inputStream = url.openStream();
        try {
            return this.getSequence(inputStream);
        }
        catch (InvalidMidiDataException e) {
            if (TDebug.TraceAllExceptions) {
                TDebug.out(e);
            }
            inputStream.close();
            throw e;
        }
        catch (IOException e) {
            if (TDebug.TraceAllExceptions) {
                TDebug.out(e);
            }
            inputStream.close();
            throw e;
        }
    }

    @Override
    public Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        FileInputStream inputStream = new FileInputStream(file);
        try {
            return this.getSequence(inputStream);
        }
        catch (InvalidMidiDataException e) {
            if (TDebug.TraceAllExceptions) {
                TDebug.out(e);
            }
            ((InputStream)inputStream).close();
            throw e;
        }
        catch (IOException e) {
            if (TDebug.TraceAllExceptions) {
                TDebug.out(e);
            }
            ((InputStream)inputStream).close();
            throw e;
        }
    }

    @Override
    public Sequence getSequence(InputStream inputStream) throws InvalidMidiDataException, IOException {
        MidiFileFormat midiFileFormat = this.getMidiFileFormat(inputStream);
        Sequence sequence = new Sequence(midiFileFormat.getDivisionType(), midiFileFormat.getResolution());
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int nNumTracks = ((TMidiFileFormat)midiFileFormat).getTrackCount();
        for (int nTrack = 0; nTrack < nNumTracks; ++nTrack) {
            Track track = sequence.createTrack();
            this.readTrack(dataInputStream, track);
        }
        return sequence;
    }

    private void readTrack(DataInputStream dataInputStream, Track track) throws InvalidMidiDataException, IOException {
        int nMagic;
        while ((nMagic = dataInputStream.readInt()) != 1297379947) {
            int nChunkLength = dataInputStream.readInt();
            if (nChunkLength % 2 != 0) {
                ++nChunkLength;
            }
            dataInputStream.skip(nChunkLength);
        }
        int nTrackChunkLength = dataInputStream.readInt();
        long lTicks = 0L;
        long[] alRemainingBytes = new long[]{nTrackChunkLength};
        int[] anRunningStatusByte = new int[]{-1};
        while (alRemainingBytes[0] > 0L) {
            long lDeltaTicks = StandardMidiFileReader.readVariableLengthQuantity(dataInputStream, alRemainingBytes);
            MidiEvent event = StandardMidiFileReader.readEvent(dataInputStream, alRemainingBytes, anRunningStatusByte, lTicks += lDeltaTicks);
            track.add(event);
        }
    }

    private static MidiEvent readEvent(DataInputStream dataInputStream, long[] alRemainingBytes, int[] anRunningStatusByte, long lTicks) throws InvalidMidiDataException, IOException {
        int nStatusByte = StandardMidiFileReader.readUnsignedByte(dataInputStream, alRemainingBytes);
        MidiMessage message = null;
        boolean bRunningStatusApplies = false;
        int nSavedByte = 0;
        if (nStatusByte < 128) {
            if (anRunningStatusByte[0] != -1) {
                bRunningStatusApplies = true;
                nSavedByte = nStatusByte;
                nStatusByte = anRunningStatusByte[0];
            } else {
                throw new InvalidMidiDataException("corrupt MIDI file: status byte missing");
            }
        }
        switch (StandardMidiFileReader.getType(nStatusByte)) {
            case 1: {
                int nByte = 0;
                if (bRunningStatusApplies) {
                    nByte = nSavedByte;
                } else {
                    nByte = StandardMidiFileReader.readUnsignedByte(dataInputStream, alRemainingBytes);
                    anRunningStatusByte[0] = nStatusByte;
                }
                ShortMessage shortMessage1 = new ShortMessage();
                shortMessage1.setMessage(nStatusByte, nByte, 0);
                message = shortMessage1;
                break;
            }
            case 2: {
                int nByte1 = 0;
                if (bRunningStatusApplies) {
                    nByte1 = nSavedByte;
                } else {
                    nByte1 = StandardMidiFileReader.readUnsignedByte(dataInputStream, alRemainingBytes);
                    anRunningStatusByte[0] = nStatusByte;
                }
                int nByte2 = StandardMidiFileReader.readUnsignedByte(dataInputStream, alRemainingBytes);
                ShortMessage shortMessage2 = new ShortMessage();
                shortMessage2.setMessage(nStatusByte, nByte1, nByte2);
                message = shortMessage2;
                break;
            }
            case 3: {
                if (CANCEL_RUNNING_STATUS_ON_META_AND_SYSEX) {
                    anRunningStatusByte[0] = -1;
                }
                int nSysexDataLength = (int)StandardMidiFileReader.readVariableLengthQuantity(dataInputStream, alRemainingBytes);
                byte[] abSysexData = new byte[nSysexDataLength];
                for (int i = 0; i < nSysexDataLength; ++i) {
                    int nDataByte = StandardMidiFileReader.readUnsignedByte(dataInputStream, alRemainingBytes);
                    abSysexData[i] = (byte)nDataByte;
                }
                SysexMessage sysexMessage = new SysexMessage();
                sysexMessage.setMessage(nStatusByte, abSysexData, nSysexDataLength);
                message = sysexMessage;
                break;
            }
            case 4: {
                if (CANCEL_RUNNING_STATUS_ON_META_AND_SYSEX) {
                    anRunningStatusByte[0] = -1;
                }
                int nTypeByte = StandardMidiFileReader.readUnsignedByte(dataInputStream, alRemainingBytes);
                int nMetaDataLength = (int)StandardMidiFileReader.readVariableLengthQuantity(dataInputStream, alRemainingBytes);
                byte[] abMetaData = new byte[nMetaDataLength];
                for (int i = 0; i < nMetaDataLength; ++i) {
                    int nDataByte = StandardMidiFileReader.readUnsignedByte(dataInputStream, alRemainingBytes);
                    abMetaData[i] = (byte)nDataByte;
                }
                MetaMessage metaMessage = new MetaMessage();
                metaMessage.setMessage(nTypeByte, abMetaData, nMetaDataLength);
                message = metaMessage;
                break;
            }
        }
        MidiEvent event = new MidiEvent(message, lTicks);
        return event;
    }

    private static int getType(int nStatusByte) {
        if (nStatusByte < 240) {
            int nCommand = nStatusByte & 0xF0;
            switch (nCommand) {
                case 128: 
                case 144: 
                case 160: 
                case 176: 
                case 224: {
                    return 2;
                }
                case 192: 
                case 208: {
                    return 1;
                }
            }
            return 0;
        }
        if (nStatusByte == 240 || nStatusByte == 247) {
            return 3;
        }
        if (nStatusByte == 255) {
            return 4;
        }
        return 0;
    }

    public static long readVariableLengthQuantity(DataInputStream dataInputStream, long[] alRemainingBytes) throws InvalidMidiDataException, IOException {
        long lValue = 0L;
        int nByteCount = 0;
        while (nByteCount < 4) {
            int nByte = StandardMidiFileReader.readUnsignedByte(dataInputStream, alRemainingBytes);
            ++nByteCount;
            lValue <<= 7;
            lValue |= (long)(nByte & 0x7F);
            if (nByte >= 128) continue;
            return lValue;
        }
        throw new InvalidMidiDataException("not a MIDI file: unterminated variable-length quantity");
    }

    public static int readUnsignedByte(DataInputStream dataInputStream, long[] alRemainingBytes) throws IOException {
        int nByte = dataInputStream.readUnsignedByte();
        alRemainingBytes[0] = alRemainingBytes[0] - 1L;
        return nByte;
    }
}

