/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.requests;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.BaseRequest;
import com.mashape.unirest.request.GetRequest;
import com.mashape.unirest.request.HttpRequest;
import com.mashape.unirest.request.body.RequestBodyEntity;
import net.dv8tion.jda.JDAInfo;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.utils.SimpleLog;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Requester {
    public static final SimpleLog LOG = SimpleLog.getLog("JDARequester");
    public static String USER_AGENT = "JDA DiscordBot (https://github.com/DV8FromTheWorld/JDA, " + JDAInfo.VERSION + ")";
    public static final String DISCORD_API_PREFIX = "https://discordapp.com/api/";
    protected final JDAImpl api;

    public Requester(JDAImpl api) {
        this.api = api;
    }

    public Response get(String url) {
        return this.exec(this.addHeaders(Unirest.get(url)));
    }

    public Response delete(String url) {
        return this.exec(this.addHeaders(Unirest.delete(url)));
    }

    public Response post(String url, JSONObject body) {
        return this.exec(this.addHeaders(Unirest.post(url)).body(body.toString()));
    }

    public Response post(String url, JSONArray body) {
        return this.exec(this.addHeaders(Unirest.post(url)).body(body.toString()));
    }

    public Response patch(String url, JSONObject body) {
        return this.exec(this.addHeaders(Unirest.patch(url)).body(body.toString()));
    }

    public Response patch(String url, JSONArray body) {
        return this.exec(this.addHeaders(Unirest.patch(url)).body(body.toString()));
    }

    public Response put(String url, JSONObject body) {
        return this.exec(this.addHeaders(Unirest.put(url)).body(body.toString()));
    }

    public Response put(String url, JSONArray body) {
        return this.exec(this.addHeaders(Unirest.put(url)).body(body.toString()));
    }

    protected Response exec(BaseRequest request) {
        HttpResponse<String> ret = null;
        try {
            String dbg = String.format("Requesting %s -> %s\n\tPayload: %s\n\tResponse: ", request.getHttpRequest().getHttpMethod().name(), request.getHttpRequest().getUrl(), request instanceof RequestBodyEntity ? ((RequestBodyEntity)request).getBody().toString() : "None");
            ret = request.asString();
            if (ret.getBody() != null && ret.getBody().startsWith("<")) {
                LOG.debug(String.format("Requesting %s -> %s returned HTML... retrying", request.getHttpRequest().getHttpMethod().name(), request.getHttpRequest().getUrl()));
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ret = request.asString();
            }
            Response response = new Response(ret.getStatus(), ret.getBody());
            LOG.trace(dbg + response.code + ": " + response.responseText);
            return response;
        }
        catch (UnirestException e) {
            if (LOG.getEffectiveLevel().compareTo(SimpleLog.Level.DEBUG) != 1) {
                LOG.log(e);
            }
            return new Response(e);
        }
    }

    protected <T extends HttpRequest> T addHeaders(T request) {
        if (this.api.getAuthToken() != null && request.getUrl().contains("discordapp.com")) {
            request.header("authorization", this.api.getAuthToken());
        }
        if (!(request instanceof GetRequest)) {
            request.header("Content-Type", "application/json");
        }
        request.header("user-agent", USER_AGENT);
        request.header("Accept-Encoding", "gzip");
        return request;
    }

    public static class Response {
        public static final int connectionErrCode = -1;
        public final Exception exception;
        public final int code;
        public final String responseText;

        protected Response(int code, String response) {
            this.code = code;
            this.responseText = response;
            this.exception = null;
        }

        protected Response(Exception exception) {
            this.code = -1;
            this.responseText = null;
            this.exception = exception;
        }

        public boolean isOk() {
            return this.code > 199 && this.code < 300;
        }

        public boolean isRateLimit() {
            return this.code == 429;
        }

        public JSONObject getObject() {
            try {
                return this.responseText == null ? null : new JSONObject(this.responseText);
            }
            catch (JSONException ex) {
                return null;
            }
        }

        public JSONArray getArray() {
            try {
                return this.responseText == null ? null : new JSONArray(this.responseText);
            }
            catch (JSONException ex) {
                return null;
            }
        }

        public String toString() {
            return this.exception == null ? "HTTPResponse[" + this.code + ": " + this.responseText + ']' : "HTTPException[" + this.exception.getMessage() + ']';
        }
    }
}

