/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.managers.impl;

import com.sun.jna.Platform;
import java.io.IOException;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.audio.AudioConnection;
import net.dv8tion.jda.audio.AudioReceiveHandler;
import net.dv8tion.jda.audio.AudioSendHandler;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.VoiceChannel;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.exceptions.GuildUnavailableException;
import net.dv8tion.jda.managers.AudioManager;
import net.dv8tion.jda.utils.NativeUtils;
import net.dv8tion.jda.utils.ServiceUtil;
import org.json.JSONObject;

public class AudioManagerImpl
implements AudioManager {
    public static boolean AUDIO_SUPPORTED;
    public static String OPUS_LIB_NAME;
    protected static boolean initialized;
    protected final JDAImpl api;
    protected final Guild guild;
    protected AudioConnection audioConnection = null;
    protected VoiceChannel queuedAudioConnection = null;
    protected VoiceChannel unexpectedDisconnectedChannel = null;
    protected AudioSendHandler sendHandler;
    protected AudioReceiveHandler receiveHandler;
    protected long queueTimeout = 100L;
    protected long timeout = 10000L;

    public AudioManagerImpl(Guild guild) {
        this.guild = guild;
        this.api = (JDAImpl)guild.getJDA();
        AudioManagerImpl.init();
    }

    @Override
    public void openAudioConnection(VoiceChannel channel) {
        if (!AUDIO_SUPPORTED) {
            throw new UnsupportedOperationException("Sorry! Audio is disabled due to an internal JDA error! Contact Dev!");
        }
        if (this.audioConnection != null) {
            throw new IllegalStateException("Cannot have more than 1 audio connection at a time. Please close existing connection before attempting to open a new connection.");
        }
        if (this.queuedAudioConnection != null) {
            throw new IllegalStateException("Already attempting to start an AudioConnection with a VoiceChannel!\nCurrently Attempting Channel ID: " + this.queuedAudioConnection.getId() + "  |  New Attempt Channel ID: " + channel.getId());
        }
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException("Cannot open an Audio Connection with an unavailable guild. Please wait until this Guild is available to open a connection.");
        }
        this.queuedAudioConnection = channel;
        JSONObject obj = new JSONObject().put("op", 4).put("d", new JSONObject().put("guild_id", channel.getGuild().getId()).put("channel_id", channel.getId()).put("self_mute", false).put("self_deaf", false));
        this.api.getClient().send(obj.toString());
    }

    @Override
    public void moveAudioConnection(VoiceChannel channel) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Cannot change to a different VoiceChannel when not currently connected. Please use openAudioConnection(VoiceChannel) to start an audio connection.");
        }
        if (channel == null) {
            throw new IllegalArgumentException("The provided VoiceChannel was null! Cannot determine which VoiceChannel to move to from a null VoiceChannel!");
        }
        if (!this.audioConnection.getChannel().getGuild().getId().equals(channel.getGuild().getId())) {
            throw new IllegalArgumentException("Cannot move to a VoiceChannel that isn't in the same Guild as the active VoiceChannel audio connection. If you wish to open an audio connection with a VoiceChannel on a different Guild, please close the active connection and start a new one.");
        }
        if (channel.getId().equals(this.audioConnection.getChannel().getId())) {
            return;
        }
        JSONObject obj = new JSONObject().put("op", 4).put("d", new JSONObject().put("guild_id", channel.getGuild().getId()).put("channel_id", channel.getId()).put("self_mute", false).put("self_deaf", false));
        this.api.getClient().send(obj.toString());
        this.audioConnection.setChannel(channel);
    }

    @Override
    public void closeAudioConnection() {
        if (this.audioConnection == null) {
            return;
        }
        this.audioConnection.close(false);
        this.audioConnection = null;
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    @Override
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    public boolean isAttemptingToConnect() {
        return this.queuedAudioConnection != null;
    }

    @Override
    public VoiceChannel getQueuedAudioConnection() {
        return this.queuedAudioConnection;
    }

    @Override
    public VoiceChannel getConnectedChannel() {
        return this.audioConnection == null ? null : this.audioConnection.getChannel();
    }

    @Override
    public boolean isConnected() {
        return this.audioConnection != null;
    }

    @Override
    public void setConnectTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public long getConnectTimeout() {
        return this.timeout;
    }

    @Override
    public void setSendingHandler(AudioSendHandler handler) {
        this.sendHandler = handler;
        if (this.audioConnection != null) {
            this.audioConnection.setSendingHandler(handler);
        }
    }

    @Override
    public AudioSendHandler getSendingHandler() {
        return this.sendHandler;
    }

    @Override
    public void setReceivingHandler(AudioReceiveHandler handler) {
        this.receiveHandler = handler;
        if (this.audioConnection != null) {
            this.audioConnection.setReceivingHandler(handler);
        }
    }

    @Override
    public AudioReceiveHandler getReceiveHandler() {
        return this.receiveHandler;
    }

    public void setAudioConnection(AudioConnection audioConnection) {
        this.audioConnection = audioConnection;
        if (audioConnection == null) {
            return;
        }
        this.queuedAudioConnection = null;
        audioConnection.setSendingHandler(this.sendHandler);
        audioConnection.setReceivingHandler(this.receiveHandler);
        audioConnection.setQueueTimeout(this.queueTimeout);
        audioConnection.ready(this.timeout);
    }

    public void prepareForRegionChange() {
        VoiceChannel queuedChannel = this.audioConnection.getChannel();
        this.audioConnection.close(true);
        this.audioConnection = null;
        this.queuedAudioConnection = queuedChannel;
    }

    public boolean wasUnexpectedlyDisconnected() {
        return this.unexpectedDisconnectedChannel != null;
    }

    public void setUnexpectedDisconnectChannel(VoiceChannel channel) {
        this.unexpectedDisconnectedChannel = channel;
    }

    public VoiceChannel getUnexpectedDisconnectedChannel() {
        return this.unexpectedDisconnectedChannel;
    }

    public void setQueueTimeout(long queueTimeout) {
        this.queueTimeout = queueTimeout;
        if (this.audioConnection != null) {
            this.audioConnection.setQueueTimeout(queueTimeout);
        }
    }

    public static synchronized boolean init() {
        if (initialized) {
            return AUDIO_SUPPORTED;
        }
        initialized = true;
        ServiceUtil.loadServices();
        String nativesRoot = null;
        try {
            nativesRoot = "/natives/" + Platform.RESOURCE_PREFIX + "/%s";
            if (nativesRoot.contains("darwin")) {
                nativesRoot = nativesRoot + ".dylib";
            } else if (nativesRoot.contains("win")) {
                nativesRoot = nativesRoot + ".dll";
            } else if (nativesRoot.contains("linux")) {
                nativesRoot = nativesRoot + ".so";
            } else {
                throw new UnsupportedOperationException();
            }
            NativeUtils.loadLibraryFromJar(String.format(nativesRoot, "libopus"));
            OPUS_LIB_NAME = nativesRoot != null ? String.format(nativesRoot, "libopus") : null;
        }
        catch (Throwable e) {
            try {
                if (e instanceof UnsupportedOperationException) {
                    LOG.fatal("Sorry, JDA's audio system doesn't support this system.\nSupported Systems: Windows(x86, x64), Mac(x86, x64) and Linux(x86, x64)\nOperating system: " + Platform.RESOURCE_PREFIX);
                } else if (e instanceof IOException) {
                    LOG.fatal("There was an IO Exception when setting up the temp files for audio.");
                    LOG.log(e);
                } else if (e instanceof UnsatisfiedLinkError) {
                    LOG.fatal("JDA encountered a problem when attempting to load the Native libraries. Contact a DEV.");
                    LOG.log(e);
                } else {
                    LOG.fatal("An unknown error occurred while attempting to setup JDA's audio system!");
                    LOG.log(e);
                }
                nativesRoot = null;
                OPUS_LIB_NAME = nativesRoot != null ? String.format(nativesRoot, "libopus") : null;
            }
            catch (Throwable throwable) {
                OPUS_LIB_NAME = nativesRoot != null ? String.format(nativesRoot, "libopus") : null;
                boolean bl = AUDIO_SUPPORTED = nativesRoot != null;
                if (AUDIO_SUPPORTED) {
                    LOG.info("Audio System successfully setup!");
                } else {
                    LOG.info("Audio System encountered problems while loading, thus, is disabled.");
                }
                return AUDIO_SUPPORTED;
            }
            boolean bl = AUDIO_SUPPORTED = nativesRoot != null;
            if (AUDIO_SUPPORTED) {
                LOG.info("Audio System successfully setup!");
            } else {
                LOG.info("Audio System encountered problems while loading, thus, is disabled.");
            }
            return AUDIO_SUPPORTED;
        }
        boolean bl = AUDIO_SUPPORTED = nativesRoot != null;
        if (AUDIO_SUPPORTED) {
            LOG.info("Audio System successfully setup!");
        } else {
            LOG.info("Audio System encountered problems while loading, thus, is disabled.");
        }
        return AUDIO_SUPPORTED;
    }

    static {
        initialized = false;
    }
}

