/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.managers;

import net.dv8tion.jda.OnlineStatus;
import net.dv8tion.jda.entities.Game;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.SelfInfo;
import net.dv8tion.jda.entities.impl.GameImpl;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.entities.impl.SelfInfoImpl;
import net.dv8tion.jda.utils.AvatarUtil;
import org.json.JSONObject;

public class AccountManager {
    protected AvatarUtil.Avatar avatar = null;
    protected String username = null;
    protected final JDAImpl api;

    public AccountManager(JDAImpl api) {
        this.api = api;
    }

    public AccountManager setAvatar(AvatarUtil.Avatar avatar) {
        this.avatar = avatar;
        return this;
    }

    public AccountManager setUsername(String username) {
        this.username = username;
        return this;
    }

    public void setGame(String game) {
        if (game != null && game.trim().isEmpty()) {
            game = null;
        }
        ((SelfInfoImpl)this.api.getSelfInfo()).setCurrentGame(game == null ? null : new GameImpl(game, null, Game.GameType.DEFAULT));
        this.updateStatusAndGame();
    }

    public void setStreaming(String title, String url) throws IllegalArgumentException {
        if (title != null && title.trim().isEmpty()) {
            title = null;
        }
        if (url != null && url.trim().isEmpty()) {
            url = null;
        }
        if (title != null && !Game.isValidStreamingUrl(url)) {
            throw new IllegalArgumentException("Streaming Url must be valid!");
        }
        ((SelfInfoImpl)this.api.getSelfInfo()).setCurrentGame(title == null ? null : new GameImpl(title, url, Game.GameType.TWITCH));
        this.updateStatusAndGame();
    }

    public void setIdle(boolean idle) {
        ((SelfInfoImpl)this.api.getSelfInfo()).setOnlineStatus(idle ? OnlineStatus.AWAY : OnlineStatus.ONLINE);
        this.updateStatusAndGame();
    }

    public void setNickname(Guild guild, String nickname) {
        guild.getManager().setNickname(this.api.getSelfInfo(), nickname);
    }

    public void reset() {
        this.avatar = null;
        this.username = null;
    }

    public void update() {
        JSONObject object = new JSONObject();
        object.put("avatar", this.avatar == null ? this.api.getSelfInfo().getAvatarId() : (this.avatar == AvatarUtil.DELETE_AVATAR ? JSONObject.NULL : this.avatar.getEncoded()));
        object.put("username", this.username == null ? this.api.getSelfInfo().getUsername() : this.username);
        JSONObject result = this.api.getRequester().patch("https://discordapp.com/api/users/@me", object).getObject();
        if (result == null || !result.has("token")) {
            throw new RuntimeException("Something went wrong while changing the account settings.");
        }
        this.api.setAuthToken(result.getString("token"));
        this.avatar = null;
        this.username = null;
    }

    protected void updateStatusAndGame() {
        SelfInfo selfInfo = this.api.getSelfInfo();
        JSONObject game = null;
        if (selfInfo.getCurrentGame() != null) {
            game = new JSONObject().put("name", selfInfo.getCurrentGame().getName());
            if (selfInfo.getCurrentGame().getType() != Game.GameType.DEFAULT) {
                game = game.put("url", selfInfo.getCurrentGame().getUrl()).put("type", selfInfo.getCurrentGame().getType().getKey());
            }
        }
        JSONObject content = new JSONObject().put("game", game == null ? JSONObject.NULL : game).put("idle_since", selfInfo.getOnlineStatus() == OnlineStatus.AWAY ? Long.valueOf(System.currentTimeMillis()) : JSONObject.NULL);
        this.api.getClient().send(new JSONObject().put("op", 3).put("d", content).toString());
    }
}

