/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import java.util.LinkedList;
import net.dv8tion.jda.entities.MessageEmbed;
import net.dv8tion.jda.entities.PrivateChannel;
import net.dv8tion.jda.entities.TextChannel;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.events.message.MessageEmbedEvent;
import net.dv8tion.jda.events.message.guild.GuildMessageEmbedEvent;
import net.dv8tion.jda.events.message.priv.PrivateMessageEmbedEvent;
import net.dv8tion.jda.handle.EntityBuilder;
import net.dv8tion.jda.handle.EventCache;
import net.dv8tion.jda.handle.SocketHandler;
import net.dv8tion.jda.requests.GuildLock;
import org.json.JSONArray;
import org.json.JSONObject;

public class MessageEmbedHandler
extends SocketHandler {
    public MessageEmbedHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        EntityBuilder builder = new EntityBuilder(this.api);
        String messageId = content.getString("id");
        String channelId = content.getString("channel_id");
        TextChannel channel = this.api.getChannelMap().get(channelId);
        LinkedList<MessageEmbed> embeds = new LinkedList<MessageEmbed>();
        JSONArray embedsJson = content.getJSONArray("embeds");
        for (int i = 0; i < embedsJson.length(); ++i) {
            embeds.add(builder.createMessageEmbed(embedsJson.getJSONObject(i)));
        }
        if (channel != null) {
            if (GuildLock.get(this.api).isLocked(channel.getGuild().getId())) {
                return channel.getGuild().getId();
            }
            this.api.getEventManager().handle(new GuildMessageEmbedEvent(this.api, this.responseNumber, messageId, channel, embeds));
        } else {
            PrivateChannel privChannel = this.api.getPmChannelMap().get(channelId);
            if (privChannel == null) {
                EventCache.get(this.api).cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.allContent));
                EventCache.LOG.debug("Got unrecognized Channel Id for MessageEmbed! JSON: " + content);
                return null;
            }
            this.api.getEventManager().handle(new PrivateMessageEmbedEvent(this.api, this.responseNumber, messageId, privChannel, embeds));
        }
        this.api.getEventManager().handle(new MessageEmbedEvent(this.api, this.responseNumber, messageId, channelId, embeds, channel == null));
        return null;
    }
}

