/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import java.util.LinkedList;
import net.dv8tion.jda.entities.Emote;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.impl.EmoteImpl;
import net.dv8tion.jda.entities.impl.GuildImpl;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.handle.SocketHandler;
import net.dv8tion.jda.requests.GuildLock;
import org.json.JSONArray;
import org.json.JSONObject;

public class GuildEmojisUpdateHandler
extends SocketHandler {
    public GuildEmojisUpdateHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        if (GuildLock.get(this.api).isLocked(content.getString("guild_id"))) {
            return content.getString("guild_id");
        }
        Guild guild = this.api.getGuildMap().get(content.getString("guild_id"));
        if (guild == null) {
            JDAImpl.LOG.warn("Received Emojis Update for Guild we can't see. Ignoring event...");
            return null;
        }
        LinkedList<Emote> oldEmotes = new LinkedList<Emote>(guild.getEmotes());
        JSONArray array = content.getJSONArray("emojis");
        for (int i = 0; i < array.length(); ++i) {
            JSONObject obj = array.getJSONObject(i);
            String id = obj.getString("id");
            String name = obj.getString("name");
            EmoteImpl emote = (EmoteImpl)this.api.getEmoteById(id);
            if (emote == null) {
                emote = new EmoteImpl(name, id);
                emote.addGuild(guild);
                this.api.getEmoteMap().put(id, emote);
            }
            ((GuildImpl)guild).getEmoteMap().put(id, emote);
            oldEmotes.remove(emote);
        }
        for (Emote e : oldEmotes) {
            ((EmoteImpl)e).removeGuild(guild);
            if (!e.getGuilds().isEmpty()) continue;
            this.api.getEmoteMap().remove(e.getId());
        }
        return null;
    }
}

