/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import net.dv8tion.jda.entities.ChannelType;
import net.dv8tion.jda.entities.TextChannel;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.VoiceChannel;
import net.dv8tion.jda.entities.impl.GuildImpl;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.entities.impl.UserImpl;
import net.dv8tion.jda.events.channel.priv.PrivateChannelDeleteEvent;
import net.dv8tion.jda.events.channel.text.TextChannelDeleteEvent;
import net.dv8tion.jda.events.channel.voice.VoiceChannelDeleteEvent;
import net.dv8tion.jda.handle.EventCache;
import net.dv8tion.jda.handle.SocketHandler;
import net.dv8tion.jda.managers.AudioManager;
import net.dv8tion.jda.requests.GuildLock;
import org.json.JSONObject;

public class ChannelDeleteHandler
extends SocketHandler {
    public ChannelDeleteHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        ChannelType type = ChannelType.fromId(content.getInt("type"));
        if ((type == ChannelType.TEXT || type == ChannelType.VOICE) && GuildLock.get(this.api).isLocked(content.getString("guild_id"))) {
            return content.getString("guild_id");
        }
        switch (type) {
            case TEXT: {
                GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(content.getString("guild_id"));
                TextChannel channel = this.api.getChannelMap().remove(content.getString("id"));
                if (channel == null) {
                    EventCache.get(this.api).cache(EventCache.Type.CHANNEL, content.getString("id"), () -> this.handle(this.allContent));
                    EventCache.LOG.debug("CHANNEL_DELETE attempted to delete a channel that doesn't exist! JSON: " + content);
                    return null;
                }
                guild.getTextChannelsMap().remove(channel.getId());
                this.api.getEventManager().handle(new TextChannelDeleteEvent(this.api, this.responseNumber, channel));
                break;
            }
            case VOICE: {
                GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(content.getString("guild_id"));
                VoiceChannel channel = guild.getVoiceChannelsMap().remove(content.getString("id"));
                if (channel == null) {
                    EventCache.get(this.api).cache(EventCache.Type.CHANNEL, content.getString("id"), () -> this.handle(this.allContent));
                    EventCache.LOG.debug("CHANNEL_DELETE attempted to delete a channel that doesn't exist! JSON: " + content);
                    return null;
                }
                AudioManager manager = this.api.getAudioManagersMap().get(guild);
                if (manager != null && manager.isConnected() && manager.getConnectedChannel().getId().equals(channel.getId())) {
                    manager.closeAudioConnection();
                }
                guild.getVoiceChannelsMap().remove(channel.getId());
                this.api.getEventManager().handle(new VoiceChannelDeleteEvent(this.api, this.responseNumber, channel));
                break;
            }
            case PRIVATE: {
                User user;
                String userid = content.getJSONArray("recipients").getJSONObject(0).getString("id");
                if (this.api.getOffline_pms().containsKey(userid)) {
                    this.api.getOffline_pms().remove(userid);
                }
                if ((user = this.api.getUserById(userid)) != null) {
                    ((UserImpl)user).setPrivateChannel(null);
                }
                this.api.getPmChannelMap().remove(content.getString("id"));
                this.api.getEventManager().handle(new PrivateChannelDeleteEvent(this.api, this.responseNumber, user));
                break;
            }
            case GROUP: {
                JDAImpl.LOG.debug("Received CHANNEL_DELETE for a group, but JDA doesn't support groups. (Use JDA-Client)");
                break;
            }
            default: {
                throw new IllegalArgumentException("CHANNEL_DELETE provided an unknown channel type. JSON: " + content);
            }
        }
        return null;
    }
}

