/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.entities.impl;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.Permission;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.PermissionOverride;
import net.dv8tion.jda.entities.Role;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.VoiceChannel;
import net.dv8tion.jda.entities.impl.PermissionOverrideImpl;
import net.dv8tion.jda.exceptions.PermissionException;
import net.dv8tion.jda.managers.ChannelManager;
import net.dv8tion.jda.managers.PermissionOverrideManager;
import net.dv8tion.jda.utils.InviteUtil;
import net.dv8tion.jda.utils.MiscUtil;
import net.dv8tion.jda.utils.PermissionUtil;

public class VoiceChannelImpl
implements VoiceChannel {
    private final String id;
    private final Guild guild;
    private String name;
    private int position;
    private int userLimit;
    private int bitrate;
    private List<User> connectedUsers = new ArrayList<User>();
    private final Map<User, PermissionOverride> userPermissionOverrides = new HashMap<User, PermissionOverride>();
    private final Map<Role, PermissionOverride> rolePermissionOverrides = new HashMap<Role, PermissionOverride>();
    private ChannelManager manager = null;

    public VoiceChannelImpl(String id, Guild guild) {
        this.id = id;
        this.guild = guild;
    }

    @Override
    public JDA getJDA() {
        return this.guild.getJDA();
    }

    @Override
    public PermissionOverride getOverrideForUser(User user) {
        return this.userPermissionOverrides.get(user);
    }

    @Override
    public PermissionOverride getOverrideForRole(Role role) {
        return this.rolePermissionOverrides.get(role);
    }

    @Override
    public List<PermissionOverride> getPermissionOverrides() {
        LinkedList<PermissionOverride> overrides = new LinkedList<PermissionOverride>();
        overrides.addAll(this.userPermissionOverrides.values());
        overrides.addAll(this.rolePermissionOverrides.values());
        return Collections.unmodifiableList(overrides);
    }

    @Override
    public List<PermissionOverride> getUserPermissionOverrides() {
        return Collections.unmodifiableList(new LinkedList<PermissionOverride>(this.userPermissionOverrides.values()));
    }

    @Override
    public List<PermissionOverride> getRolePermissionOverrides() {
        return Collections.unmodifiableList(new LinkedList<PermissionOverride>(this.rolePermissionOverrides.values()));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    public int getPosition() {
        List<VoiceChannel> channels = this.guild.getVoiceChannels();
        for (int i = 0; i < channels.size(); ++i) {
            if (channels.get(i) != this) continue;
            return i;
        }
        throw new RuntimeException("Somehow when determining position we never found the VoiceChannel in the Guild's channels? wtf?");
    }

    @Override
    public int getPositionRaw() {
        return this.position;
    }

    @Override
    public List<User> getUsers() {
        return Collections.unmodifiableList(new LinkedList<User>(this.connectedUsers));
    }

    @Override
    public boolean checkPermission(User user, Permission ... permissions) {
        return PermissionUtil.checkPermission(this, user, permissions);
    }

    @Override
    public synchronized ChannelManager getManager() {
        if (this.manager == null) {
            this.manager = new ChannelManager(this);
        }
        return this.manager;
    }

    @Override
    public PermissionOverrideManager createPermissionOverride(User user) {
        if (!this.checkPermission(this.getJDA().getSelfInfo(), Permission.MANAGE_PERMISSIONS)) {
            throw new PermissionException(Permission.MANAGE_PERMISSIONS);
        }
        if (!this.getGuild().getUsers().contains(user)) {
            throw new IllegalArgumentException("Given user is not member of this Guild");
        }
        PermissionOverrideImpl override = new PermissionOverrideImpl(this, user, null);
        override.setAllow(1 << Permission.MANAGE_PERMISSIONS.getOffset()).setDeny(0);
        PermissionOverrideManager manager = override.getManager();
        manager.reset(Permission.MANAGE_PERMISSIONS).update();
        return manager;
    }

    @Override
    public PermissionOverrideManager createPermissionOverride(Role role) {
        if (!this.checkPermission(this.getJDA().getSelfInfo(), Permission.MANAGE_PERMISSIONS)) {
            throw new PermissionException(Permission.MANAGE_PERMISSIONS);
        }
        if (!this.getGuild().getRoles().contains(role)) {
            throw new IllegalArgumentException("Given role does not exist in this Guild");
        }
        PermissionOverrideImpl override = new PermissionOverrideImpl(this, null, role);
        override.setAllow(1 << Permission.MANAGE_PERMISSIONS.getOffset()).setDeny(0);
        PermissionOverrideManager manager = override.getManager();
        manager.reset(Permission.MANAGE_PERMISSIONS).update();
        return manager;
    }

    @Override
    public List<InviteUtil.AdvancedInvite> getInvites() {
        return InviteUtil.getInvites(this);
    }

    @Override
    public int getUserLimit() {
        return this.userLimit;
    }

    @Override
    public int getBitrate() {
        return this.bitrate;
    }

    public VoiceChannelImpl setName(String name) {
        this.name = name;
        return this;
    }

    public VoiceChannelImpl setPosition(int position) {
        this.position = position;
        return this;
    }

    public VoiceChannelImpl setUsers(List<User> connectedUsers) {
        this.connectedUsers = connectedUsers;
        return this;
    }

    public VoiceChannelImpl setUserLimit(int userLimit) {
        this.userLimit = userLimit;
        return this;
    }

    public VoiceChannelImpl setBitrate(int bitrate) {
        this.bitrate = bitrate;
        return this;
    }

    public List<User> getUsersModifiable() {
        return this.connectedUsers;
    }

    public Map<User, PermissionOverride> getUserPermissionOverridesMap() {
        return this.userPermissionOverrides;
    }

    public Map<Role, PermissionOverride> getRolePermissionOverridesMap() {
        return this.rolePermissionOverrides;
    }

    @Override
    public String getTopic() {
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof VoiceChannel)) {
            return false;
        }
        VoiceChannel oVChannel = (VoiceChannel)o;
        return this == oVChannel || this.getId().equals(oVChannel.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "VC:" + this.getName() + '(' + this.getId() + ')';
    }

    @Override
    public int compareTo(VoiceChannel chan) {
        if (this == chan) {
            return 0;
        }
        if (this.getGuild() != chan.getGuild()) {
            throw new IllegalArgumentException("Cannot compare VoiceChannels that aren't from the same guild!");
        }
        if (this.getPositionRaw() != chan.getPositionRaw()) {
            return chan.getPositionRaw() - this.getPositionRaw();
        }
        OffsetDateTime thisTime = MiscUtil.getCreationTime(this);
        OffsetDateTime chanTime = MiscUtil.getCreationTime(chan);
        return chanTime.compareTo(thisTime);
    }
}

