/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.entities.impl;

import net.dv8tion.jda.JDA;
import net.dv8tion.jda.OnlineStatus;
import net.dv8tion.jda.entities.Game;
import net.dv8tion.jda.entities.PrivateChannel;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.handle.EntityBuilder;
import net.dv8tion.jda.requests.Requester;
import org.json.JSONException;
import org.json.JSONObject;

public class UserImpl
implements User {
    private final String id;
    private final JDAImpl api;
    private String username;
    private String discriminator;
    private String avatarId;
    private Game game = null;
    private OnlineStatus onlineStatus = OnlineStatus.OFFLINE;
    private PrivateChannel privateChannel = null;
    private boolean isBot = false;

    public UserImpl(String id, JDAImpl api) {
        this.id = id;
        this.api = api;
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getDiscriminator() {
        return this.discriminator;
    }

    @Override
    public String getAsMention() {
        return "<@" + this.getId() + '>';
    }

    @Override
    public String getAvatarId() {
        return this.avatarId;
    }

    @Override
    public String getAvatarUrl() {
        return this.getAvatarId() == null ? null : "https://cdn.discordapp.com/avatars/" + this.getId() + "/" + this.getAvatarId() + ".jpg";
    }

    @Override
    public String getDefaultAvatarId() {
        return DefaultAvatar.values()[Integer.parseInt(this.getDiscriminator()) % DefaultAvatar.values().length].toString();
    }

    @Override
    public String getDefaultAvatarUrl() {
        return "https://discordapp.com/assets/" + this.getDefaultAvatarId() + ".png";
    }

    @Override
    public Game getCurrentGame() {
        return this.game;
    }

    @Override
    public OnlineStatus getOnlineStatus() {
        return this.onlineStatus;
    }

    @Override
    public PrivateChannel getPrivateChannel() {
        if (this.privateChannel == null) {
            try {
                Requester.Response response = this.api.getRequester().post("https://discordapp.com/api/users/@me/channels", new JSONObject().put("recipient_id", this.getId()));
                if (!response.isOk()) {
                    throw new RuntimeException("Could not get Private-channel for user: " + this.getUsername() + "... Error: " + response.toString());
                }
                new EntityBuilder(this.api).createPrivateChannel(response.getObject());
            }
            catch (JSONException ex) {
                JDAImpl.LOG.log(ex);
            }
        }
        return this.privateChannel;
    }

    @Override
    public boolean isBot() {
        return this.isBot;
    }

    public UserImpl setUserName(String username) {
        this.username = username;
        return this;
    }

    public UserImpl setDiscriminator(String discriminator) {
        this.discriminator = discriminator;
        return this;
    }

    public UserImpl setAvatarId(String avatarId) {
        this.avatarId = avatarId;
        return this;
    }

    public UserImpl setCurrentGame(Game game) {
        this.game = game;
        return this;
    }

    public UserImpl setOnlineStatus(OnlineStatus onlineStatus) {
        this.onlineStatus = onlineStatus;
        return this;
    }

    public UserImpl setPrivateChannel(PrivateChannel channel) {
        this.privateChannel = channel;
        if (channel != null) {
            this.api.getPmChannelMap().put(channel.getId(), channel);
        }
        return this;
    }

    public UserImpl setIsBot(boolean isBot) {
        this.isBot = isBot;
        return this;
    }

    public boolean hasPrivateChannel() {
        return this.privateChannel != null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof User)) {
            return false;
        }
        User oUser = (User)o;
        return this == oUser || this.getId().equals(oUser.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "U:" + this.getUsername() + '(' + this.getId() + ')';
    }

    private static enum DefaultAvatar {
        BLURPLE("6debd47ed13483642cf09e832ed0bc1b"),
        GREY("322c936a8c8be1b803cd94861bdfa868"),
        GREEN("dd4dbc0016779df1378e7812eabaa04d"),
        ORANGE("0e291f67c9274a1abdddeb3fd919cbaa"),
        RED("1cbd08c76f8af6dddce02c5138971129");

        private final String text;

        private DefaultAvatar(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

