/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.entities.impl;

import com.mashape.unirest.http.Unirest;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.entities.Emote;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.PrivateChannel;
import net.dv8tion.jda.entities.SelfInfo;
import net.dv8tion.jda.entities.TextChannel;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.VoiceChannel;
import net.dv8tion.jda.entities.impl.TextChannelImpl;
import net.dv8tion.jda.events.Event;
import net.dv8tion.jda.events.StatusChangeEvent;
import net.dv8tion.jda.events.guild.GuildJoinEvent;
import net.dv8tion.jda.exceptions.RateLimitedException;
import net.dv8tion.jda.hooks.EventListener;
import net.dv8tion.jda.hooks.IEventManager;
import net.dv8tion.jda.hooks.InterfacedEventManager;
import net.dv8tion.jda.hooks.SubscribeEvent;
import net.dv8tion.jda.managers.AccountManager;
import net.dv8tion.jda.managers.AudioManager;
import net.dv8tion.jda.managers.GuildManager;
import net.dv8tion.jda.managers.impl.AudioManagerImpl;
import net.dv8tion.jda.requests.Requester;
import net.dv8tion.jda.requests.WebSocketClient;
import net.dv8tion.jda.utils.SimpleLog;
import org.apache.http.HttpHost;
import org.json.JSONObject;

public class JDAImpl
implements JDA {
    public static final SimpleLog LOG = SimpleLog.getLog("JDA");
    protected final HttpHost proxy;
    protected final Map<String, User> userMap = new HashMap<String, User>();
    protected final Map<String, Guild> guildMap = new HashMap<String, Guild>();
    protected final Map<String, TextChannel> textChannelMap = new HashMap<String, TextChannel>();
    protected final Map<String, VoiceChannel> voiceChannelMap = new HashMap<String, VoiceChannel>();
    protected final Map<String, PrivateChannel> pmChannelMap = new HashMap<String, PrivateChannel>();
    protected final Map<String, Long> messageRatelimitTimeouts = new HashMap<String, Long>();
    protected final Map<String, String> offline_pms = new HashMap<String, String>();
    protected final Map<Guild, AudioManager> audioManagers = new HashMap<Guild, AudioManager>();
    protected final Map<String, Emote> emoteMap = new HashMap<String, Emote>();
    protected final boolean audioEnabled;
    protected final boolean useShutdownHook;
    protected final boolean bulkDeleteSplittingEnabled;
    protected volatile JDA.Status status;
    protected IEventManager eventManager = new InterfacedEventManager();
    protected SelfInfo selfInfo = null;
    protected AccountManager accountManager;
    protected String authToken = null;
    protected WebSocketClient client;
    protected Requester requester = new Requester(this);
    protected boolean reconnect;
    protected int responseTotal;

    public JDAImpl(boolean enableAudio, boolean useShutdownHook, boolean enableBulkDeleteSplitting) {
        this.status = JDA.Status.INITIALIZING;
        this.proxy = null;
        this.audioEnabled = enableAudio ? AudioManagerImpl.init() : false;
        this.useShutdownHook = useShutdownHook;
        this.bulkDeleteSplittingEnabled = enableBulkDeleteSplitting;
        if (this.bulkDeleteSplittingEnabled) {
            LOG.warn("BulkDeleteSplitting is enabled. For best performance, please look at the javadoc for JDABuilder#setBulkDeleteEnabled(boolean).");
        }
    }

    public JDAImpl(String proxyUrl, int proxyPort, boolean enableAudio, boolean useShutdownHook, boolean enableBulkDeleteSplitting) {
        this.status = JDA.Status.INITIALIZING;
        if (proxyUrl == null || proxyUrl.isEmpty() || proxyPort == -1) {
            throw new IllegalArgumentException("The provided proxy settings cannot be used to make a proxy. Settings: URL: '" + proxyUrl + "'  Port: " + proxyPort);
        }
        this.proxy = new HttpHost(proxyUrl, proxyPort);
        Unirest.setProxy(this.proxy);
        this.audioEnabled = enableAudio ? AudioManagerImpl.init() : false;
        this.useShutdownHook = useShutdownHook;
        this.bulkDeleteSplittingEnabled = enableBulkDeleteSplitting;
        if (this.bulkDeleteSplittingEnabled) {
            LOG.warn("BulkDeleteSplitting is enabled. For best performance, please look at the javadoc for JDABuilder#setBulkDeleteEnabled(boolean).");
        }
    }

    public void login(String token, int[] sharding) throws IllegalArgumentException, LoginException {
        this.setStatus(JDA.Status.LOGGING_IN);
        LOG.info("JDA starting...");
        if (token == null || token.isEmpty()) {
            throw new IllegalArgumentException("The provided botToken was empty / null.");
        }
        if (sharding != null && (sharding.length != 2 || sharding[0] < 0 || sharding[0] >= sharding[1] || sharding[1] < 2)) {
            throw new IllegalArgumentException("Sharding array is wrong. please refer to JDABuilder#useSharding for help");
        }
        this.accountManager = new AccountManager(this);
        this.verifyToken(token);
        LOG.info("Login Successful!");
        this.client = new WebSocketClient(this, this.proxy, sharding);
        this.client.setAutoReconnect(this.reconnect);
        if (this.useShutdownHook) {
            Runtime.getRuntime().addShutdownHook(new Thread("JDA Shutdown Hook"){

                @Override
                public void run() {
                    JDAImpl.this.shutdown();
                }
            });
        }
    }

    public void verifyToken(String token) throws LoginException {
        this.authToken = token;
        Requester.Response response = this.getRequester().get("https://discordapp.com/api/users/@me");
        if (response.isOk()) {
            JSONObject json = response.getObject();
            if (!json.has("bot") || !json.getBoolean("bot")) {
                throw new RuntimeException("Attempted to login as a BOT with a CLIENT token!");
            }
        } else {
            if (response.isRateLimit()) {
                throw new RateLimitedException(response.getObject().getInt("retry_after"));
            }
            if (response.code == 401) {
                throw new LoginException("The provided token was invalid!");
            }
            throw new LoginException("When verifying the authenticity of the provided token, Discord returned an unknown response:\n" + response.toString());
        }
    }

    @Override
    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String token) {
        this.authToken = token;
    }

    @Override
    public JDA.Status getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(JDA.Status status) {
        JDA.Status status2 = this.status;
        synchronized (status2) {
            JDA.Status oldStatus = this.status;
            this.status = status;
            this.eventManager.handle(new StatusChangeEvent(this, status, oldStatus));
        }
    }

    @Override
    public void setEventManager(IEventManager manager) {
        this.eventManager = manager;
    }

    @Override
    public void addEventListener(Object listener) {
        this.getEventManager().register(listener);
    }

    @Override
    public void removeEventListener(Object listener) {
        this.getEventManager().unregister(listener);
    }

    @Override
    public List<Object> getRegisteredListeners() {
        return Collections.unmodifiableList(this.getEventManager().getRegisteredListeners());
    }

    public IEventManager getEventManager() {
        return this.eventManager;
    }

    public WebSocketClient getClient() {
        return this.client;
    }

    public Map<String, User> getUserMap() {
        return this.userMap;
    }

    public Map<String, Emote> getEmoteMap() {
        return this.emoteMap;
    }

    @Override
    public List<User> getUsers() {
        return Collections.unmodifiableList(new LinkedList<User>(this.userMap.values()));
    }

    @Override
    public User getUserById(String id) {
        return this.userMap.get(id);
    }

    @Override
    public List<User> getUsersByName(String name) {
        return Collections.unmodifiableList(this.userMap.values().stream().filter(u -> u.getUsername().equals(name)).collect(Collectors.toList()));
    }

    public Map<String, Guild> getGuildMap() {
        return this.guildMap;
    }

    @Override
    public List<Guild> getGuilds() {
        return Collections.unmodifiableList(new LinkedList<Guild>(this.guildMap.values()));
    }

    @Override
    public List<Guild> getGuildsByName(String name) {
        return Collections.unmodifiableList(this.guildMap.values().stream().filter(guild -> guild.getName().equals(name)).collect(Collectors.toList()));
    }

    @Override
    public List<TextChannel> getTextChannelsByName(String name) {
        return Collections.unmodifiableList(this.textChannelMap.values().stream().filter(channel -> channel.getName().equals(name)).collect(Collectors.toList()));
    }

    @Override
    public List<VoiceChannel> getVoiceChannelByName(String name) {
        return Collections.unmodifiableList(this.voiceChannelMap.values().stream().filter(channel -> channel.getName().equals(name)).collect(Collectors.toList()));
    }

    @Override
    public List<PrivateChannel> getPrivateChannels() {
        return Collections.unmodifiableList(new LinkedList<PrivateChannel>(this.pmChannelMap.values()));
    }

    @Override
    public Guild getGuildById(String id) {
        return this.guildMap.get(id);
    }

    public Map<String, TextChannel> getChannelMap() {
        return this.textChannelMap;
    }

    @Override
    public List<TextChannel> getTextChannels() {
        return Collections.unmodifiableList(new LinkedList<TextChannel>(this.textChannelMap.values()));
    }

    @Override
    public TextChannel getTextChannelById(String id) {
        return this.textChannelMap.get(id);
    }

    public Map<String, VoiceChannel> getVoiceChannelMap() {
        return this.voiceChannelMap;
    }

    @Override
    public List<VoiceChannel> getVoiceChannels() {
        return Collections.unmodifiableList(new LinkedList<VoiceChannel>(this.voiceChannelMap.values()));
    }

    @Override
    public VoiceChannel getVoiceChannelById(String id) {
        return this.voiceChannelMap.get(id);
    }

    @Override
    public PrivateChannel getPrivateChannelById(String id) {
        return this.pmChannelMap.get(id);
    }

    public Map<String, PrivateChannel> getPmChannelMap() {
        return this.pmChannelMap;
    }

    public Map<String, String> getOffline_pms() {
        return this.offline_pms;
    }

    public Map<Guild, AudioManager> getAudioManagersMap() {
        return this.audioManagers;
    }

    @Override
    public SelfInfo getSelfInfo() {
        return this.selfInfo;
    }

    @Override
    public List<Emote> getAvailableEmotes() {
        return Collections.unmodifiableList(new LinkedList<Emote>(this.emoteMap.values()));
    }

    @Override
    public Emote getEmoteById(String id) {
        return this.getEmoteMap().get(id);
    }

    public void setSelfInfo(SelfInfo selfInfo) {
        this.selfInfo = selfInfo;
    }

    @Override
    public int getResponseTotal() {
        return this.responseTotal;
    }

    public void setResponseTotal(int responseTotal) {
        this.responseTotal = responseTotal;
    }

    public Requester getRequester() {
        return this.requester;
    }

    @Override
    public HttpHost getGlobalProxy() {
        return this.proxy;
    }

    @Override
    public AccountManager getAccountManager() {
        return this.accountManager;
    }

    @Override
    public void setAutoReconnect(boolean reconnect) {
        this.reconnect = reconnect;
        if (this.client != null) {
            this.client.setAutoReconnect(reconnect);
        }
    }

    @Override
    public boolean isAutoReconnect() {
        return this.reconnect;
    }

    @Override
    public boolean isAudioEnabled() {
        return this.audioEnabled;
    }

    @Override
    public boolean isBulkDeleteSplittingEnabled() {
        return this.bulkDeleteSplittingEnabled;
    }

    @Override
    public void shutdown() {
        this.shutdown(true);
    }

    @Override
    public void shutdown(boolean free) {
        this.setStatus(JDA.Status.SHUTTING_DOWN);
        TextChannelImpl.AsyncMessageSender.stopAll(this);
        this.audioManagers.values().forEach(mng -> mng.closeAudioConnection());
        this.client.setAutoReconnect(false);
        this.client.close();
        this.authToken = null;
        if (free) {
            try {
                Unirest.shutdown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.setStatus(JDA.Status.SHUTDOWN);
    }

    public void setMessageTimeout(String ratelimitIdentifier, long timeout) {
        this.messageRatelimitTimeouts.put(ratelimitIdentifier, System.currentTimeMillis() + timeout);
    }

    public Long getMessageLimit(String ratelimitIdentifier) {
        Long messageRatelimitTimeout = this.messageRatelimitTimeouts.get(ratelimitIdentifier);
        if (messageRatelimitTimeout != null && messageRatelimitTimeout < System.currentTimeMillis()) {
            messageRatelimitTimeout = null;
            this.messageRatelimitTimeouts.remove(ratelimitIdentifier);
        }
        return messageRatelimitTimeout;
    }

    @Override
    public synchronized AudioManager getAudioManager(Guild guild) {
        if (!this.audioEnabled) {
            throw new IllegalStateException("Audio is disabled. Cannot retrieve an AudioManager while audio is disabled.");
        }
        AudioManager manager = this.audioManagers.get(guild);
        if (manager == null) {
            manager = new AudioManagerImpl(guild);
            this.audioManagers.put(guild, manager);
        }
        return manager;
    }

    @Override
    public void installAuxiliaryCable(int port) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Nice try m8!");
    }

    protected static class AsyncCallback
    implements EventListener {
        protected final Consumer<GuildManager> cb;
        protected final String id;

        public AsyncCallback(Consumer<GuildManager> cb, String guildId) {
            this.cb = cb;
            this.id = guildId;
        }

        @Override
        @SubscribeEvent
        public void onEvent(Event event) {
            if (event instanceof GuildJoinEvent && ((GuildJoinEvent)event).getGuild().getId().equals(this.id)) {
                event.getJDA().removeEventListener(this);
                this.cb.accept(((GuildJoinEvent)event).getGuild().getManager());
            }
        }
    }
}

