/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.entities.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.dv8tion.jda.entities.Emote;
import net.dv8tion.jda.entities.Guild;

public class EmoteImpl
implements Emote {
    private static final String EMOTE_URL_PREFIX = "https://discordcdn.com/emojis/";
    private final String id;
    private final String name;
    private List<Guild> guilds = new LinkedList<Guild>();

    public EmoteImpl(String name, String id) {
        this.id = id;
        this.name = name;
    }

    public EmoteImpl addGuild(Guild ... guilds) {
        for (Guild g : guilds) {
            if (this.guilds.contains(g)) continue;
            this.guilds.add(g);
        }
        return this;
    }

    public EmoteImpl removeGuild(Guild guild) {
        if (this.guilds.contains(guild)) {
            this.guilds.remove(guild);
        }
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAvailable() {
        return !this.guilds.isEmpty();
    }

    @Override
    public List<Guild> getGuilds() {
        return Collections.unmodifiableList(this.guilds);
    }

    @Override
    public String getImageUrl() {
        return EMOTE_URL_PREFIX + this.getId() + ".png";
    }

    @Override
    public String getAsEmote() {
        return "<:" + this.getName() + ":" + this.getId() + ">";
    }

    public String toString() {
        return "E:" + (this.isAvailable() ? this.getAsEmote() : this.getName()) + "(" + this.getId() + ")";
    }
}

