/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.entities;

import java.time.OffsetDateTime;
import java.util.List;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.Region;
import net.dv8tion.jda.entities.Emote;
import net.dv8tion.jda.entities.Role;
import net.dv8tion.jda.entities.TextChannel;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.VoiceChannel;
import net.dv8tion.jda.entities.VoiceStatus;
import net.dv8tion.jda.managers.AudioManager;
import net.dv8tion.jda.managers.ChannelManager;
import net.dv8tion.jda.managers.GuildManager;
import net.dv8tion.jda.managers.RoleManager;
import net.dv8tion.jda.utils.InviteUtil;

public interface Guild {
    public String getId();

    public String getName();

    public String getIconId();

    public String getIconUrl();

    public String getAfkChannelId();

    public String getOwnerId();

    public User getOwner();

    public int getAfkTimeout();

    public Region getRegion();

    public List<Emote> getEmotes();

    public List<User> getUsers();

    public boolean isMember(User var1);

    public List<TextChannel> getTextChannels();

    public ChannelManager createTextChannel(String var1);

    public List<VoiceChannel> getVoiceChannels();

    public ChannelManager createVoiceChannel(String var1);

    public List<Role> getRoles();

    public Role getRoleById(String var1);

    public RoleManager createRole();

    public RoleManager createCopyOfRole(Role var1);

    public List<Role> getRolesForUser(User var1);

    public Role getColorDeterminantRoleForUser(User var1);

    public List<User> getUsersWithRole(Role var1);

    public Role getPublicRole();

    public TextChannel getPublicChannel();

    public OffsetDateTime getJoinDateForUser(User var1);

    public GuildManager getManager();

    public AudioManager getAudioManager();

    public JDA getJDA();

    public VoiceStatus getVoiceStatusOfUser(User var1);

    public List<VoiceStatus> getVoiceStatuses();

    public String getNicknameForUser(User var1);

    public VerificationLevel getVerificationLevel();

    public boolean checkVerification();

    public boolean isAvailable();

    public List<InviteUtil.AdvancedInvite> getInvites();

    public User getUserById(String var1);

    public List<User> getUsersByName(String var1);

    public List<Role> getRolesByName(String var1);

    public String getEffectiveNameForUser(User var1);

    public static enum VerificationLevel {
        NONE(0),
        LOW(1),
        MEDIUM(2),
        HIGH(3);

        private final int key;

        private VerificationLevel(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        public static VerificationLevel fromKey(int key) {
            for (VerificationLevel level : VerificationLevel.values()) {
                if (level.getKey() != key) continue;
                return level;
            }
            return NONE;
        }
    }
}

