/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.entities;

public interface Game {
    public String getName();

    public String getUrl();

    public GameType getType();

    public static boolean isValidStreamingUrl(String url) {
        return url != null && url.matches("^https?:\\/\\/(www\\.)?twitch\\.tv\\/.+");
    }

    public static enum GameType {
        DEFAULT(0),
        TWITCH(1);

        private final int key;

        private GameType(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        public static GameType fromKey(int key) {
            for (GameType level : GameType.values()) {
                if (level.getKey() != key) continue;
                return level;
            }
            return DEFAULT;
        }
    }
}

