/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.audio;

import com.sun.jna.ptr.PointerByReference;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import net.dv8tion.jda.audio.AudioPacket;
import tomp2p.opuswrapper.Opus;

public class Decoder {
    protected int ssrc;
    protected char lastSeq;
    protected int lastTimestamp;
    protected PointerByReference opusDecoder;

    protected Decoder(int ssrc) {
        this.ssrc = ssrc;
        this.lastSeq = (char)65535;
        this.lastTimestamp = -1;
        IntBuffer error = IntBuffer.allocate(4);
        this.opusDecoder = Opus.INSTANCE.opus_decoder_create(48000, 2, error);
    }

    protected boolean isInOrder(char newSeq) {
        return this.lastSeq == '\uffffffff' || newSeq > this.lastSeq || this.lastSeq - newSeq > 10;
    }

    protected boolean wasPacketLost(char newSeq) {
        return newSeq > this.lastSeq + '\u0001';
    }

    protected short[] decodeFromOpus(AudioPacket decryptedPacket) {
        int result;
        ShortBuffer decoded = ShortBuffer.allocate(4096);
        if (decryptedPacket == null) {
            result = Opus.INSTANCE.opus_decode(this.opusDecoder, null, 0, decoded, 960, 0);
            this.lastSeq = (char)65535;
            this.lastTimestamp = -1;
        } else {
            char seq;
            this.lastSeq = seq = decryptedPacket.getSequence();
            this.lastTimestamp = decryptedPacket.getTimestamp();
            byte[] encodedAudio = decryptedPacket.getEncodedAudio();
            result = Opus.INSTANCE.opus_decode(this.opusDecoder, encodedAudio, encodedAudio.length, decoded, 960, 0);
        }
        if (result < 0) {
            return null;
        }
        short[] audio = new short[result * 2];
        decoded.get(audio);
        return audio;
    }

    protected void close() {
        Opus.INSTANCE.opus_decoder_destroy(this.opusDecoder);
    }
}

