/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.utils;

import java.util.List;
import java.util.Map;
import net.dv8tion.jda.Permission;
import net.dv8tion.jda.entities.Channel;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.PermissionOverride;
import net.dv8tion.jda.entities.Role;
import net.dv8tion.jda.entities.TextChannel;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.impl.GuildImpl;
import net.dv8tion.jda.entities.impl.PermissionOverrideImpl;
import net.dv8tion.jda.entities.impl.TextChannelImpl;
import net.dv8tion.jda.entities.impl.VoiceChannelImpl;

public class PermissionUtil {
    public static boolean canInteract(User issuer, User target, Guild guild) {
        if (guild.getOwner() == issuer) {
            return true;
        }
        if (guild.getOwner() == target) {
            return false;
        }
        List<Role> issuerRoles = guild.getRolesForUser(issuer);
        List<Role> targetRoles = guild.getRolesForUser(target);
        if (issuerRoles == null) {
            throw new IllegalArgumentException("Issuer user is not in the provided guild!");
        }
        if (targetRoles == null) {
            throw new IllegalArgumentException("Target user is not in the provided guild!");
        }
        return !issuerRoles.isEmpty() && (targetRoles.isEmpty() || PermissionUtil.canInteract(issuerRoles.get(0), targetRoles.get(0)));
    }

    public static boolean canInteract(User issuer, Role target) {
        if (target.getGuild().getOwner() == issuer) {
            return true;
        }
        List<Role> issuerRoles = target.getGuild().getRolesForUser(issuer);
        if (issuerRoles == null) {
            throw new IllegalArgumentException("Issuer User is not in the guild that the target Role is a part of!");
        }
        return !issuerRoles.isEmpty() && PermissionUtil.canInteract(issuerRoles.get(0), target);
    }

    public static boolean canInteract(Role issuer, Role target) {
        if (issuer.getGuild() != target.getGuild()) {
            throw new IllegalArgumentException("The 2 Roles are not from same Guild!");
        }
        return target.getPosition() < issuer.getPosition();
    }

    public static PermissionOverride getFullPermOverride() {
        PermissionOverrideImpl override = new PermissionOverrideImpl(null, null, null);
        int allow = 0;
        int deny = 0;
        for (Permission permission : Permission.values()) {
            if (permission == Permission.UNKNOWN) continue;
            allow |= 1 << permission.getOffset();
        }
        return override.setAllow(allow).setDeny(deny);
    }

    public static boolean canTalk(TextChannel channel) {
        return PermissionUtil.canTalk(channel.getJDA().getSelfInfo(), channel);
    }

    public static boolean canTalk(User user, TextChannel channel) {
        return PermissionUtil.checkPermission(channel, user, Permission.MESSAGE_READ, Permission.MESSAGE_WRITE);
    }

    @Deprecated
    public static boolean checkPermission(User user, Permission perm, Channel channel) {
        if (channel instanceof TextChannel) {
            return PermissionUtil.checkPermission(user, perm, (GuildImpl)channel.getGuild(), ((TextChannelImpl)channel).getRolePermissionOverridesMap(), ((TextChannelImpl)channel).getUserPermissionOverridesMap());
        }
        return PermissionUtil.checkPermission(user, perm, (GuildImpl)channel.getGuild(), ((VoiceChannelImpl)channel).getRolePermissionOverridesMap(), ((VoiceChannelImpl)channel).getUserPermissionOverridesMap());
    }

    @Deprecated
    public static boolean checkPermission(User user, Permission perm, Guild guild) {
        if (guild.getRolesForUser(user) == null) {
            throw new IllegalArgumentException("Provided user is not in the provided guild");
        }
        return guild.getOwnerId().equals(user.getId()) || guild.getPublicRole().hasPermission(Permission.ADMINISTRATOR) || guild.getPublicRole().hasPermission(perm) || guild.getRolesForUser(user).stream().anyMatch(role -> role.hasPermission(Permission.ADMINISTRATOR) || role.hasPermission(perm));
    }

    public static boolean checkPermission(Channel channel, User user, Permission ... permissions) {
        if (channel.getGuild().getOwnerId().equals(user.getId()) || channel.getGuild().getPublicRole().hasPermission(Permission.ADMINISTRATOR) || channel.getGuild().getRolesForUser(user).stream().anyMatch(role -> role.hasPermission(Permission.ADMINISTRATOR))) {
            return true;
        }
        if (channel instanceof TextChannel) {
            for (Permission perm : permissions) {
                if (PermissionUtil.checkPermission(user, perm, (GuildImpl)channel.getGuild(), ((TextChannelImpl)channel).getRolePermissionOverridesMap(), ((TextChannelImpl)channel).getUserPermissionOverridesMap())) continue;
                return false;
            }
        } else {
            for (Permission perm : permissions) {
                if (PermissionUtil.checkPermission(user, perm, (GuildImpl)channel.getGuild(), ((VoiceChannelImpl)channel).getRolePermissionOverridesMap(), ((VoiceChannelImpl)channel).getUserPermissionOverridesMap())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean checkPermission(Guild guild, User user, Permission ... permissions) {
        if (guild.getRolesForUser(user) == null) {
            throw new IllegalArgumentException("Provided user is not in the provided guild");
        }
        if (guild.getOwnerId().equals(user.getId()) || guild.getPublicRole().hasPermission(Permission.ADMINISTRATOR) || guild.getRolesForUser(user).stream().anyMatch(role -> role.hasPermission(Permission.ADMINISTRATOR))) {
            return true;
        }
        for (Permission perm : permissions) {
            if (guild.getPublicRole().hasPermission(perm) || guild.getRolesForUser(user).parallelStream().anyMatch(role -> role.hasPermission(perm))) continue;
            return false;
        }
        return true;
    }

    public static int getEffectivePermission(User user, Channel channel) {
        if (channel instanceof TextChannel) {
            return PermissionUtil.getEffectivePermission(user, (GuildImpl)channel.getGuild(), ((TextChannelImpl)channel).getRolePermissionOverridesMap(), ((TextChannelImpl)channel).getUserPermissionOverridesMap());
        }
        return PermissionUtil.getEffectivePermission(user, (GuildImpl)channel.getGuild(), ((VoiceChannelImpl)channel).getRolePermissionOverridesMap(), ((VoiceChannelImpl)channel).getUserPermissionOverridesMap());
    }

    public static int getEffectivePermission(User user, Guild guild) {
        int permission = guild.getPublicRole().getPermissionsRaw();
        List<Role> rolesOfUser = guild.getRolesForUser(user);
        if (rolesOfUser == null) {
            throw new IllegalArgumentException("Provided user is not in the provided guild");
        }
        for (Role role : rolesOfUser) {
            permission |= role.getPermissionsRaw();
        }
        return permission;
    }

    private static boolean checkPermission(User user, Permission perm, GuildImpl guild, Map<Role, PermissionOverride> roleOverrides, Map<User, PermissionOverride> userOverrides) {
        if (guild.getOwnerId().equals(user.getId())) {
            return true;
        }
        int effectivePerms = PermissionUtil.getEffectivePermission(user, guild, roleOverrides, userOverrides);
        return (effectivePerms & 1 << Permission.ADMINISTRATOR.getOffset() | effectivePerms & 1 << perm.getOffset()) > 0;
    }

    private static int getEffectivePermission(User user, GuildImpl guild, Map<Role, PermissionOverride> roleOverrides, Map<User, PermissionOverride> userOverrides) {
        PermissionOverride userOverride;
        int permission = PermissionUtil.getEffectivePermission(user, guild);
        List<Role> rolesOfUser = guild.getRolesForUser(user);
        PermissionOverride override = roleOverrides.get(guild.getPublicRole());
        if (override != null) {
            permission = PermissionUtil.apply(permission, override.getAllowedRaw(), override.getDeniedRaw());
        }
        int allow = -1;
        int deny = -1;
        for (Role role : rolesOfUser) {
            PermissionOverride po = roleOverrides.get(role);
            if (po == null) continue;
            if (allow == -1 || deny == -1) {
                allow = po.getAllowedRaw();
                deny = po.getDeniedRaw();
                continue;
            }
            allow = po.getAllowedRaw() | allow;
            deny = (po.getDeniedRaw() | deny) & ~allow;
        }
        if (allow != -1 && deny != -1) {
            permission = PermissionUtil.apply(permission, allow, deny);
        }
        if ((userOverride = userOverrides.get(user)) != null) {
            permission = PermissionUtil.apply(permission, userOverride.getAllowedRaw(), userOverride.getDeniedRaw());
        }
        return permission;
    }

    private static int apply(int permission, int allow, int deny) {
        permission |= allow;
        return permission &= ~deny;
    }
}

