/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.utils;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.Permission;
import net.dv8tion.jda.entities.Channel;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.PermissionOverride;
import net.dv8tion.jda.entities.PrivateChannel;
import net.dv8tion.jda.entities.Role;
import net.dv8tion.jda.entities.TextChannel;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.handle.EntityBuilder;
import org.json.JSONArray;
import org.json.JSONObject;

public class DebugUtil {
    public static JSONObject fromJDA(JDA jda) {
        return DebugUtil.fromJDA(jda, true, true, true, true, true);
    }

    public static JSONObject fromJDA(JDA iJDA, boolean includeUsers, boolean includeGuilds, boolean includeGuildUsers, boolean includeChannels, boolean includePrivateChannels) {
        JDAImpl jda = (JDAImpl)iJDA;
        JSONObject obj = new JSONObject();
        obj.put("self_info", DebugUtil.fromUser(jda.getSelfInfo())).put("proxy", jda.getGlobalProxy() == null ? JSONObject.NULL : new JSONObject().put("host", jda.getGlobalProxy().getHostName()).put("port", jda.getGlobalProxy().getPort())).put("response_total", jda.getResponseTotal()).put("audio_enabled", jda.isAudioEnabled()).put("auto_reconnect", jda.isAutoReconnect());
        JSONArray array = new JSONArray();
        for (Object object : jda.getRegisteredListeners()) {
            array.put(object.getClass().getCanonicalName());
        }
        obj.put("event_listeners", array);
        try {
            Field f = EntityBuilder.class.getDeclaredField("cachedJdaGuildJsons");
            f.setAccessible(true);
            HashMap hashMap = (HashMap)((HashMap)f.get(null)).get(jda);
            array = new JSONArray();
            for (String guildId : hashMap.keySet()) {
                array.put(guildId);
            }
            obj.put("second_pass_json_guild_ids", array);
            f = EntityBuilder.class.getDeclaredField("cachedJdaGuildCallbacks");
            f.setAccessible(true);
            HashMap cachedCallbacks = (HashMap)((HashMap)f.get(null)).get(jda);
            array = new JSONArray();
            for (String guildId : cachedCallbacks.keySet()) {
                array.put(guildId);
            }
            obj.put("second_pass_callback_guild_ids", array);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (includeGuilds) {
            array = new JSONArray();
            for (Guild guild : jda.getGuilds()) {
                array.put(DebugUtil.fromGuild(guild, includeGuildUsers, includeChannels, true, true));
            }
            obj.put("guilds", array);
        }
        if (includePrivateChannels) {
            array = new JSONArray();
            for (PrivateChannel privateChannel : jda.getPrivateChannels()) {
                array.put(DebugUtil.fromPrivateChannel(privateChannel, false));
            }
            obj.put("private_channels", array);
            array = new JSONArray();
            for (Map.Entry entry : jda.getOffline_pms().entrySet()) {
                array.put(new JSONObject().put("id", entry.getValue()).put("user_id", entry.getKey()));
            }
            obj.put("offline_private_channels", array);
        }
        if (includeUsers) {
            array = new JSONArray();
            for (User user : jda.getUsers()) {
                array.put(DebugUtil.fromUser(user));
            }
            obj.put("users", array);
        }
        return obj;
    }

    public static JSONObject fromGuild(Guild guild) {
        return DebugUtil.fromGuild(guild, true, true, true, true);
    }

    public static JSONObject fromGuild(Guild guild, boolean includeUsers, boolean includeChannels, boolean includeRoles, boolean includeVoiceStatuses) {
        JSONObject obj = new JSONObject();
        obj.put("id", guild.getId()).put("name", guild.getName()).put("owner_id", guild.getOwner().getId()).put("region", (Object)guild.getRegion()).put("icon_url", guild.getIconUrl()).put("available", guild.isAvailable()).put("verification_level", (Object)guild.getVerificationLevel()).put("verification_passed", guild.checkVerification()).put("afk_timeout", guild.getAfkTimeout()).put("afk_channel_id", guild.getAfkChannelId());
        JSONArray array = new JSONArray();
        for (Channel channel : guild.getTextChannels()) {
            array.put(channel.getId());
        }
        obj.put("text_channel_ids", array);
        array = new JSONArray();
        for (Channel channel : guild.getVoiceChannels()) {
            array.put(channel.getId());
        }
        obj.put("text_channel_ids", array);
        array = new JSONArray();
        for (Role role : guild.getRoles()) {
            array.put(role.getId());
        }
        obj.put("role_ids", array);
        if (includeChannels) {
            array = new JSONArray();
            for (Channel channel : guild.getTextChannels()) {
                array.put(DebugUtil.fromGuildChannel(channel, false, false, true));
            }
            obj.put("text_channels", array);
            array = new JSONArray();
            for (Channel channel : guild.getVoiceChannels()) {
                array.put(DebugUtil.fromGuildChannel(channel, false, false, true));
            }
            obj.put("voice_channels", array);
        }
        if (includeRoles) {
            array = new JSONArray();
            for (Role role : guild.getRoles()) {
                array.put(DebugUtil.fromRole(role, false, true, true));
            }
            obj.put("roles", array);
        }
        return obj;
    }

    public static JSONObject fromGuildChannel(Channel chan) {
        return DebugUtil.fromGuildChannel(chan, true, true, true);
    }

    public static JSONObject fromPrivateChannel(PrivateChannel chan, boolean includeUser) {
        JSONObject obj = new JSONObject();
        obj.put("id", chan.getId()).put("user_id", chan.getUser().getId());
        if (includeUser) {
            obj.put("user", DebugUtil.fromUser(chan.getUser()));
        }
        return obj;
    }

    public static JSONObject fromGuildChannel(Channel chan, boolean includeUsers, boolean includeGuild, boolean includePermOverrides) {
        JSONObject obj = new JSONObject();
        obj.put("id", chan.getId()).put("name", chan.getName()).put("position", chan.getPosition()).put("position_raw", chan.getPositionRaw()).put("guild_id", chan.getGuild().getId());
        if (chan instanceof TextChannel) {
            obj.put("topic", chan.getTopic());
        }
        if (includePermOverrides) {
            JSONArray permsArray = new JSONArray();
            for (PermissionOverride permOver : chan.getUserPermissionOverrides()) {
                permsArray.put(DebugUtil.fromPermOverride(permOver, false, false, false, true));
            }
            obj.put("user_permission_overrides", permsArray);
            permsArray = new JSONArray();
            for (PermissionOverride permOver : chan.getRolePermissionOverrides()) {
                permsArray.put(DebugUtil.fromPermOverride(permOver, false, false, false, true));
            }
            obj.put("role_permission_overrides", permsArray);
        }
        if (includeGuild) {
            obj.put("guild", DebugUtil.fromGuild(chan.getGuild(), false, false, false, false));
        }
        if (includeUsers) {
            JSONArray userArray = new JSONArray();
            for (User user : chan.getUsers()) {
                userArray.put(DebugUtil.fromUser(user));
            }
            obj.put("users", userArray);
        }
        return obj;
    }

    public static JSONObject fromUser(User user) {
        JSONObject obj = new JSONObject();
        obj.put("id", user.getId()).put("username", user.getUsername()).put("disc", user.getDiscriminator()).put("avatar_url", user.getAvatarUrl()).put("online_status", (Object)user.getOnlineStatus()).put("current_game", user.getCurrentGame()).put("is_bot", user.isBot());
        return obj;
    }

    public static JSONObject fromRole(Role role) {
        return DebugUtil.fromRole(role, true, true, true);
    }

    public static JSONObject fromRole(Role role, boolean includeGuild, boolean includeUsers, boolean includePermissions) {
        JSONObject obj = new JSONObject();
        obj.put("id", role.getId()).put("name", role.getName()).put("position", role.getPosition()).put("position_raw", role.getPositionRaw()).put("color", role.getColor()).put("hoisted", role.isGrouped()).put("managed", role.isManaged()).put("mentionable", role.isMentionable()).put("guild_id", role.getGuild().getId()).put("permissions_raw", role.getPermissionsRaw());
        if (includeGuild) {
            obj.put("guild", DebugUtil.fromGuild(role.getGuild(), false, false, false, false));
        }
        if (includeUsers) {
            JSONArray userArray = new JSONArray();
            for (User user : role.getGuild().getUsersWithRole(role)) {
                userArray.put(user.getId());
            }
            obj.put("users", userArray);
        }
        if (includePermissions) {
            JSONArray permArray = new JSONArray();
            for (Permission perm : role.getPermissions()) {
                permArray.put(perm.toString());
            }
            obj.put("permissions", permArray);
        }
        return obj;
    }

    public static JSONObject fromPermOverride(PermissionOverride permOver) {
        return DebugUtil.fromPermOverride(permOver, true, true, true, true);
    }

    public static JSONObject fromPermOverride(PermissionOverride permOver, boolean includeGuild, boolean includeChannel, boolean includeRoleOrUserInfo, boolean includePermissions) {
        JSONObject obj = new JSONObject();
        obj.put("type", permOver.isRoleOverride() ? "role" : "user").put("allowed_raw", permOver.getAllowedRaw()).put("inherited_raw", permOver.getInheritRaw()).put("denied_raw", permOver.getDeniedRaw()).put("channel_id", permOver.getChannel().getId()).put("guild_id", permOver.getGuild().getId());
        if (permOver.isRoleOverride()) {
            obj.put("role_id", permOver.getRole().getId());
        } else {
            obj.put("user_id", permOver.getUser().getId());
        }
        if (includePermissions) {
            JSONArray permArray = new JSONArray();
            for (Permission perm : permOver.getAllowed()) {
                permArray.put(perm.toString());
            }
            obj.put("allowed_perms", permArray);
            permArray = new JSONArray();
            for (Permission perm : permOver.getInherit()) {
                permArray.put(perm.toString());
            }
            obj.put("inherited_perms", permArray);
            permArray = new JSONArray();
            for (Permission perm : permOver.getDenied()) {
                permArray.put(perm.toString());
            }
            obj.put("denied_perms", permArray);
        }
        if (includeChannel) {
            obj.put("channel", DebugUtil.fromGuildChannel(permOver.getChannel()));
        }
        if (includeGuild) {
            obj.put("guild", DebugUtil.fromGuild(permOver.getGuild()));
        }
        if (includeRoleOrUserInfo) {
            if (permOver.isRoleOverride()) {
                obj.put("role", DebugUtil.fromRole(permOver.getRole(), false, false, includePermissions));
            } else {
                obj.put("user", permOver.getUser());
            }
        }
        return obj;
    }
}

