/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.utils;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import javax.imageio.ImageIO;
import net.dv8tion.jda.entities.impl.JDAImpl;
import org.apache.commons.codec.binary.StringUtils;

public class AvatarUtil {
    public static final Avatar DELETE_AVATAR = new Avatar(null);
    private static final int SIZE = 128;

    public static Avatar getAvatar(File avatarFile) throws UnsupportedEncodingException {
        String[] split = avatarFile.getName().split("\\.");
        String type = split[split.length - 1];
        if (type.equalsIgnoreCase("jpg") || type.equalsIgnoreCase("jpeg") || type.equalsIgnoreCase("png")) {
            try {
                BufferedImage img = ImageIO.read(avatarFile);
                return AvatarUtil.getAvatar(img);
            }
            catch (IOException e) {
                JDAImpl.LOG.log(e);
            }
        } else {
            throw new UnsupportedEncodingException("Image type " + type + " is not supported!");
        }
        return null;
    }

    public static Avatar getAvatar(InputStream inputStream) {
        try {
            BufferedImage img = ImageIO.read(inputStream);
            return AvatarUtil.getAvatar(img);
        }
        catch (IOException e) {
            JDAImpl.LOG.log(e);
            return null;
        }
    }

    public static Avatar getAvatar(BufferedImage img) {
        try {
            img = AvatarUtil.resize(img);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "jpg", bout);
            bout.close();
            return new Avatar("data:image/jpeg;base64," + StringUtils.newStringUtf8(Base64.getEncoder().encode(bout.toByteArray())));
        }
        catch (IOException e) {
            JDAImpl.LOG.log(e);
            return null;
        }
    }

    private static BufferedImage resize(BufferedImage originalImage) {
        BufferedImage resizedImage = new BufferedImage(128, 128, 1);
        Graphics2D g = resizedImage.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawImage(originalImage, 0, 0, 128, 128, Color.white, null);
        g.dispose();
        return resizedImage;
    }

    public static class Avatar {
        private final String encoded;

        private Avatar(String encoded) {
            this.encoded = encoded;
        }

        public String getEncoded() {
            return this.encoded;
        }
    }
}

