/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.requests;

import com.neovisionaries.ws.client.ProxySettings;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.audio.AudioReceiveHandler;
import net.dv8tion.jda.audio.AudioSendHandler;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.VoiceChannel;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.entities.impl.TextChannelImpl;
import net.dv8tion.jda.events.DisconnectEvent;
import net.dv8tion.jda.events.ReadyEvent;
import net.dv8tion.jda.events.ReconnectedEvent;
import net.dv8tion.jda.events.ResumedEvent;
import net.dv8tion.jda.events.ShutdownEvent;
import net.dv8tion.jda.handle.ChannelCreateHandler;
import net.dv8tion.jda.handle.ChannelDeleteHandler;
import net.dv8tion.jda.handle.ChannelUpdateHandler;
import net.dv8tion.jda.handle.EntityBuilder;
import net.dv8tion.jda.handle.EventCache;
import net.dv8tion.jda.handle.GuildEmojisUpdateHandler;
import net.dv8tion.jda.handle.GuildJoinHandler;
import net.dv8tion.jda.handle.GuildLeaveHandler;
import net.dv8tion.jda.handle.GuildMemberAddHandler;
import net.dv8tion.jda.handle.GuildMemberBanHandler;
import net.dv8tion.jda.handle.GuildMemberRemoveHandler;
import net.dv8tion.jda.handle.GuildMemberUpdateHandler;
import net.dv8tion.jda.handle.GuildMembersChunkHandler;
import net.dv8tion.jda.handle.GuildRoleCreateHandler;
import net.dv8tion.jda.handle.GuildRoleDeleteHandler;
import net.dv8tion.jda.handle.GuildRoleUpdateHandler;
import net.dv8tion.jda.handle.GuildUpdateHandler;
import net.dv8tion.jda.handle.MessageBulkDeleteHandler;
import net.dv8tion.jda.handle.MessageDeleteHandler;
import net.dv8tion.jda.handle.MessageEmbedHandler;
import net.dv8tion.jda.handle.MessageReceivedHandler;
import net.dv8tion.jda.handle.MessageUpdateHandler;
import net.dv8tion.jda.handle.PresenceUpdateHandler;
import net.dv8tion.jda.handle.ReadyHandler;
import net.dv8tion.jda.handle.UserTypingHandler;
import net.dv8tion.jda.handle.UserUpdateHandler;
import net.dv8tion.jda.handle.VoiceChangeHandler;
import net.dv8tion.jda.handle.VoiceServerUpdateHandler;
import net.dv8tion.jda.managers.AudioManager;
import net.dv8tion.jda.managers.impl.AudioManagerImpl;
import net.dv8tion.jda.requests.GuildLock;
import net.dv8tion.jda.requests.WebSocketCustomHandler;
import net.dv8tion.jda.utils.SimpleLog;
import org.apache.http.HttpHost;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WebSocketClient
extends WebSocketAdapter
implements WebSocketListener {
    public static final SimpleLog LOG = SimpleLog.getLog("JDASocket");
    protected final JDAImpl api;
    protected final int[] sharding;
    protected final HttpHost proxy;
    protected WebSocket socket;
    protected String gatewayUrl = null;
    protected String sessionId = null;
    protected volatile Thread keepAliveThread;
    protected boolean connected;
    protected boolean initiating;
    protected final List<JSONObject> cachedEvents = new LinkedList<JSONObject>();
    protected boolean shouldReconnect = true;
    protected int reconnectTimeoutS = 2;
    protected final List<VoiceChannel> dcAudioConnections = new LinkedList<VoiceChannel>();
    protected final Map<String, AudioSendHandler> audioSendHandlers = new HashMap<String, AudioSendHandler>();
    protected final Map<String, AudioReceiveHandler> audioReceivedHandlers = new HashMap<String, AudioReceiveHandler>();
    protected boolean firstInit = true;
    protected WebSocketCustomHandler customHandler;

    public WebSocketClient(JDAImpl api, HttpHost proxy, int[] sharding) {
        this.api = api;
        this.sharding = sharding;
        this.proxy = proxy;
        this.connect();
    }

    public void setAutoReconnect(boolean reconnect) {
        this.shouldReconnect = reconnect;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setCustomHandler(WebSocketCustomHandler customHandler) {
        this.customHandler = customHandler;
    }

    public void ready() {
        if (this.initiating) {
            this.initiating = false;
            this.reconnectTimeoutS = 2;
            if (this.firstInit) {
                this.firstInit = false;
                JDAImpl.LOG.info("Finished Loading!");
                if (this.api.getGuilds().size() >= 2500) {
                    JDAImpl.LOG.warn(" __      __ _    ___  _  _  ___  _  _   ___  _ ");
                    JDAImpl.LOG.warn(" \\ \\    / //_\\  | _ \\| \\| ||_ _|| \\| | / __|| |");
                    JDAImpl.LOG.warn("  \\ \\/\\/ // _ \\ |   /| .` | | | | .` || (_ ||_|");
                    JDAImpl.LOG.warn("   \\_/\\_//_/ \\_\\|_|_\\|_|\\_||___||_|\\_| \\___|(_)");
                    JDAImpl.LOG.warn("You're running a session with over 2500 connected");
                    JDAImpl.LOG.warn("guilds. You should shard the connection in order");
                    JDAImpl.LOG.warn("to split the load or things like resuming");
                    JDAImpl.LOG.warn("connection might not work as expected.");
                    JDAImpl.LOG.warn("For more info see https://git.io/vrFWP");
                }
                this.api.getEventManager().handle(new ReadyEvent(this.api, this.api.getResponseTotal()));
            } else {
                this.restoreAudioHandlers();
                this.reconnectAudioConnections();
                JDAImpl.LOG.info("Finished (Re)Loading!");
                this.api.getEventManager().handle(new ReconnectedEvent(this.api, this.api.getResponseTotal()));
            }
        } else {
            this.reconnectAudioConnections();
            JDAImpl.LOG.info("Successfully resumed Session!");
            this.api.getEventManager().handle(new ResumedEvent(this.api, this.api.getResponseTotal()));
        }
        this.api.setStatus(JDA.Status.CONNECTED);
        LOG.debug("Resending " + this.cachedEvents.size() + " cached events...");
        this.handle(this.cachedEvents);
        LOG.debug("Sending of cached events finished.");
        this.cachedEvents.clear();
    }

    public boolean isReady() {
        return !this.initiating;
    }

    public void handle(List<JSONObject> events) {
        events.forEach(this::handleEvent);
    }

    public void send(String message) {
        LOG.trace("<- " + message);
        this.socket.sendText(message);
    }

    public void close() {
        this.socket.sendClose(1000);
    }

    protected void connect() {
        if (this.api.getStatus() != JDA.Status.ATTEMPTING_TO_RECONNECT) {
            this.api.setStatus(JDA.Status.CONNECTING_TO_WEBSOCKET);
        }
        this.initiating = true;
        WebSocketFactory factory = new WebSocketFactory();
        if (this.proxy != null) {
            ProxySettings settings = factory.getProxySettings();
            settings.setHost(this.proxy.getHostName());
            settings.setPort(this.proxy.getPort());
        }
        try {
            if (this.gatewayUrl == null) {
                this.gatewayUrl = this.getGateway();
                if (this.gatewayUrl == null) {
                    throw new RuntimeException("Could not fetch WS-Gateway!");
                }
            }
            this.socket = factory.createSocket(this.gatewayUrl).addHeader("Accept-Encoding", "gzip").addListener(this);
            this.socket.connect();
        }
        catch (WebSocketException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getGateway() {
        try {
            return this.api.getRequester().get("https://discordapp.com/api/gateway").getObject().getString("url") + "?encoding=json&v=6";
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void onConnected(WebSocket websocket, Map<String, List<String>> headers) {
        this.api.setStatus(JDA.Status.LOADING_SUBSYSTEMS);
        LOG.info("Connected to WebSocket");
        if (this.sessionId == null) {
            this.sendIdentify();
        } else {
            this.sendResume();
        }
        this.connected = true;
    }

    @Override
    public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) {
        this.connected = false;
        this.api.setStatus(JDA.Status.DISCONNECTED);
        if (this.keepAliveThread != null) {
            this.keepAliveThread.interrupt();
            this.keepAliveThread = null;
        }
        if (!this.shouldReconnect) {
            LOG.info("The connection was closed!");
            LOG.info("By remote? " + closedByServer);
            if (serverCloseFrame != null) {
                LOG.info("Reason: " + serverCloseFrame.getCloseReason());
                LOG.info("Close code: " + serverCloseFrame.getCloseCode());
            }
            this.api.setStatus(JDA.Status.SHUTDOWN);
            this.api.getEventManager().handle(new ShutdownEvent(this.api, OffsetDateTime.now(), this.dcAudioConnections));
        } else {
            for (AudioManager mng : this.api.getAudioManagersMap().values()) {
                AudioManagerImpl mngImpl = (AudioManagerImpl)mng;
                VoiceChannel channel = null;
                if (mngImpl.isConnected()) {
                    channel = mng.getConnectedChannel();
                    mngImpl.closeAudioConnection();
                } else if (mngImpl.isAttemptingToConnect()) {
                    channel = mng.getQueuedAudioConnection();
                } else if (mngImpl.wasUnexpectedlyDisconnected()) {
                    channel = mngImpl.getUnexpectedDisconnectedChannel();
                }
                if (channel == null) continue;
                this.dcAudioConnections.add(channel);
            }
            this.api.getEventManager().handle(new DisconnectEvent(this.api, serverCloseFrame, clientCloseFrame, closedByServer, OffsetDateTime.now(), this.dcAudioConnections));
            this.reconnect();
        }
    }

    protected void reconnect() {
        LOG.warn("Got disconnected from WebSocket (Internet?!)... Attempting to reconnect in " + this.reconnectTimeoutS + "s");
        while (this.shouldReconnect) {
            try {
                this.api.setStatus(JDA.Status.WAITING_TO_RECONNECT);
                Thread.sleep(this.reconnectTimeoutS * 1000);
                this.api.setStatus(JDA.Status.ATTEMPTING_TO_RECONNECT);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LOG.warn("Attempting to reconnect!");
            try {
                this.connect();
                break;
            }
            catch (RuntimeException ex) {
                this.reconnectTimeoutS = Math.min(this.reconnectTimeoutS << 1, 900);
                LOG.warn("Reconnect failed! Next attempt in " + this.reconnectTimeoutS + "s");
            }
        }
    }

    @Override
    public void onTextMessage(WebSocket websocket, String message) {
        JSONObject content = new JSONObject(message);
        int opCode = content.getInt("op");
        if (content.has("s") && !content.isNull("s")) {
            this.api.setResponseTotal(content.getInt("s"));
        }
        if (this.customHandler != null && this.customHandler.handle(content)) {
            return;
        }
        switch (opCode) {
            case 0: {
                this.handleEvent(content);
                break;
            }
            case 1: {
                LOG.debug("Got Keep-Alive request (OP 1). Sending response...");
                this.sendKeepAlive();
                break;
            }
            case 7: {
                LOG.debug("Got Reconnect request (OP 7). Closing connection now...");
                this.close();
                break;
            }
            case 9: {
                LOG.debug("Got Invalidate request (OP 9). Invalidating...");
                this.invalidate();
                this.sendIdentify();
                break;
            }
            case 10: {
                LOG.debug("Got HELLO packet (OP 10). Initializing keep-alive.");
                this.setupKeepAlive(content.getJSONObject("d").getLong("heartbeat_interval"));
                break;
            }
            case 11: {
                LOG.trace("Got Heartbeat Ack (OP 11).");
                break;
            }
            default: {
                LOG.debug("Got unknown op-code: " + opCode + " with content: " + message);
            }
        }
    }

    protected void setupKeepAlive(long timeout) {
        this.keepAliveThread = new Thread(() -> {
            while (this.connected) {
                try {
                    this.sendKeepAlive();
                    Thread.sleep(timeout);
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
        });
        this.keepAliveThread.setName("JDA MainWS-KeepAlive" + (this.sharding != null ? " Shard [" + this.sharding[0] + " / " + this.sharding[1] + "]" : ""));
        this.keepAliveThread.setPriority(10);
        this.keepAliveThread.setDaemon(true);
        this.keepAliveThread.start();
    }

    protected void sendKeepAlive() {
        this.send(new JSONObject().put("op", 1).put("d", this.api.getResponseTotal()).toString());
    }

    protected void sendIdentify() {
        LOG.debug("Sending Identify-packet...");
        JSONObject identify = new JSONObject().put("op", 2).put("d", new JSONObject().put("token", this.api.getAuthToken()).put("properties", new JSONObject().put("$os", System.getProperty("os.name")).put("$browser", "JDA").put("$device", "").put("$referring_domain", "").put("$referrer", "")).put("v", 5).put("large_threshold", 250).put("compress", true));
        if (this.sharding != null) {
            identify.getJSONObject("d").put("shard", new JSONArray().put(this.sharding[0]).put(this.sharding[1]));
        }
        this.send(identify.toString());
    }

    protected void sendResume() {
        LOG.debug("Sending Resume-packet...");
        this.send(new JSONObject().put("op", 6).put("d", new JSONObject().put("session_id", this.sessionId).put("token", this.api.getAuthToken()).put("seq", this.api.getResponseTotal())).toString());
    }

    protected void invalidate() {
        this.sessionId = null;
        this.api.getAudioManagersMap().values().forEach(mng -> {
            String guildId = mng.getGuild().getId();
            if (mng.getSendingHandler() != null) {
                this.audioSendHandlers.put(guildId, mng.getSendingHandler());
            }
            if (mng.getReceiveHandler() != null) {
                this.audioReceivedHandlers.put(guildId, mng.getReceiveHandler());
            }
        });
        this.api.getAudioManagersMap().clear();
        this.api.getChannelMap().clear();
        this.api.getVoiceChannelMap().clear();
        this.api.getGuildMap().clear();
        this.api.getUserMap().clear();
        this.api.getPmChannelMap().clear();
        this.api.getOffline_pms().clear();
        new EntityBuilder(this.api).clearCache();
        new ReadyHandler(this.api, 0).clearCache();
        EventCache.get(this.api).clear();
        GuildLock.get(this.api).clear();
        TextChannelImpl.AsyncMessageSender.stopAll(this.api);
    }

    protected void restoreAudioHandlers() {
        LOG.trace("Restoring cached AudioHandlers.");
        this.audioSendHandlers.forEach((guildId, handler) -> {
            Guild guild = this.api.getGuildMap().get(guildId);
            if (guild != null) {
                AudioManager mng = this.api.getAudioManager(guild);
                mng.setSendingHandler((AudioSendHandler)handler);
            } else {
                LOG.warn("Could not restore an AudioSendHandler after reconnect due to the Guild it was connected to no longer existing in JDA's registry. Guild Id: " + guildId);
            }
        });
        this.audioReceivedHandlers.forEach((guildId, handler) -> {
            Guild guild = this.api.getGuildMap().get(guildId);
            if (guild != null) {
                AudioManager mng = this.api.getAudioManager(guild);
                mng.setReceivingHandler((AudioReceiveHandler)handler);
            } else {
                LOG.warn("Could not restore an AudioReceiveHandler after reconnect due to the Guild it was connected to no longer existing in JDA's registry. Guild Id: " + guildId);
            }
        });
        this.audioSendHandlers.clear();
        this.audioReceivedHandlers.clear();
        LOG.trace("Finished restoring cached AudioHandlers");
    }

    protected void reconnectAudioConnections() {
        if (this.dcAudioConnections.size() == 0) {
            return;
        }
        LOG.trace("Cleaning up previous Audio Connections.");
        for (VoiceChannel chan : this.dcAudioConnections) {
            JSONObject obj = new JSONObject().put("op", 4).put("d", new JSONObject().put("guild_id", chan.getGuild().getId()).put("channel_id", JSONObject.NULL).put("self_mute", false).put("self_deaf", false));
            this.send(obj.toString());
        }
        LOG.trace("Attempting to reconnect previous Audio Connections...");
        for (VoiceChannel chan : this.dcAudioConnections) {
            String guildId = chan.getGuild().getId();
            String chanId = chan.getId();
            Guild guild = this.api.getGuildMap().get(guildId);
            if (guild == null) {
                JDAImpl.LOG.warn("Could not reestablish audio connection during reconnect due to the previous connection being connected to a Guild that we are no longer connected to. Guild Id: " + guildId);
                continue;
            }
            VoiceChannel channel = this.api.getVoiceChannelMap().get(chanId);
            if (channel == null) {
                JDAImpl.LOG.warn("Could not reestablish audio connection during reconnect due to the previous connection being connected to a VoiceChannel that no longer exists. VChannel Id: " + chanId);
                continue;
            }
            AudioManager manager = this.api.getAudioManager(guild);
            manager.openAudioConnection(channel);
        }
        LOG.debug("Finished sending packets to reopen previous Audio Connections.");
        this.dcAudioConnections.clear();
    }

    protected void handleEvent(JSONObject raw) {
        String type = raw.getString("t");
        int responseTotal = this.api.getResponseTotal();
        if (type.equals("GUILD_MEMBER_ADD")) {
            GuildMembersChunkHandler.modifyExpectedGuildMember(this.api, raw.getJSONObject("d").getString("guild_id"), 1);
        }
        if (type.equals("GUILD_MEMBER_REMOVE")) {
            GuildMembersChunkHandler.modifyExpectedGuildMember(this.api, raw.getJSONObject("d").getString("guild_id"), -1);
        }
        if (!(!this.initiating || type.equals("READY") || type.equals("GUILD_MEMBERS_CHUNK") || type.equals("GUILD_CREATE") || type.equals("RESUMED"))) {
            LOG.debug("Caching " + type + " event during init!");
            this.cachedEvents.add(raw);
            return;
        }
        if (type.equals("PRESENCE_REPLACE")) {
            JSONArray presences = raw.getJSONArray("d");
            LOG.trace(String.format("%s -> %s", type, presences.toString()));
            PresenceUpdateHandler handler = new PresenceUpdateHandler(this.api, responseTotal);
            for (int i = 0; i < presences.length(); ++i) {
                JSONObject presence = presences.getJSONObject(i);
                handler.handle(presence);
            }
            return;
        }
        JSONObject content = raw.getJSONObject("d");
        LOG.trace(String.format("%s -> %s", type, content.toString()));
        try {
            switch (type) {
                case "READY": {
                    this.sessionId = content.getString("session_id");
                    new ReadyHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "RESUMED": {
                    this.initiating = false;
                    this.ready();
                    break;
                }
                case "GUILD_MEMBERS_CHUNK": {
                    new GuildMembersChunkHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "PRESENCE_UPDATE": {
                    new PresenceUpdateHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "TYPING_START": {
                    new UserTypingHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "MESSAGE_CREATE": {
                    new MessageReceivedHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "MESSAGE_UPDATE": {
                    if (content.has("author")) {
                        new MessageUpdateHandler(this.api, responseTotal).handle(raw);
                        break;
                    }
                    new MessageEmbedHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "MESSAGE_DELETE": {
                    new MessageDeleteHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "MESSAGE_DELETE_BULK": {
                    new MessageBulkDeleteHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "VOICE_STATE_UPDATE": {
                    new VoiceChangeHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "VOICE_SERVER_UPDATE": {
                    if (this.api.isAudioEnabled()) {
                        new VoiceServerUpdateHandler(this.api, responseTotal).handle(raw);
                        break;
                    }
                    LOG.debug("Received VOICE_SERVER_UPDATE event but ignoring due to audio being disabled/not supported.");
                    break;
                }
                case "CHANNEL_CREATE": {
                    new ChannelCreateHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "CHANNEL_UPDATE": {
                    new ChannelUpdateHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "CHANNEL_DELETE": {
                    new ChannelDeleteHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "GUILD_CREATE": {
                    new GuildJoinHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "GUILD_UPDATE": {
                    new GuildUpdateHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "GUILD_DELETE": {
                    new GuildLeaveHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "GUILD_MEMBER_ADD": {
                    new GuildMemberAddHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "GUILD_MEMBER_UPDATE": {
                    new GuildMemberUpdateHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "GUILD_MEMBER_REMOVE": {
                    new GuildMemberRemoveHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "GUILD_BAN_ADD": {
                    new GuildMemberBanHandler(this.api, responseTotal, true).handle(raw);
                    break;
                }
                case "GUILD_BAN_REMOVE": {
                    new GuildMemberBanHandler(this.api, responseTotal, false).handle(raw);
                    break;
                }
                case "GUILD_ROLE_CREATE": {
                    new GuildRoleCreateHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "GUILD_ROLE_UPDATE": {
                    new GuildRoleUpdateHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "GUILD_ROLE_DELETE": {
                    new GuildRoleDeleteHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "GUILD_EMOJIS_UPDATE": {
                    new GuildEmojisUpdateHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "USER_UPDATE": {
                    new UserUpdateHandler(this.api, responseTotal).handle(raw);
                    break;
                }
                case "USER_GUILD_SETTINGS_UPDATE": {
                    break;
                }
                case "MESSAGE_ACK": {
                    break;
                }
                default: {
                    LOG.debug("Unrecognized event:\n" + raw);
                    break;
                }
            }
        }
        catch (JSONException ex) {
            LOG.warn("Got an unexpected Json-parse error. Please redirect following message to the devs:\n\t" + ex.getMessage() + "\n\t" + type + " -> " + content);
        }
        catch (Exception ex) {
            LOG.log(ex);
        }
    }

    @Override
    public void onBinaryMessage(WebSocket websocket, byte[] binary) throws UnsupportedEncodingException, DataFormatException {
        StringBuilder builder = new StringBuilder();
        Inflater decompresser = new Inflater();
        decompresser.setInput(binary, 0, binary.length);
        byte[] result = new byte[128];
        while (!decompresser.finished()) {
            int resultLength = decompresser.inflate(result);
            builder.append(new String(result, 0, resultLength, "UTF-8"));
        }
        decompresser.end();
        this.onTextMessage(websocket, builder.toString());
    }

    @Override
    public void onUnexpectedError(WebSocket websocket, WebSocketException cause) throws Exception {
        this.handleCallbackError(websocket, cause);
    }

    @Override
    public void handleCallbackError(WebSocket websocket, Throwable cause) {
        LOG.log(cause);
    }
}

