/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.dv8tion.jda.Permission;
import net.dv8tion.jda.entities.Channel;
import net.dv8tion.jda.entities.TextChannel;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.VoiceChannel;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.exceptions.PermissionException;
import net.dv8tion.jda.utils.PermissionUtil;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class ChannelManager {
    private final Channel channel;
    private String name = null;
    private String topic = null;
    private int position = -1;
    private int userLimit = -1;
    private int bitrate = -1;
    private Map<Integer, Channel> newPositions = new HashMap<Integer, Channel>();

    public ChannelManager(Channel channel) {
        this.channel = channel;
    }

    public ChannelManager setName(String name) {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        this.name = this.channel.getName().equals(name) ? null : name;
        return this;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public ChannelManager setTopic(String topic) {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        if (this.channel instanceof VoiceChannel) {
            throw new UnsupportedOperationException("Setting a Topic on VoiceChannels is not allowed!");
        }
        this.topic = StringUtils.equals(topic, this.channel.getTopic()) ? null : topic;
        return this;
    }

    public ChannelManager setUserLimit(int userLimit) {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        if (this.channel instanceof TextChannel) {
            throw new UnsupportedOperationException("Setting user limit for TextChannels is not allowed!");
        }
        if (userLimit < -1 || userLimit > 99) {
            throw new IllegalArgumentException("Provided userlimit must be either within the bounds of 0-99 inclusive or -1 to reset.");
        }
        this.userLimit = userLimit == ((VoiceChannel)this.channel).getUserLimit() ? -1 : userLimit;
        return this;
    }

    public ChannelManager setBitrate(int bitrate) {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        if (this.channel instanceof TextChannel) {
            throw new UnsupportedOperationException("Setting user limit for TextChannels is not allowed!");
        }
        if (bitrate != -1 && (bitrate < 8000 || bitrate > 96000)) {
            throw new IllegalArgumentException("Provided bitrate must be within the range of 8000 to 96000, or -1 to reset. Recommended is 64000");
        }
        this.bitrate = bitrate == ((VoiceChannel)this.channel).getBitrate() ? -1 : bitrate;
        return this;
    }

    public ChannelManager setPosition(int newPosition) {
        if (!PermissionUtil.checkPermission((User)this.channel.getJDA().getSelfInfo(), Permission.MANAGE_CHANNEL, this.channel.getGuild())) {
            throw new PermissionException("Do not have " + (Object)((Object)Permission.MANAGE_CHANNEL) + " for this Guild. Cannot change the position of channels.");
        }
        this.newPositions.clear();
        if (newPosition < 0 || newPosition == this.channel.getPosition()) {
            return this;
        }
        this.position = newPosition;
        Map<Integer, Channel> currentPositions = (this.channel instanceof TextChannel ? this.channel.getGuild().getTextChannels() : this.channel.getGuild().getVoiceChannels()).stream().collect(Collectors.toMap(chan -> ((Channel)((Object)chan)).getPosition(), chan -> (Channel)((Object)chan)));
        int searchIndex = newPosition > this.channel.getPosition() ? newPosition - 1 : newPosition;
        int index = 0;
        for (Channel chan2 : currentPositions.values()) {
            if (chan2 == this.channel) continue;
            if (index == searchIndex) {
                this.newPositions.put(index, this.channel);
                ++index;
            }
            this.newPositions.put(index, chan2);
            ++index;
        }
        if (!this.newPositions.containsValue(this.channel)) {
            this.newPositions.put(newPosition, this.channel);
        }
        return this;
    }

    public void delete() {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        ((JDAImpl)this.channel.getJDA()).getRequester().delete("https://discordapp.com/api/channels/" + this.channel.getId());
    }

    public void reset() {
        this.name = null;
        this.topic = null;
        this.position = -1;
        this.newPositions.clear();
    }

    public void update() {
        JSONObject frame = this.getFrame(this.channel);
        if (this.name != null) {
            frame.put("name", this.name);
        }
        if (this.topic != null) {
            frame.put("topic", this.topic);
        }
        if (this.position != -1 && !this.newPositions.isEmpty()) {
            this.updatePosition();
            frame.put("position", this.position);
        }
        if (this.userLimit != -1) {
            frame.put("user_limit", this.userLimit);
        }
        if (this.bitrate != -1) {
            frame.put("bitrate", this.bitrate);
        }
        this.update(this.channel, frame);
        this.reset();
    }

    private void updatePosition() {
        JSONArray bulkUpdate = new JSONArray();
        this.newPositions.forEach((pos, chan) -> bulkUpdate.put(new JSONObject().put("id", chan.getId()).put("position", pos)));
        ((JDAImpl)this.channel.getJDA()).getRequester().patch("https://discordapp.com/api/guilds/" + this.channel.getGuild().getId() + "/channels", bulkUpdate);
    }

    private JSONObject getFrame(Channel chan) {
        return new JSONObject().put("name", chan.getName()).put("topic", chan.getTopic() == null ? "" : chan.getTopic()).put("position", chan.getPositionRaw()).put("bitrate", chan instanceof VoiceChannel ? ((VoiceChannel)chan).getBitrate() : 64000).put("user_limit", chan instanceof VoiceChannel ? ((VoiceChannel)chan).getUserLimit() : 0);
    }

    private void update(Channel chan, JSONObject o) {
        ((JDAImpl)chan.getJDA()).getRequester().patch("https://discordapp.com/api/channels/" + chan.getId(), o);
    }

    private void checkPermission(Permission perm) {
        if (!this.channel.checkPermission(this.channel.getJDA().getSelfInfo(), perm)) {
            throw new PermissionException(perm);
        }
    }
}

