/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dv8tion.jda.entities.Message;
import net.dv8tion.jda.entities.MessageType;
import net.dv8tion.jda.entities.TextChannel;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.events.InviteReceivedEvent;
import net.dv8tion.jda.events.message.MessageReceivedEvent;
import net.dv8tion.jda.events.message.guild.GuildMessageReceivedEvent;
import net.dv8tion.jda.events.message.priv.PrivateMessageReceivedEvent;
import net.dv8tion.jda.handle.EntityBuilder;
import net.dv8tion.jda.handle.EventCache;
import net.dv8tion.jda.handle.SocketHandler;
import net.dv8tion.jda.requests.GuildLock;
import net.dv8tion.jda.utils.InviteUtil;
import org.json.JSONObject;

public class MessageReceivedHandler
extends SocketHandler {
    private static final Pattern invitePattern = Pattern.compile("\\bhttps://(?:www\\.)?discord(?:\\.gg|app\\.com/invite)/([a-zA-Z0-9-]+)\\b");

    public MessageReceivedHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        MessageType type = MessageType.fromId(content.getInt("type"));
        switch (type) {
            case DEFAULT: {
                return this.handleDefaultMessage(content);
            }
        }
        JDAImpl.LOG.debug("JDA received a message of unknown type. Type: " + (Object)((Object)type) + "  JSON: " + content);
        return null;
    }

    private String handleDefaultMessage(JSONObject content) {
        Message message;
        try {
            message = new EntityBuilder(this.api).createMessage(content);
        }
        catch (IllegalArgumentException e) {
            EventCache.get(this.api).cache(EventCache.Type.CHANNEL, content.getString("channel_id"), () -> this.handle(this.allContent));
            EventCache.LOG.debug(e.getMessage());
            return null;
        }
        if (!message.isPrivate()) {
            TextChannel channel = this.api.getChannelMap().get(message.getChannelId());
            if (GuildLock.get(this.api).isLocked(channel.getGuild().getId())) {
                return channel.getGuild().getId();
            }
            this.api.getEventManager().handle(new GuildMessageReceivedEvent(this.api, this.responseNumber, message, channel));
        } else {
            this.api.getEventManager().handle(new PrivateMessageReceivedEvent(this.api, this.responseNumber, message, this.api.getPmChannelMap().get(message.getChannelId())));
        }
        this.api.getEventManager().handle(new MessageReceivedEvent(this.api, this.responseNumber, message));
        Matcher matcher = invitePattern.matcher(message.getContent());
        while (matcher.find()) {
            InviteUtil.Invite invite = InviteUtil.resolve(matcher.group(1));
            if (invite == null) continue;
            this.api.getEventManager().handle(new InviteReceivedEvent(this.api, this.responseNumber, message, invite));
        }
        return null;
    }
}

