/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import java.util.List;
import net.dv8tion.jda.entities.Role;
import net.dv8tion.jda.entities.impl.GuildImpl;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.events.guild.role.GuildRoleDeleteEvent;
import net.dv8tion.jda.handle.EventCache;
import net.dv8tion.jda.handle.SocketHandler;
import net.dv8tion.jda.requests.GuildLock;
import org.json.JSONObject;

public class GuildRoleDeleteHandler
extends SocketHandler {
    public GuildRoleDeleteHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        if (GuildLock.get(this.api).isLocked(content.getString("guild_id"))) {
            return content.getString("guild_id");
        }
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(content.getString("guild_id"));
        Role removedRole = guild.getRolesMap().remove(content.getString("role_id"));
        if (removedRole == null) {
            EventCache.get(this.api).cache(EventCache.Type.ROLE, content.getString("role_id"), () -> this.handle(this.allContent));
            EventCache.LOG.debug("GUILD_ROLE_DELETE attempted to delete a role that didn't exist! JSON: " + content);
            return null;
        }
        for (List<Role> userRoles : guild.getUserRoles().values()) {
            userRoles.remove(removedRole);
        }
        this.api.getEventManager().handle(new GuildRoleDeleteEvent(this.api, this.responseNumber, guild, removedRole));
        return null;
    }
}

