/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.handle.EntityBuilder;
import net.dv8tion.jda.handle.SocketHandler;
import org.json.JSONArray;
import org.json.JSONObject;

public class GuildMembersChunkHandler
extends SocketHandler {
    private static HashMap<JDA, HashMap<String, Integer>> expectedGuildMembers = new HashMap();
    private static HashMap<JDA, HashMap<String, List<JSONArray>>> memberChunksCache = new HashMap();

    public GuildMembersChunkHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        String guildId = content.getString("guild_id");
        List<JSONArray> memberChunks = memberChunksCache.get(this.api).get(guildId);
        Integer expectMemberCount = expectedGuildMembers.get(this.api).get(guildId);
        JSONArray members = content.getJSONArray("members");
        JDAImpl.LOG.debug("GUILD_MEMBER_CHUNK for: " + guildId + " \tMembers: " + members.length());
        memberChunks.add(members);
        int currentTotal = 0;
        for (JSONArray arr : memberChunks) {
            currentTotal += arr.length();
        }
        if (currentTotal >= expectMemberCount) {
            JDAImpl.LOG.debug("Finished chunking for: " + guildId);
            new EntityBuilder(this.api).createGuildSecondPass(guildId, memberChunks);
            memberChunksCache.get(this.api).remove(guildId);
            expectedGuildMembers.get(this.api).remove(guildId);
        }
        return null;
    }

    public static void setExpectedGuildMembers(JDA jda, String guildId, int count) {
        HashMap<String, Integer> guildMembers = expectedGuildMembers.get(jda);
        if (guildMembers == null) {
            guildMembers = new HashMap();
            expectedGuildMembers.put(jda, guildMembers);
        }
        if (guildMembers.get(guildId) != null) {
            JDAImpl.LOG.warn("Set the count of expected users from GuildMembersChunk even though a value already exists! GuildId: " + guildId);
        }
        guildMembers.put(guildId, count);
        HashMap<String, List<JSONArray>> memberChunks = memberChunksCache.get(jda);
        if (memberChunks == null) {
            memberChunks = new HashMap();
            memberChunksCache.put(jda, memberChunks);
        }
        if (memberChunks.get(guildId) != null) {
            JDAImpl.LOG.warn("Set the memberChunks for MemberChunking for a guild that was already setup for chunking! GuildId: " + guildId);
        }
        memberChunks.put(guildId, new LinkedList());
    }

    public static void modifyExpectedGuildMember(JDA jda, String guildId, int changeAmount) {
        try {
            Integer i = expectedGuildMembers.get(jda).get(guildId);
            i = i + changeAmount;
            expectedGuildMembers.get(jda).put(guildId, i);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

