/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.events.guild.GuildAvailableEvent;
import net.dv8tion.jda.events.guild.GuildJoinEvent;
import net.dv8tion.jda.events.guild.UnavailableGuildJoinedEvent;
import net.dv8tion.jda.handle.EntityBuilder;
import net.dv8tion.jda.handle.EventCache;
import net.dv8tion.jda.handle.ReadyHandler;
import net.dv8tion.jda.handle.SocketHandler;
import org.json.JSONObject;

public class GuildJoinHandler
extends SocketHandler {
    public GuildJoinHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        Guild g = this.api.getGuildById(content.getString("id"));
        Boolean wasAvail = g == null || g.getName() == null ? null : Boolean.valueOf(g.isAvailable());
        new EntityBuilder(this.api).createGuildFirstPass(content, guild -> {
            if (guild.isAvailable()) {
                if (!this.api.getClient().isReady()) {
                    new ReadyHandler(this.api, this.responseNumber).onGuildInit((Guild)guild);
                    return;
                } else if (wasAvail == null) {
                    this.api.getEventManager().handle(new GuildJoinEvent(this.api, this.responseNumber, (Guild)guild));
                    EventCache.get(this.api).playbackCache(EventCache.Type.GUILD, guild.getId());
                    return;
                } else {
                    if (wasAvail.booleanValue()) throw new RuntimeException("Got a GuildCreateEvent for a guild that already existed! Json: " + content.toString());
                    this.api.getEventManager().handle(new GuildAvailableEvent(this.api, this.responseNumber, (Guild)guild));
                }
                return;
            } else {
                this.api.getEventManager().handle(new UnavailableGuildJoinedEvent(this.api, this.responseNumber, guild.getId()));
            }
        });
        return null;
    }
}

