/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.dv8tion.jda.entities.Channel;
import net.dv8tion.jda.entities.ChannelType;
import net.dv8tion.jda.entities.PermissionOverride;
import net.dv8tion.jda.entities.Role;
import net.dv8tion.jda.entities.TextChannel;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.impl.GuildImpl;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.entities.impl.PermissionOverrideImpl;
import net.dv8tion.jda.entities.impl.TextChannelImpl;
import net.dv8tion.jda.entities.impl.VoiceChannelImpl;
import net.dv8tion.jda.events.channel.text.TextChannelUpdateNameEvent;
import net.dv8tion.jda.events.channel.text.TextChannelUpdatePermissionsEvent;
import net.dv8tion.jda.events.channel.text.TextChannelUpdatePositionEvent;
import net.dv8tion.jda.events.channel.text.TextChannelUpdateTopicEvent;
import net.dv8tion.jda.events.channel.voice.VoiceChannelUpdateBitrateEvent;
import net.dv8tion.jda.events.channel.voice.VoiceChannelUpdateNameEvent;
import net.dv8tion.jda.events.channel.voice.VoiceChannelUpdatePermissionsEvent;
import net.dv8tion.jda.events.channel.voice.VoiceChannelUpdatePositionEvent;
import net.dv8tion.jda.events.channel.voice.VoiceChannelUpdateUserLimitEvent;
import net.dv8tion.jda.handle.EntityBuilder;
import net.dv8tion.jda.handle.EventCache;
import net.dv8tion.jda.handle.SocketHandler;
import net.dv8tion.jda.requests.GuildLock;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class ChannelUpdateHandler
extends SocketHandler {
    private List<Role> changedRoles = new ArrayList<Role>();
    private List<User> changedUsers = new ArrayList<User>();
    private List<Role> containedRoles = new ArrayList<Role>();
    private List<User> containedUsers = new ArrayList<User>();

    public ChannelUpdateHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        if (GuildLock.get(this.api).isLocked(content.getString("guild_id"))) {
            return content.getString("guild_id");
        }
        String name = content.getString("name");
        int position = content.getInt("position");
        JSONArray permOverwrites = content.getJSONArray("permission_overwrites");
        ChannelType type = ChannelType.fromId(content.getInt("type"));
        switch (type) {
            case TEXT: {
                String topic = content.isNull("topic") ? null : content.getString("topic");
                TextChannelImpl channel = (TextChannelImpl)this.api.getChannelMap().get(content.getString("id"));
                if (channel == null) {
                    EventCache.get(this.api).cache(EventCache.Type.CHANNEL, content.getString("id"), () -> this.handle(this.allContent));
                    EventCache.LOG.debug("CHANNEL_UPDATE attemped to update a TextChannel that does not exist. JSON: " + content);
                    return null;
                }
                if (!StringUtils.equals(channel.getName(), name)) {
                    String oldName = channel.getName();
                    channel.setName(name);
                    this.api.getEventManager().handle(new TextChannelUpdateNameEvent(this.api, this.responseNumber, channel, oldName));
                }
                if (!StringUtils.equals(channel.getTopic(), topic)) {
                    String oldTopic = channel.getTopic();
                    channel.setTopic(topic);
                    this.api.getEventManager().handle(new TextChannelUpdateTopicEvent(this.api, this.responseNumber, channel, oldTopic));
                }
                if (channel.getPositionRaw() != position) {
                    int oldPosition = channel.getPositionRaw();
                    channel.setPosition(position);
                    this.api.getEventManager().handle(new TextChannelUpdatePositionEvent(this.api, this.responseNumber, channel, oldPosition));
                }
                for (int i = 0; i < permOverwrites.length(); ++i) {
                    this.handlePermissionOverride(permOverwrites.getJSONObject(i), channel, content);
                }
                List<Role> collect = channel.getRolePermissionOverridesMap().keySet().stream().filter(role -> !this.containedRoles.contains(role)).collect(Collectors.toList());
                collect.forEach(role -> {
                    this.changedRoles.add((Role)role);
                    channel.getRolePermissionOverridesMap().remove(role);
                });
                List<User> collect1 = channel.getUserPermissionOverridesMap().keySet().stream().filter(user -> !this.containedUsers.contains(user)).collect(Collectors.toList());
                collect1.forEach(user -> {
                    this.changedUsers.add((User)user);
                    channel.getUserPermissionOverridesMap().remove(user);
                });
                if (this.changedRoles.isEmpty() && this.changedUsers.isEmpty()) break;
                this.api.getEventManager().handle(new TextChannelUpdatePermissionsEvent(this.api, this.responseNumber, channel, this.changedRoles, this.changedUsers));
                break;
            }
            case VOICE: {
                VoiceChannelImpl channel = (VoiceChannelImpl)this.api.getVoiceChannelMap().get(content.getString("id"));
                int userLimit = content.getInt("user_limit");
                int bitrate = content.getInt("bitrate");
                if (channel == null) {
                    EventCache.get(this.api).cache(EventCache.Type.CHANNEL, content.getString("id"), () -> this.handle(this.allContent));
                    EventCache.LOG.debug("CHANNEL_UPDATE attemped to update a VoiceChannel that does not exist. JSON: " + content);
                    return null;
                }
                if (!StringUtils.equals(channel.getName(), name)) {
                    String oldName = channel.getName();
                    channel.setName(name);
                    this.api.getEventManager().handle(new VoiceChannelUpdateNameEvent(this.api, this.responseNumber, channel, oldName));
                }
                if (channel.getPositionRaw() != position) {
                    int oldPosition = channel.getPositionRaw();
                    channel.setPosition(position);
                    this.api.getEventManager().handle(new VoiceChannelUpdatePositionEvent(this.api, this.responseNumber, channel, oldPosition));
                }
                if (channel.getUserLimit() != userLimit) {
                    int oldLimit = channel.getUserLimit();
                    channel.setUserLimit(userLimit);
                    this.api.getEventManager().handle(new VoiceChannelUpdateUserLimitEvent(this.api, this.responseNumber, channel, oldLimit));
                }
                if (channel.getBitrate() != bitrate) {
                    int oldBitrate = channel.getBitrate();
                    channel.setBitrate(bitrate);
                    this.api.getEventManager().handle(new VoiceChannelUpdateBitrateEvent(this.api, this.responseNumber, channel, oldBitrate));
                }
                for (int i = 0; i < permOverwrites.length(); ++i) {
                    this.handlePermissionOverride(permOverwrites.getJSONObject(i), channel, content);
                }
                List<Role> collect = channel.getRolePermissionOverridesMap().keySet().stream().filter(role -> !this.containedRoles.contains(role)).collect(Collectors.toList());
                collect.forEach(role -> {
                    this.changedRoles.add((Role)role);
                    channel.getRolePermissionOverridesMap().remove(role);
                });
                List<User> collect1 = channel.getUserPermissionOverridesMap().keySet().stream().filter(user -> !this.containedUsers.contains(user)).collect(Collectors.toList());
                collect1.forEach(user -> {
                    this.changedUsers.add((User)user);
                    channel.getUserPermissionOverridesMap().remove(user);
                });
                if (this.changedRoles.isEmpty() && this.changedUsers.isEmpty()) break;
                this.api.getEventManager().handle(new VoiceChannelUpdatePermissionsEvent(this.api, this.responseNumber, channel, this.changedRoles, this.changedUsers));
                break;
            }
            default: {
                throw new IllegalArgumentException("CHANNEL_UPDATE provided an unrecognized channel type JSON: " + content);
            }
        }
        return null;
    }

    private void handlePermissionOverride(JSONObject override, Channel channel, JSONObject content) {
        String id = override.getString("id");
        int allow = override.getInt("allow");
        int deny = override.getInt("deny");
        switch (override.getString("type")) {
            case "role": {
                Role role = ((GuildImpl)channel.getGuild()).getRolesMap().get(id);
                if (role == null) {
                    EventCache.get(this.api).cache(EventCache.Type.ROLE, id, () -> this.handlePermissionOverride(override, channel, content));
                    EventCache.LOG.debug("CHANNEL_UPDATE attempted to create or update a PermissionOverride for a Role that doesn't exist! JSON: " + content);
                    return;
                }
                PermissionOverride permOverride = channel instanceof TextChannel ? ((TextChannelImpl)channel).getRolePermissionOverridesMap().get(role) : ((VoiceChannelImpl)channel).getRolePermissionOverridesMap().get(role);
                if (permOverride == null) {
                    permOverride = new EntityBuilder(this.api).createPermissionOverride(override, channel);
                    this.changedRoles.add(role);
                } else if (permOverride.getAllowedRaw() != allow || permOverride.getDeniedRaw() != deny) {
                    ((PermissionOverrideImpl)permOverride).setAllow(allow);
                    ((PermissionOverrideImpl)permOverride).setDeny(deny);
                    this.changedRoles.add(role);
                }
                this.containedRoles.add(role);
                break;
            }
            case "member": {
                User user = this.api.getUserMap().get(override.getString("id"));
                if (user == null || !channel.getGuild().getUsers().contains(user)) {
                    EventCache.get(this.api).cache(EventCache.Type.USER, id, () -> this.handlePermissionOverride(override, channel, content));
                    EventCache.LOG.debug("CHANNEL_UPDATE attempted to create or update a PermissionOverride for User that doesn't exist in this Guild! JSON: " + content);
                    return;
                }
                PermissionOverride permOverride = channel instanceof TextChannel ? ((TextChannelImpl)channel).getUserPermissionOverridesMap().get(user) : ((VoiceChannelImpl)channel).getUserPermissionOverridesMap().get(user);
                if (permOverride == null) {
                    permOverride = new EntityBuilder(this.api).createPermissionOverride(override, channel);
                    this.changedUsers.add(user);
                } else if (permOverride.getAllowedRaw() != allow || permOverride.getDeniedRaw() != deny) {
                    ((PermissionOverrideImpl)permOverride).setAllow(allow);
                    ((PermissionOverrideImpl)permOverride).setDeny(deny);
                    this.changedUsers.add(user);
                }
                this.containedUsers.add(user);
                break;
            }
            default: {
                throw new IllegalArgumentException("CHANNEL_UPDATE provided an unrecognized PermissionOverride type. JSON: " + content);
            }
        }
    }
}

