/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.events.message;

import net.dv8tion.jda.JDA;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.Message;
import net.dv8tion.jda.entities.MessageChannel;
import net.dv8tion.jda.entities.PrivateChannel;
import net.dv8tion.jda.entities.TextChannel;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.events.Event;

public class MessageReceivedEvent
extends Event {
    private final Message message;

    public MessageReceivedEvent(JDA api, int responseNumber, Message message) {
        super(api, responseNumber);
        this.message = message;
    }

    public Message getMessage() {
        return this.message;
    }

    public User getAuthor() {
        return this.message.getAuthor();
    }

    public String getAuthorNick() {
        return this.getGuild().getNicknameForUser(this.getAuthor());
    }

    public String getAuthorName() {
        String nickname = this.isPrivate() ? this.getAuthor().getUsername() : this.getAuthorNick();
        return nickname == null ? this.getAuthor().getUsername() : nickname;
    }

    public boolean isPrivate() {
        return this.message.isPrivate();
    }

    public TextChannel getTextChannel() {
        return this.getJDA().getTextChannelById(this.message.getChannelId());
    }

    public PrivateChannel getPrivateChannel() {
        return this.getJDA().getPrivateChannelById(this.message.getChannelId());
    }

    public MessageChannel getChannel() {
        return this.isPrivate() ? this.getPrivateChannel() : this.getTextChannel();
    }

    public Guild getGuild() {
        return this.isPrivate() ? null : this.getTextChannel().getGuild();
    }
}

