/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.entities.impl;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.body.MultipartBody;
import java.io.File;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.MessageBuilder;
import net.dv8tion.jda.MessageHistory;
import net.dv8tion.jda.Permission;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.Message;
import net.dv8tion.jda.entities.PermissionOverride;
import net.dv8tion.jda.entities.Role;
import net.dv8tion.jda.entities.SelfInfo;
import net.dv8tion.jda.entities.TextChannel;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.entities.impl.MessageImpl;
import net.dv8tion.jda.entities.impl.PermissionOverrideImpl;
import net.dv8tion.jda.exceptions.PermissionException;
import net.dv8tion.jda.exceptions.RateLimitedException;
import net.dv8tion.jda.exceptions.VerificationLevelException;
import net.dv8tion.jda.handle.EntityBuilder;
import net.dv8tion.jda.managers.ChannelManager;
import net.dv8tion.jda.managers.PermissionOverrideManager;
import net.dv8tion.jda.requests.Requester;
import net.dv8tion.jda.utils.InviteUtil;
import net.dv8tion.jda.utils.MiscUtil;
import net.dv8tion.jda.utils.PermissionUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TextChannelImpl
implements TextChannel {
    private final String id;
    private final Guild guild;
    private String name;
    private String topic;
    private int position;
    private final Map<User, PermissionOverride> userPermissionOverrides = new HashMap<User, PermissionOverride>();
    private final Map<Role, PermissionOverride> rolePermissionOverrides = new HashMap<Role, PermissionOverride>();
    private ChannelManager manager = null;

    public TextChannelImpl(String id, Guild guild) {
        this.id = id;
        this.guild = guild;
    }

    @Override
    public JDA getJDA() {
        return this.guild.getJDA();
    }

    @Override
    public String getAsMention() {
        return "<#" + this.getId() + '>';
    }

    @Override
    public PermissionOverride getOverrideForUser(User user) {
        return this.userPermissionOverrides.get(user);
    }

    @Override
    public PermissionOverride getOverrideForRole(Role role) {
        return this.rolePermissionOverrides.get(role);
    }

    @Override
    public List<PermissionOverride> getPermissionOverrides() {
        LinkedList<PermissionOverride> overrides = new LinkedList<PermissionOverride>();
        overrides.addAll(this.userPermissionOverrides.values());
        overrides.addAll(this.rolePermissionOverrides.values());
        return Collections.unmodifiableList(overrides);
    }

    @Override
    public List<PermissionOverride> getUserPermissionOverrides() {
        return Collections.unmodifiableList(new LinkedList<PermissionOverride>(this.userPermissionOverrides.values()));
    }

    @Override
    public List<PermissionOverride> getRolePermissionOverrides() {
        return Collections.unmodifiableList(new LinkedList<PermissionOverride>(this.rolePermissionOverrides.values()));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    public List<User> getUsers() {
        List users = this.getGuild().getUsers().stream().filter(user -> this.checkPermission((User)user, Permission.MESSAGE_READ)).collect(Collectors.toList());
        return Collections.unmodifiableList(users);
    }

    @Override
    public int getPosition() {
        List<TextChannel> channels = this.guild.getTextChannels();
        for (int i = 0; i < channels.size(); ++i) {
            if (channels.get(i) != this) continue;
            return i;
        }
        throw new RuntimeException("Somehow when determining position we never found the TextChannel in the Guild's channels? wtf?");
    }

    @Override
    public int getPositionRaw() {
        return this.position;
    }

    @Override
    public Message sendMessage(String text) {
        return this.sendMessage(new MessageBuilder().appendString(text).build());
    }

    @Override
    public Message sendMessage(Message msg) {
        this.checkVerification();
        SelfInfo self = this.getJDA().getSelfInfo();
        if (!this.checkPermission(self, Permission.MESSAGE_WRITE)) {
            throw new PermissionException(Permission.MESSAGE_WRITE);
        }
        JDAImpl api = (JDAImpl)this.getJDA();
        if (api.getMessageLimit(this.guild.getId()) != null) {
            throw new RateLimitedException(api.getMessageLimit(this.guild.getId()) - System.currentTimeMillis());
        }
        try {
            Requester.Response response = api.getRequester().post("https://discordapp.com/api/channels/" + this.getId() + "/messages", new JSONObject().put("content", msg.getRawContent()).put("tts", msg.isTTS()));
            if (response.isRateLimit()) {
                long retry_after = response.getObject().getLong("retry_after");
                api.setMessageTimeout(this.guild.getId(), retry_after);
                throw new RateLimitedException(retry_after);
            }
            if (!response.isOk()) {
                return null;
            }
            return new EntityBuilder(api).createMessage(response.getObject());
        }
        catch (JSONException ex) {
            JDAImpl.LOG.log(ex);
            return null;
        }
    }

    @Override
    public void sendMessageAsync(String text, Consumer<Message> callback) {
        this.sendMessageAsync(new MessageBuilder().appendString(text).build(), callback);
    }

    @Override
    public void sendMessageAsync(Message msg, Consumer<Message> callback) {
        this.checkVerification();
        SelfInfo self = this.getJDA().getSelfInfo();
        if (!this.checkPermission(self, Permission.MESSAGE_WRITE)) {
            throw new PermissionException(Permission.MESSAGE_WRITE);
        }
        ((MessageImpl)msg).setChannelId(this.id);
        AsyncMessageSender.getInstance(this.getJDA(), this.guild.getId()).enqueue(msg, false, callback);
    }

    @Override
    public Message sendFile(File file, Message message) {
        this.checkVerification();
        if (!this.checkPermission(this.getJDA().getSelfInfo(), Permission.MESSAGE_WRITE)) {
            throw new PermissionException(Permission.MESSAGE_WRITE);
        }
        if (!this.checkPermission(this.getJDA().getSelfInfo(), Permission.MESSAGE_ATTACH_FILES)) {
            throw new PermissionException(Permission.MESSAGE_ATTACH_FILES);
        }
        if (file == null || !file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("Provided file is either null, doesn't exist or is not readable!");
        }
        if (file.length() > 0x800000L) {
            throw new IllegalArgumentException("File is to big! Max file-size is 8MB");
        }
        JDAImpl api = (JDAImpl)this.getJDA();
        try {
            MultipartBody body = Unirest.post("https://discordapp.com/api/channels/" + this.getId() + "/messages").header("authorization", this.getJDA().getAuthToken()).header("user-agent", Requester.USER_AGENT).field("file", file);
            if (message != null) {
                body.field("content", message.getRawContent()).field("tts", message.isTTS());
            }
            String dbg = String.format("Requesting %s -> %s\n\tPayload: file: %s, message: %s, tts: %s\n\tResponse: ", body.getHttpRequest().getHttpMethod().name(), body.getHttpRequest().getUrl(), file.getAbsolutePath(), message == null ? "null" : message.getRawContent(), message == null ? "N/A" : Boolean.valueOf(message.isTTS()));
            HttpResponse<JsonNode> response = body.asJson();
            Requester.LOG.trace(dbg + body);
            try {
                int status = response.getStatus();
                if (status >= 200 && status < 300) {
                    return new EntityBuilder(api).createMessage(response.getBody().getObject());
                }
                if (response.getStatus() == 429) {
                    long retryAfter = response.getBody().getObject().getLong("retry_after");
                    api.setMessageTimeout(this.guild.getId(), retryAfter);
                    throw new RateLimitedException(retryAfter);
                }
                throw new RuntimeException("An unknown status code was returned when attempting to upload file. Status: " + status + " JSON: " + response.getBody().toString());
            }
            catch (JSONException e) {
                Requester.LOG.fatal("Following json caused an exception: " + response.getBody().toString());
                Requester.LOG.log(e);
            }
        }
        catch (UnirestException e) {
            Requester.LOG.log(e);
        }
        return null;
    }

    @Override
    public void sendFileAsync(File file, Message message, Consumer<Message> callback) {
        this.checkVerification();
        if (!this.checkPermission(this.getJDA().getSelfInfo(), Permission.MESSAGE_WRITE)) {
            throw new PermissionException(Permission.MESSAGE_WRITE);
        }
        if (!this.checkPermission(this.getJDA().getSelfInfo(), Permission.MESSAGE_ATTACH_FILES)) {
            throw new PermissionException(Permission.MESSAGE_ATTACH_FILES);
        }
        Thread thread = new Thread(() -> {
            Message messageReturn;
            try {
                messageReturn = this.sendFile(file, message);
            }
            catch (RateLimitedException e) {
                JDAImpl.LOG.warn("Got ratelimited when trying to upload file. Providing null to callback.");
                messageReturn = null;
            }
            if (callback != null) {
                callback.accept(messageReturn);
            }
        });
        thread.setName("TextChannelImpl sendFileAsync Channel: " + this.id);
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public Message getMessageById(String messageId) {
        if (!this.checkPermission(this.getJDA().getSelfInfo(), Permission.MESSAGE_READ)) {
            throw new PermissionException(Permission.MESSAGE_READ);
        }
        if (!this.checkPermission(this.getJDA().getSelfInfo(), Permission.MESSAGE_HISTORY)) {
            throw new PermissionException(Permission.MESSAGE_HISTORY);
        }
        Requester.Response response = ((JDAImpl)this.getJDA()).getRequester().get("https://discordapp.com/api/channels/" + this.id + "/messages/" + messageId);
        if (response.isOk()) {
            return new EntityBuilder((JDAImpl)this.getJDA()).createMessage(response.getObject());
        }
        return null;
    }

    @Override
    public boolean deleteMessageById(String messageId) {
        if (!this.checkPermission(this.getJDA().getSelfInfo(), Permission.MESSAGE_READ)) {
            throw new PermissionException(Permission.MESSAGE_READ);
        }
        Requester.Response response = ((JDAImpl)this.getJDA()).getRequester().delete("https://discordapp.com/api/channels/" + this.id + "/messages/" + messageId);
        if (response.isOk()) {
            return true;
        }
        if (response.code == 403) {
            if (!this.checkPermission(this.getJDA().getSelfInfo(), Permission.MESSAGE_READ)) {
                throw new PermissionException(Permission.MESSAGE_READ);
            }
            throw new PermissionException(Permission.MESSAGE_MANAGE, "You need MESSAGE_MANAGE permission to delete another users Messages");
        }
        return false;
    }

    @Override
    public MessageHistory getHistory() {
        return new MessageHistory(this);
    }

    @Override
    public void sendTyping() {
        ((JDAImpl)this.getJDA()).getRequester().post("https://discordapp.com/api/channels/" + this.getId() + "/typing", new JSONObject());
    }

    @Override
    public boolean pinMessageById(String messageId) {
        if (!this.checkPermission(this.getJDA().getSelfInfo(), Permission.MESSAGE_READ)) {
            throw new PermissionException(Permission.MESSAGE_READ, "You cannot pin a message in a channel you can't access. (MESSAGE_READ)");
        }
        if (!this.checkPermission(this.getJDA().getSelfInfo(), Permission.MESSAGE_MANAGE)) {
            throw new PermissionException(Permission.MESSAGE_MANAGE, "You need MESSAGE_MANAGE to pin or unpin messages.");
        }
        Requester.Response response = ((JDAImpl)this.getJDA()).getRequester().put("https://discordapp.com/api//channels/" + this.id + "/pins/" + messageId, new JSONObject());
        if (response.isRateLimit()) {
            throw new RateLimitedException(response.getObject().getInt("retry_after"));
        }
        return response.isOk();
    }

    @Override
    public boolean unpinMessageById(String messageId) {
        if (!this.checkPermission(this.getJDA().getSelfInfo(), Permission.MESSAGE_READ)) {
            throw new PermissionException(Permission.MESSAGE_READ, "You cannot unpin a message in a channel you can't access. (MESSAGE_READ)");
        }
        if (!this.checkPermission(this.getJDA().getSelfInfo(), Permission.MESSAGE_MANAGE)) {
            throw new PermissionException(Permission.MESSAGE_MANAGE, "You need MESSAGE_MANAGE to pin or unpin messages.");
        }
        Requester.Response response = ((JDAImpl)this.getJDA()).getRequester().delete("https://discordapp.com/api//channels/" + this.id + "/pins/" + messageId);
        if (response.isRateLimit()) {
            throw new RateLimitedException(response.getObject().getInt("retry_after"));
        }
        return response.isOk();
    }

    @Override
    public List<Message> getPinnedMessages() {
        if (!this.checkPermission(this.getJDA().getSelfInfo(), Permission.MESSAGE_READ)) {
            throw new PermissionException(Permission.MESSAGE_READ, "Cannot get the pinned message of a channel without MESSAGE_READ access.");
        }
        LinkedList<Message> pinnedMessages = new LinkedList<Message>();
        Requester.Response response = ((JDAImpl)this.getJDA()).getRequester().get("https://discordapp.com/api//channels/" + this.id + "/pins");
        if (response.isOk()) {
            JSONArray pins = response.getArray();
            for (int i = 0; i < pins.length(); ++i) {
                pinnedMessages.add(new EntityBuilder((JDAImpl)this.getJDA()).createMessage(pins.getJSONObject(i)));
            }
            return Collections.unmodifiableList(pinnedMessages);
        }
        if (response.isRateLimit()) {
            throw new RateLimitedException(response.getObject().getInt("retry_after"));
        }
        throw new RuntimeException("An unknown error occured attempting to get pinned messages. Ask devs for help.\n" + response);
    }

    @Override
    public boolean checkPermission(User user, Permission ... permissions) {
        return PermissionUtil.checkPermission(this, user, permissions);
    }

    @Override
    public synchronized ChannelManager getManager() {
        if (this.manager == null) {
            this.manager = new ChannelManager(this);
        }
        return this.manager;
    }

    @Override
    public PermissionOverrideManager createPermissionOverride(User user) {
        if (!this.checkPermission(this.getJDA().getSelfInfo(), Permission.MANAGE_PERMISSIONS)) {
            throw new PermissionException(Permission.MANAGE_PERMISSIONS);
        }
        if (!this.getGuild().getUsers().contains(user)) {
            throw new IllegalArgumentException("Given user is not member of this Guild");
        }
        PermissionOverrideImpl override = new PermissionOverrideImpl(this, user, null);
        override.setAllow(1 << Permission.MANAGE_PERMISSIONS.getOffset()).setDeny(0);
        PermissionOverrideManager manager = override.getManager();
        manager.reset(Permission.MANAGE_PERMISSIONS).update();
        return manager;
    }

    @Override
    public PermissionOverrideManager createPermissionOverride(Role role) {
        if (!this.checkPermission(this.getJDA().getSelfInfo(), Permission.MANAGE_PERMISSIONS)) {
            throw new PermissionException(Permission.MANAGE_PERMISSIONS);
        }
        if (!this.getGuild().getRoles().contains(role)) {
            throw new IllegalArgumentException("Given role does not exist in this Guild");
        }
        PermissionOverrideImpl override = new PermissionOverrideImpl(this, null, role);
        override.setAllow(1 << Permission.MANAGE_PERMISSIONS.getOffset()).setDeny(0);
        PermissionOverrideManager manager = override.getManager();
        manager.reset(Permission.MANAGE_PERMISSIONS).update();
        return manager;
    }

    @Override
    public List<InviteUtil.AdvancedInvite> getInvites() {
        return InviteUtil.getInvites(this);
    }

    public TextChannelImpl setName(String name) {
        this.name = name;
        return this;
    }

    public TextChannelImpl setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public TextChannelImpl setPosition(int position) {
        this.position = position;
        return this;
    }

    public Map<User, PermissionOverride> getUserPermissionOverridesMap() {
        return this.userPermissionOverrides;
    }

    public Map<Role, PermissionOverride> getRolePermissionOverridesMap() {
        return this.rolePermissionOverrides;
    }

    @Override
    public void deleteMessages(Collection<Message> messages) {
        this.deleteMessagesByIds(messages.stream().map(msg -> msg.getId()).collect(Collectors.toList()));
    }

    @Override
    public void deleteMessagesByIds(Collection<String> messageIds) {
        if (messageIds.size() < 2 || messageIds.size() > 100) {
            throw new IllegalArgumentException("Must provide at least 2 or at most 100 messages to be deleted.");
        }
        if (!PermissionUtil.checkPermission((User)this.getJDA().getSelfInfo(), Permission.MESSAGE_MANAGE, this)) {
            throw new PermissionException(Permission.MESSAGE_MANAGE, "Must have MESSAGE_MANAGE in order to bulk delete messages in this channel regardless of author.");
        }
        JSONObject body = new JSONObject().put("messages", messageIds);
        Requester.Response response = ((JDAImpl)this.getJDA()).getRequester().post("https://discordapp.com/api/channels/" + this.id + "/messages/bulk_delete", body);
        if (response.isRateLimit()) {
            throw new RateLimitedException(response.getObject().getInt("retry_after"));
        }
    }

    private void checkVerification() {
        if (!this.guild.checkVerification()) {
            throw new VerificationLevelException(this.guild.getVerificationLevel());
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof TextChannel)) {
            return false;
        }
        TextChannel oTChannel = (TextChannel)o;
        return this == oTChannel || this.getId().equals(oTChannel.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "TC:" + this.getName() + '(' + this.getId() + ')';
    }

    @Override
    public int compareTo(TextChannel chan) {
        if (this == chan) {
            return 0;
        }
        if (this.getGuild() != chan.getGuild()) {
            throw new IllegalArgumentException("Cannot compare TextChannels that aren't from the same guild!");
        }
        if (this.getPositionRaw() != chan.getPositionRaw()) {
            return chan.getPositionRaw() - this.getPositionRaw();
        }
        OffsetDateTime thisTime = MiscUtil.getCreationTime(this);
        OffsetDateTime chanTime = MiscUtil.getCreationTime(chan);
        return chanTime.compareTo(thisTime);
    }

    public static class AsyncMessageSender {
        private static final Map<JDA, Map<String, AsyncMessageSender>> instances = new HashMap<JDA, Map<String, AsyncMessageSender>>();
        private final JDAImpl api;
        private final String ratelimitIdentifier;
        private Runner runner = null;
        private boolean runnerRunning = false;
        private boolean alive = true;
        private final Queue<Task> queue = new LinkedList<Task>();

        private AsyncMessageSender(JDAImpl api, String ratelimitIdentifier) {
            this.api = api;
            this.ratelimitIdentifier = ratelimitIdentifier;
        }

        public static AsyncMessageSender getInstance(JDA api, String ratelimitIdentifier) {
            AsyncMessageSender sender;
            Map<String, AsyncMessageSender> senders = instances.get(api);
            if (senders == null) {
                senders = new HashMap<String, AsyncMessageSender>();
                instances.put(api, senders);
            }
            if ((sender = senders.get(ratelimitIdentifier)) == null) {
                sender = new AsyncMessageSender((JDAImpl)api, ratelimitIdentifier);
                senders.put(ratelimitIdentifier, sender);
            }
            return sender;
        }

        public static synchronized void stop(JDA api, String ratelimitIdentifier) {
            AsyncMessageSender sender;
            Map<String, AsyncMessageSender> senders = instances.get(api);
            if (senders != null && !senders.isEmpty() && (sender = senders.get(ratelimitIdentifier)) != null) {
                sender.kill();
                senders.remove(ratelimitIdentifier);
            }
        }

        public static synchronized void stopAll(JDA api) {
            Map<String, AsyncMessageSender> senders = instances.get(api);
            if (senders != null && !senders.isEmpty()) {
                senders.values().forEach(sender -> sender.kill());
                senders.clear();
            }
        }

        public synchronized void enqueue(Message msg, boolean isEdit, Consumer<Message> callback) {
            this.enqueue(new Task(msg, isEdit, callback));
        }

        public synchronized void enqueue(Task task) {
            this.queue.add(task);
            if (this.runner == null) {
                this.runnerRunning = true;
                this.runner = new Runner(this);
                this.runner.setDaemon(true);
                this.runner.start();
            } else if (!this.runnerRunning) {
                this.runnerRunning = true;
                this.notifyAll();
            }
        }

        public synchronized void kill() {
            this.alive = false;
            this.notifyAll();
        }

        private synchronized void waitNew() {
            if (!this.queue.isEmpty()) {
                return;
            }
            this.runnerRunning = false;
            while (!this.runnerRunning) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private synchronized Queue<Task> getQueue() {
            LinkedList<Task> copy = new LinkedList<Task>(this.queue);
            this.queue.clear();
            return copy;
        }

        private static class Runner
        extends Thread {
            private final AsyncMessageSender sender;

            public Runner(AsyncMessageSender sender) {
                this.sender = sender;
                this.setName("AsyncMessageSender Runner. Identifier: " + sender.ratelimitIdentifier);
            }

            @Override
            public void run() {
                block5: while (this.sender.alive) {
                    Queue queue = this.sender.getQueue();
                    while (this.sender.alive && !queue.isEmpty()) {
                        Long messageLimit = this.sender.api.getMessageLimit(this.sender.ratelimitIdentifier);
                        if (messageLimit != null) {
                            try {
                                Thread.sleep(messageLimit - System.currentTimeMillis());
                            }
                            catch (InterruptedException e) {
                                JDAImpl.LOG.log(e);
                            }
                        }
                        Task task = (Task)queue.peek();
                        Message msg = task.message;
                        if (this.sender.api.getTextChannelById(msg.getChannelId()) == null && this.sender.api.getPrivateChannelById(msg.getChannelId()) == null) {
                            AsyncMessageSender.stop(this.sender.api, this.sender.ratelimitIdentifier);
                            break block5;
                        }
                        Requester.Response response = task.isEdit ? this.sender.api.getRequester().patch("https://discordapp.com/api/channels/" + msg.getChannelId() + "/messages/" + msg.getId(), new JSONObject().put("content", msg.getRawContent())) : this.sender.api.getRequester().post("https://discordapp.com/api/channels/" + msg.getChannelId() + "/messages", new JSONObject().put("content", msg.getRawContent()).put("tts", msg.isTTS()));
                        if (response.responseText == null) {
                            JDAImpl.LOG.debug("Error sending async-message (returned null-text)... Retrying after 1s");
                            this.sender.api.setMessageTimeout(this.sender.ratelimitIdentifier, 1000L);
                        } else if (!response.isRateLimit()) {
                            queue.poll();
                            try {
                                if (response.isOk()) {
                                    if (task.callback != null) {
                                        task.callback.accept(new EntityBuilder(this.sender.api).createMessage(response.getObject()));
                                    }
                                } else {
                                    JDAImpl.LOG.fatal("Could not send/update async message to channel: " + msg.getChannelId() + ". Discord-response: " + response.toString());
                                    if (task.callback != null) {
                                        task.callback.accept(null);
                                    }
                                }
                            }
                            catch (JSONException ex) {
                                JDAImpl.LOG.log(ex);
                            }
                            catch (IllegalArgumentException ex) {
                                JDAImpl.LOG.log(ex);
                            }
                        } else {
                            this.sender.api.setMessageTimeout(this.sender.ratelimitIdentifier, response.getObject().getLong("retry_after"));
                        }
                        if (!queue.isEmpty()) continue;
                        queue = this.sender.getQueue();
                    }
                    this.sender.waitNew();
                }
            }
        }

        public static class Task {
            public final Message message;
            public final boolean isEdit;
            public final Consumer<Message> callback;

            public Task(Message message, boolean isEdit, Consumer<Message> callback) {
                this.message = message;
                this.isEdit = isEdit;
                this.callback = callback;
            }
        }
    }
}

