/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.entities.impl;

import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.Permission;
import net.dv8tion.jda.Region;
import net.dv8tion.jda.entities.Emote;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.Role;
import net.dv8tion.jda.entities.TextChannel;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.VoiceChannel;
import net.dv8tion.jda.entities.VoiceStatus;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.exceptions.GuildUnavailableException;
import net.dv8tion.jda.exceptions.PermissionException;
import net.dv8tion.jda.handle.EntityBuilder;
import net.dv8tion.jda.managers.AudioManager;
import net.dv8tion.jda.managers.ChannelManager;
import net.dv8tion.jda.managers.GuildManager;
import net.dv8tion.jda.managers.RoleManager;
import net.dv8tion.jda.utils.InviteUtil;
import net.dv8tion.jda.utils.MiscUtil;
import net.dv8tion.jda.utils.PermissionUtil;
import org.json.JSONObject;

public class GuildImpl
implements Guild {
    private final String id;
    private String name;
    private String iconId;
    private String afkChannelId;
    private User owner;
    private int afkTimeout;
    private Region region;
    private final Map<String, TextChannel> textChannels = new HashMap<String, TextChannel>();
    private final Map<String, VoiceChannel> voiceChannels = new HashMap<String, VoiceChannel>();
    private final Map<User, List<Role>> userRoles = new HashMap<User, List<Role>>();
    private final Map<String, Role> roles = new HashMap<String, Role>();
    private final Map<User, VoiceStatus> voiceStatusMap = new HashMap<User, VoiceStatus>();
    private final Map<User, OffsetDateTime> joinedAtMap = new HashMap<User, OffsetDateTime>();
    private final Map<User, String> nickMap = new HashMap<User, String>();
    private final Map<String, Emote> emoteMap = new HashMap<String, Emote>();
    private Role publicRole;
    private TextChannel publicChannel;
    private final JDAImpl api;
    private Guild.VerificationLevel verificationLevel;
    private boolean available;
    private GuildManager manager = null;
    private boolean canSendVerification = false;

    public GuildImpl(JDAImpl api, String id) {
        this.api = api;
        this.id = id;
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIconId() {
        return this.iconId;
    }

    @Override
    public String getIconUrl() {
        return this.iconId == null ? null : "https://cdn.discordapp.com/icons/" + this.getId() + "/" + this.getIconId() + ".jpg";
    }

    @Override
    public String getAfkChannelId() {
        return this.afkChannelId;
    }

    @Override
    public String getOwnerId() {
        return this.owner.getId();
    }

    @Override
    public User getOwner() {
        return this.owner;
    }

    @Override
    public int getAfkTimeout() {
        return this.afkTimeout;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public List<Emote> getEmotes() {
        return Collections.unmodifiableList(new LinkedList<Emote>(this.getEmoteMap().values()));
    }

    @Override
    public List<User> getUsers() {
        return Collections.unmodifiableList(new ArrayList<User>(this.userRoles.keySet()));
    }

    @Override
    public boolean isMember(User user) {
        return this.getRolesForUser(user) != null;
    }

    @Override
    public List<TextChannel> getTextChannels() {
        ArrayList<TextChannel> textChannels = new ArrayList<TextChannel>(this.textChannels.values());
        Collections.sort(textChannels, (c1, c2) -> c2.compareTo(c1));
        return Collections.unmodifiableList(textChannels);
    }

    @Override
    public ChannelManager createTextChannel(String name) {
        if (!PermissionUtil.checkPermission((User)this.getJDA().getSelfInfo(), Permission.MANAGE_CHANNEL, this)) {
            throw new PermissionException(Permission.MANAGE_CHANNEL);
        }
        if (name == null) {
            throw new IllegalArgumentException("TextChannel name must not be null");
        }
        if (!this.available) {
            throw new GuildUnavailableException();
        }
        JSONObject response = this.api.getRequester().post("https://discordapp.com/api/guilds/" + this.getId() + "/channels", new JSONObject().put("name", name).put("type", "text")).getObject();
        if (response == null || !response.has("id")) {
            throw new RuntimeException("Creating a new TextChannel failed. Reason: " + (response == null ? "Unknown" : response.toString()));
        }
        TextChannel channel = new EntityBuilder(this.api).createTextChannel(response, this.getId());
        return channel.getManager();
    }

    @Override
    public List<VoiceChannel> getVoiceChannels() {
        ArrayList<VoiceChannel> list = new ArrayList<VoiceChannel>(this.voiceChannels.values());
        Collections.sort(list, (v1, v2) -> v2.compareTo(v1));
        return Collections.unmodifiableList(list);
    }

    @Override
    public ChannelManager createVoiceChannel(String name) {
        if (!PermissionUtil.checkPermission((User)this.getJDA().getSelfInfo(), Permission.MANAGE_CHANNEL, this)) {
            throw new PermissionException(Permission.MANAGE_CHANNEL);
        }
        if (name == null) {
            throw new IllegalArgumentException("VoiceChannel name must not be null");
        }
        if (!this.available) {
            throw new GuildUnavailableException();
        }
        JSONObject response = this.api.getRequester().post("https://discordapp.com/api/guilds/" + this.getId() + "/channels", new JSONObject().put("name", name).put("type", "voice")).getObject();
        if (response == null || !response.has("id")) {
            throw new RuntimeException("Creating a new VoiceChannel failed. Reason: " + (response == null ? "Unknown" : response.toString()));
        }
        VoiceChannel channel = new EntityBuilder(this.api).createVoiceChannel(response, this.getId());
        return channel.getManager();
    }

    @Override
    public List<Role> getRoles() {
        ArrayList<Role> list = new ArrayList<Role>(this.roles.values());
        Collections.sort(list, (r1, r2) -> r2.compareTo(r1));
        return Collections.unmodifiableList(list);
    }

    @Override
    public Role getRoleById(String id) {
        return this.roles.get(id);
    }

    @Override
    public RoleManager createRole() {
        if (!PermissionUtil.checkPermission((User)this.getJDA().getSelfInfo(), Permission.MANAGE_ROLES, this)) {
            throw new PermissionException(Permission.MANAGE_ROLES);
        }
        if (!this.available) {
            throw new GuildUnavailableException();
        }
        JSONObject response = this.api.getRequester().post("https://discordapp.com/api/guilds/" + this.getId() + "/roles", new JSONObject()).getObject();
        if (response == null || !response.has("id")) {
            throw new RuntimeException("Creating a new Role failed. Reason: " + (response == null ? "Unknown" : response.toString()));
        }
        Role role = new EntityBuilder(this.api).createRole(response, this.getId());
        return role.getManager();
    }

    @Override
    public RoleManager createCopyOfRole(Role role) {
        if (!PermissionUtil.checkPermission((User)role.getJDA().getSelfInfo(), Permission.MANAGE_ROLES, role.getGuild())) {
            throw new PermissionException(Permission.MANAGE_ROLES);
        }
        for (Permission perm : role.getPermissions()) {
            if (PermissionUtil.checkPermission((User)role.getJDA().getSelfInfo(), perm, role.getGuild())) continue;
            throw new PermissionException(perm);
        }
        RoleManager manager = this.createRole();
        manager.setPermissionsRaw(role.getPermissionsRaw());
        manager.setName(role.getName());
        manager.setColor(role.getColor());
        manager.setGrouped(role.isGrouped());
        manager.setMentionable(role.isMentionable());
        manager.update();
        return manager;
    }

    @Override
    public List<Role> getRolesForUser(User user) {
        List<Role> roles = this.userRoles.get(user);
        if (roles == null) {
            return null;
        }
        roles = new ArrayList<Role>(roles);
        Collections.sort(roles, (r1, r2) -> r2.compareTo(r1));
        return Collections.unmodifiableList(roles);
    }

    @Override
    public Role getColorDeterminantRoleForUser(User user) {
        for (Role role : this.getRolesForUser(user)) {
            if (role.getColor() == 0) continue;
            return role;
        }
        return this.publicRole;
    }

    @Override
    public List<User> getUsersWithRole(Role role) {
        LinkedList users = new LinkedList();
        this.userRoles.entrySet().forEach(entry -> {
            if (((List)entry.getValue()).contains(role)) {
                users.add(entry.getKey());
            }
        });
        return Collections.unmodifiableList(users);
    }

    @Override
    public Role getPublicRole() {
        return this.publicRole;
    }

    @Override
    public TextChannel getPublicChannel() {
        return this.publicChannel;
    }

    @Override
    public OffsetDateTime getJoinDateForUser(User user) {
        return this.joinedAtMap.get(user);
    }

    @Override
    public synchronized GuildManager getManager() {
        if (this.manager == null) {
            this.manager = new GuildManager(this);
        }
        return this.manager;
    }

    @Override
    public synchronized AudioManager getAudioManager() {
        return this.api.getAudioManager(this);
    }

    @Override
    public VoiceStatus getVoiceStatusOfUser(User user) {
        return this.voiceStatusMap.get(user);
    }

    @Override
    public List<VoiceStatus> getVoiceStatuses() {
        return Collections.unmodifiableList(new LinkedList<VoiceStatus>(this.voiceStatusMap.values()));
    }

    @Override
    public String getNicknameForUser(User user) {
        return this.nickMap.get(user);
    }

    @Override
    public Guild.VerificationLevel getVerificationLevel() {
        return this.verificationLevel;
    }

    @Override
    public boolean checkVerification() {
        if (this.api.getSelfInfo().isBot()) {
            return true;
        }
        if (this.canSendVerification) {
            return true;
        }
        switch (this.verificationLevel) {
            case HIGH: {
                if (ChronoUnit.MINUTES.between(this.getJoinDateForUser(this.api.getSelfInfo()), OffsetDateTime.now()) < 10L) break;
            }
            case MEDIUM: {
                if (ChronoUnit.MINUTES.between(MiscUtil.getCreationTime(this.api.getSelfInfo()), OffsetDateTime.now()) < 5L) break;
            }
            case LOW: {
                if (!this.api.getSelfInfo().isVerified()) break;
            }
            case NONE: {
                this.canSendVerification = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    public Map<String, Role> getRolesMap() {
        return this.roles;
    }

    public Map<User, List<Role>> getUserRoles() {
        return this.userRoles;
    }

    public GuildImpl setName(String name) {
        this.name = name;
        return this;
    }

    public GuildImpl setIconId(String iconId) {
        this.iconId = iconId;
        return this;
    }

    public GuildImpl setOwner(User owner) {
        this.owner = owner;
        return this;
    }

    public GuildImpl setAfkTimeout(int afkTimeout) {
        this.afkTimeout = afkTimeout;
        return this;
    }

    public GuildImpl setAfkChannelId(String channelId) {
        this.afkChannelId = channelId;
        return this;
    }

    public GuildImpl setRegion(Region region) {
        this.region = region;
        return this;
    }

    public GuildImpl setPublicRole(Role role) {
        this.publicRole = role;
        return this;
    }

    public GuildImpl setPublicChannel(TextChannel channel) {
        this.publicChannel = channel;
        return this;
    }

    public Map<String, Emote> getEmoteMap() {
        return this.emoteMap;
    }

    public Map<String, TextChannel> getTextChannelsMap() {
        return this.textChannels;
    }

    public Map<String, VoiceChannel> getVoiceChannelsMap() {
        return this.voiceChannels;
    }

    public Map<User, VoiceStatus> getVoiceStatusMap() {
        return this.voiceStatusMap;
    }

    public Map<User, OffsetDateTime> getJoinedAtMap() {
        return this.joinedAtMap;
    }

    public Map<User, String> getNickMap() {
        return this.nickMap;
    }

    public GuildImpl setVerificationLevel(Guild.VerificationLevel level) {
        this.verificationLevel = level;
        this.canSendVerification = false;
        return this;
    }

    public GuildImpl setAvailable(boolean available) {
        this.available = available;
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Guild)) {
            return false;
        }
        Guild oGuild = (Guild)o;
        return this == oGuild || this.getId().equals(oGuild.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "G:" + this.getName() + '(' + this.getId() + ')';
    }

    @Override
    public List<InviteUtil.AdvancedInvite> getInvites() {
        return InviteUtil.getInvites(this);
    }

    @Override
    public User getUserById(String id) {
        return this.userRoles.containsKey(this.api.getUserById(id)) ? this.api.getUserById(id) : null;
    }

    @Override
    public List<User> getUsersByName(String username) {
        return Collections.unmodifiableList(this.userRoles.keySet().parallelStream().filter(user -> user.getUsername().equals(username)).collect(Collectors.toList()));
    }

    @Override
    public List<Role> getRolesByName(String roleName) {
        return Collections.unmodifiableList(this.roles.values().parallelStream().filter(role -> role.getName().equals(roleName)).collect(Collectors.toList()));
    }

    @Override
    public String getEffectiveNameForUser(User user) {
        return this.nickMap.containsKey(user) ? this.nickMap.get(user) : user.getUsername();
    }
}

