/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.entities;

import java.io.File;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.function.Consumer;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.entities.Emote;
import net.dv8tion.jda.entities.MessageChannel;
import net.dv8tion.jda.entities.MessageEmbed;
import net.dv8tion.jda.entities.MessageType;
import net.dv8tion.jda.entities.Role;
import net.dv8tion.jda.entities.TextChannel;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.requests.Requester;

public interface Message {
    public String getId();

    public List<User> getMentionedUsers();

    public boolean isMentioned(User var1);

    public List<TextChannel> getMentionedChannels();

    public List<Role> getMentionedRoles();

    public boolean mentionsEveryone();

    public OffsetDateTime getTime();

    public boolean isEdited();

    public OffsetDateTime getEditedTimestamp();

    public User getAuthor();

    public String getContent();

    public String getRawContent();

    public String getStrippedContent();

    public boolean isPrivate();

    public String getChannelId();

    public MessageChannel getChannel();

    public List<Attachment> getAttachments();

    public List<MessageEmbed> getEmbeds();

    public List<Emote> getEmotes();

    public boolean isTTS();

    public Message updateMessage(String var1);

    public void updateMessageAsync(String var1, Consumer<Message> var2);

    public void deleteMessage();

    public JDA getJDA();

    public boolean isPinned();

    public boolean pin();

    public boolean unpin();

    public MessageType getType();

    public static class Attachment {
        private final String id;
        private final String url;
        private final String proxyUrl;
        private final String fileName;
        private final int size;
        private final int height;
        private final int width;
        private final JDA jda;

        public Attachment(String id, String url, String proxyUrl, String fileName, int size, int height, int width, JDA jda) {
            this.id = id;
            this.url = url;
            this.proxyUrl = proxyUrl;
            this.fileName = fileName;
            this.size = size;
            this.height = height;
            this.width = width;
            this.jda = jda;
        }

        public String getId() {
            return this.id;
        }

        public String getUrl() {
            return this.url;
        }

        public String getProxyUrl() {
            return this.proxyUrl;
        }

        public String getFileName() {
            return this.fileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean download(File file) {
            InputStream in = null;
            try {
                URL url = new URL(this.getUrl());
                URLConnection con = this.jda.getGlobalProxy() == null ? url.openConnection() : url.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.jda.getGlobalProxy().getAddress(), this.jda.getGlobalProxy().getPort())));
                con.addRequestProperty("user-agent", Requester.USER_AGENT);
                in = con.getInputStream();
                Files.copy(in, Paths.get(file.getAbsolutePath(), new String[0]), new CopyOption[0]);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                JDAImpl.LOG.log(e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return false;
        }

        public int getSize() {
            return this.size;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isImage() {
            return this.height > 0 && this.width > 0;
        }
    }
}

