/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.audio;

import com.neovisionaries.ws.client.ProxySettings;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketFrame;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.audio.AudioConnection;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.VoiceChannel;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.events.audio.AudioDisconnectEvent;
import net.dv8tion.jda.events.audio.AudioRegionChangeEvent;
import net.dv8tion.jda.events.audio.AudioUnableToConnectEvent;
import net.dv8tion.jda.managers.impl.AudioManagerImpl;
import net.dv8tion.jda.utils.SimpleLog;
import org.apache.http.HttpHost;
import org.json.JSONArray;
import org.json.JSONObject;

public class AudioWebSocket
extends WebSocketAdapter {
    public static final SimpleLog LOG = SimpleLog.getLog("JDAAudioSocket");
    public static final int DISCORD_SECRET_KEY_LENGTH = 32;
    public static final int INITIAL_CONNECTION_RESPONSE = 2;
    public static final int HEARTBEAT_PING_RETURN = 3;
    public static final int CONNECTING_COMPLETED = 4;
    public static final int USER_SPEAKING_UPDATE = 5;
    public static final int WEBSOCKET_READ_TIMEOUT = 1008;
    public static final int CONNECTION_SETUP_TIMEOUT = -41;
    public static final int UDP_UNABLE_TO_CONNECT = -42;
    protected AudioConnection audioConnection;
    private final JDAImpl api;
    private final Guild guild;
    private final HttpHost proxy;
    private boolean connected = false;
    private boolean ready = false;
    private Thread keepAliveThread;
    public WebSocket socket;
    private String endpoint;
    private String wssEndpoint;
    private boolean shutdown;
    private int ssrc;
    private String sessionId;
    private String token;
    private byte[] secretKey;
    private DatagramSocket udpSocket;
    private InetSocketAddress address;
    private Thread udpKeepAliveThread;

    public AudioWebSocket(String endpoint, JDAImpl api, Guild guild, String sessionId, String token) {
        this.endpoint = endpoint;
        this.api = api;
        this.guild = guild;
        this.sessionId = sessionId;
        this.token = token;
        if (!endpoint.startsWith("wss://")) {
            this.wssEndpoint = "wss://" + endpoint;
        }
        if (sessionId == null || sessionId.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a voice connection using a null/empty sessionId!");
        }
        if (token == null || token.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a voice connection using a null/empty token!");
        }
        this.proxy = api.getGlobalProxy();
        WebSocketFactory factory = new WebSocketFactory();
        if (this.proxy != null) {
            ProxySettings settings = factory.getProxySettings();
            settings.setHost(this.proxy.getHostName());
            settings.setPort(this.proxy.getPort());
        }
        try {
            this.socket = factory.createSocket(this.wssEndpoint).addListener(this);
            this.socket.connect();
        }
        catch (WebSocketException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void send(String message) {
        this.socket.sendText(message);
    }

    @Override
    public void onConnected(WebSocket websocket, Map<String, List<String>> headers) {
        JSONObject connectObj = new JSONObject().put("op", 0).put("d", new JSONObject().put("server_id", this.guild.getId()).put("user_id", this.api.getSelfInfo().getId()).put("session_id", this.sessionId).put("token", this.token));
        this.send(connectObj.toString());
        this.connected = true;
    }

    @Override
    public void onTextMessage(WebSocket websocket, String message) {
        JSONObject contentAll = new JSONObject(message);
        int opCode = contentAll.getInt("op");
        switch (opCode) {
            case 2: {
                JSONObject content = contentAll.getJSONObject("d");
                this.ssrc = content.getInt("ssrc");
                int port = content.getInt("port");
                int heartbeatInterval = content.getInt("heartbeat_interval");
                InetSocketAddress externalIpAndPort = null;
                int tries = 0;
                do {
                    if ((externalIpAndPort = this.handleUdpDiscovery(new InetSocketAddress(this.endpoint, port), this.ssrc)) != null || ++tries <= 5) continue;
                    this.close(false, -42);
                    return;
                } while (externalIpAndPort == null);
                this.setupUdpKeepAliveThread();
                this.send(new JSONObject().put("op", 1).put("d", new JSONObject().put("protocol", "udp").put("data", new JSONObject().put("address", externalIpAndPort.getHostString()).put("port", externalIpAndPort.getPort()).put("mode", "xsalsa20_poly1305"))).toString());
                this.setupKeepAliveThread(heartbeatInterval);
                break;
            }
            case 3: {
                if (LOG.getEffectiveLevel().getPriority() > SimpleLog.Level.TRACE.getPriority()) break;
                long timePingSent = contentAll.getLong("d");
                long ping = System.currentTimeMillis() - timePingSent;
                LOG.trace("ping: " + ping + "ms");
                break;
            }
            case 4: {
                JSONArray keyArray = contentAll.getJSONObject("d").getJSONArray("secret_key");
                this.secretKey = new byte[32];
                for (int i = 0; i < keyArray.length(); ++i) {
                    this.secretKey[i] = (byte)keyArray.getInt(i);
                }
                LOG.trace("Audio connection has finished connecting!");
                this.ready = true;
                break;
            }
            case 5: {
                JSONObject content = contentAll.getJSONObject("d");
                boolean speaking = content.getBoolean("speaking");
                int ssrc = content.getInt("ssrc");
                String userId = content.getString("user_id");
                User user = this.api.getUserById(userId);
                if (user == null) {
                    LOG.warn("Got an Audio USER_SPEAKING_UPDATE for a non-existent User. JSON: " + contentAll);
                    return;
                }
                this.audioConnection.updateUserSSRC(ssrc, userId, speaking);
                if (speaking) {
                    LOG.log(SimpleLog.Level.ALL, user.getUsername() + " started transmitting audio.");
                    break;
                }
                LOG.log(SimpleLog.Level.ALL, user.getUsername() + " stopped transmitting audio.");
                break;
            }
            default: {
                LOG.debug("Unknown Audio OP code.\n" + contentAll.toString(4));
            }
        }
    }

    @Override
    public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) {
        LOG.debug("The Audio connection was closed!");
        LOG.debug("By remote? " + closedByServer);
        if (serverCloseFrame != null) {
            LOG.debug("Reason: " + serverCloseFrame.getCloseReason());
            LOG.debug("Close code: " + serverCloseFrame.getCloseCode());
        }
        if (clientCloseFrame != null) {
            LOG.debug("ClientReason: " + clientCloseFrame.getCloseReason());
            LOG.debug("ClientCode: " + clientCloseFrame.getCloseCode());
            this.close(false, clientCloseFrame.getCloseCode());
        } else {
            this.close(false, -1);
        }
    }

    @Override
    public void onUnexpectedError(WebSocket websocket, WebSocketException cause) {
        this.handleCallbackError(websocket, cause);
    }

    @Override
    public void handleCallbackError(WebSocket websocket, Throwable cause) {
        LOG.log(cause);
    }

    public void close(boolean regionChange, int disconnectCode) {
        if (this.shutdown) {
            return;
        }
        this.connected = false;
        this.ready = false;
        this.shutdown = true;
        if (!regionChange) {
            JSONObject obj = new JSONObject().put("op", 4).put("d", new JSONObject().put("guild_id", this.guild.getId()).put("channel_id", JSONObject.NULL).put("self_mute", false).put("self_deaf", false));
            this.api.getClient().send(obj.toString());
        }
        if (this.keepAliveThread != null) {
            this.keepAliveThread.interrupt();
            this.keepAliveThread = null;
        }
        if (this.udpKeepAliveThread != null) {
            this.udpKeepAliveThread.interrupt();
            this.udpKeepAliveThread = null;
        }
        if (this.udpSocket != null) {
            this.udpSocket.close();
        }
        if (this.socket != null && this.socket.isOpen()) {
            this.socket.sendClose(1000);
        }
        AudioManagerImpl manager = (AudioManagerImpl)this.guild.getAudioManager();
        VoiceChannel disconnectedChannel = manager.getConnectedChannel();
        manager.setAudioConnection(null);
        if (disconnectCode == 1008 || disconnectCode == -42) {
            LOG.warn("Unexpected disconnect of Audio Connection to guild: " + this.guild.getId());
            manager.setUnexpectedDisconnectChannel(disconnectedChannel);
        }
        if (regionChange) {
            this.api.getEventManager().handle(new AudioRegionChangeEvent((JDA)this.api, disconnectedChannel));
        } else {
            switch (disconnectCode) {
                case -41: {
                    break;
                }
                case -42: {
                    this.api.getEventManager().handle(new AudioUnableToConnectEvent((JDA)this.api, disconnectedChannel));
                    break;
                }
                default: {
                    this.api.getEventManager().handle(new AudioDisconnectEvent((JDA)this.api, disconnectedChannel));
                }
            }
        }
    }

    public DatagramSocket getUdpSocket() {
        return this.udpSocket;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public byte[] getSecretKey() {
        return Arrays.copyOf(this.secretKey, this.secretKey.length);
    }

    public int getSSRC() {
        return this.ssrc;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isReady() {
        return this.ready;
    }

    private InetSocketAddress handleUdpDiscovery(InetSocketAddress address, int ssrc) {
        try {
            this.udpSocket = new DatagramSocket();
            ByteBuffer buffer = ByteBuffer.allocate(70);
            buffer.putInt(ssrc);
            DatagramPacket discoveryPacket = new DatagramPacket(buffer.array(), buffer.array().length, address);
            this.udpSocket.send(discoveryPacket);
            DatagramPacket receivedPacket = new DatagramPacket(new byte[70], 70);
            this.udpSocket.setSoTimeout(1000);
            this.udpSocket.receive(receivedPacket);
            byte[] received = receivedPacket.getData();
            String ourIP = new String(receivedPacket.getData());
            ourIP = ourIP.substring(0, ourIP.length() - 2);
            ourIP = ourIP.trim();
            byte[] portBytes = new byte[]{received[received.length - 1], received[received.length - 2]};
            int firstByte = 0xFF & portBytes[0];
            int secondByte = 0xFF & portBytes[1];
            int ourPort = firstByte << 8 | secondByte;
            this.address = address;
            return new InetSocketAddress(ourIP, ourPort);
        }
        catch (SocketException e) {
            return null;
        }
        catch (IOException e) {
            LOG.log(e);
            return null;
        }
    }

    private void setupUdpKeepAliveThread() {
        this.udpKeepAliveThread = new Thread("AudioWebSocket UDP-KeepAlive Guild: " + this.guild.getId()){

            @Override
            public void run() {
                while (AudioWebSocket.this.socket.isOpen() && !AudioWebSocket.this.udpSocket.isClosed() && !this.isInterrupted()) {
                    long seq = 0L;
                    try {
                        ByteBuffer buffer = ByteBuffer.allocate(9);
                        buffer.put((byte)-55);
                        buffer.putLong(seq);
                        DatagramPacket keepAlivePacket = new DatagramPacket(buffer.array(), buffer.array().length, AudioWebSocket.this.address);
                        AudioWebSocket.this.udpSocket.send(keepAlivePacket);
                        Thread.sleep(5000L);
                    }
                    catch (NoRouteToHostException e) {
                        LOG.warn("Closing AudioConnection due to inability to ping audio packets.");
                        LOG.warn("Cannot send audio packet because JDA navigate the route to Discord.\nAre you sure you have internet connection? It is likely that you've lost connection.");
                        AudioWebSocket.this.close(true, -1);
                        break;
                    }
                    catch (IOException e) {
                        LOG.log(e);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        this.udpKeepAliveThread.setPriority(6);
        this.udpKeepAliveThread.setDaemon(true);
        this.udpKeepAliveThread.start();
    }

    private void setupKeepAliveThread(final int keepAliveInterval) {
        this.keepAliveThread = new Thread("AudioWebSocket WS-KeepAlive Guild: " + this.guild.getId()){

            @Override
            public void run() {
                while (AudioWebSocket.this.socket.isOpen() && !this.isInterrupted()) {
                    AudioWebSocket.this.send(new JSONObject().put("op", 3).put("d", System.currentTimeMillis()).toString());
                    try {
                        Thread.sleep(keepAliveInterval);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        this.keepAliveThread.setPriority(10);
        this.keepAliveThread.setDaemon(true);
        this.keepAliveThread.start();
    }
}

