/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda;

import java.util.LinkedList;
import java.util.List;
import net.dv8tion.jda.Permission;
import net.dv8tion.jda.entities.Message;
import net.dv8tion.jda.entities.MessageChannel;
import net.dv8tion.jda.entities.PrivateChannel;
import net.dv8tion.jda.entities.TextChannel;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.exceptions.PermissionException;
import net.dv8tion.jda.handle.EntityBuilder;
import net.dv8tion.jda.requests.Requester;
import org.json.JSONArray;

public class MessageHistory {
    private final JDAImpl api;
    private final String channelId;
    private String lastId = null;
    private boolean atEnd = false;
    private final List<Message> queued = new LinkedList<Message>();

    public MessageHistory(MessageChannel channel) {
        JDAImpl jDAImpl = this.api = channel instanceof TextChannel ? (JDAImpl)((TextChannel)channel).getJDA() : (JDAImpl)((PrivateChannel)channel).getJDA();
        if (channel instanceof TextChannel && !((TextChannel)channel).checkPermission(this.api.getSelfInfo(), Permission.MESSAGE_HISTORY)) {
            throw new PermissionException(Permission.MESSAGE_HISTORY);
        }
        this.channelId = channel instanceof TextChannel ? ((TextChannel)channel).getId() : ((PrivateChannel)channel).getId();
    }

    public List<Message> retrieveAll() {
        while (!this.atEnd && this.retrieve() != null) {
        }
        return this.queued;
    }

    public List<Message> getRecent() {
        return this.queued;
    }

    public List<Message> retrieve() {
        return this.retrieve(100);
    }

    public List<Message> retrieve(int amount) {
        if (this.atEnd) {
            return null;
        }
        LinkedList<Message> out = new LinkedList<Message>();
        EntityBuilder builder = new EntityBuilder(this.api);
        while (amount > 0) {
            int toQueue = Math.min(amount, 100);
            try {
                Requester.Response response = this.api.getRequester().get("https://discordapp.com/api/channels/" + this.channelId + "/messages?limit=" + toQueue + (this.lastId != null ? "&before=" + this.lastId : ""));
                if (!response.isOk()) {
                    throw new RuntimeException("Error fetching message-history for channel with id " + this.channelId + "... Error: " + response.toString());
                }
                JSONArray array = response.getArray();
                for (int i = 0; i < array.length(); ++i) {
                    out.add(builder.createMessage(array.getJSONObject(i)));
                }
                if (array.length() < toQueue) {
                    this.atEnd = true;
                    break;
                }
                this.lastId = out.getLast().getId();
            }
            catch (Exception ex) {
                JDAImpl.LOG.log(ex);
                break;
            }
            amount -= toQueue;
        }
        if (out.size() == 0) {
            return null;
        }
        this.queued.addAll(out);
        return out;
    }
}

