/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.vectorskript.vector;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.Direction;
import io.github.bi0qaw.vectorskript.VectorSkript;
import io.github.bi0qaw.vectorskript.vector.EffRotateVectorAroundAnother;
import io.github.bi0qaw.vectorskript.vector.EffRotateVectorXYZ;
import io.github.bi0qaw.vectorskript.vector.ExprAngleBetweenVectors;
import io.github.bi0qaw.vectorskript.vector.ExprCrossProduct;
import io.github.bi0qaw.vectorskript.vector.ExprCylindricalVector;
import io.github.bi0qaw.vectorskript.vector.ExprDotProduct;
import io.github.bi0qaw.vectorskript.vector.ExprLocationFromVector;
import io.github.bi0qaw.vectorskript.vector.ExprLocationVectorOffset;
import io.github.bi0qaw.vectorskript.vector.ExprRandomVector;
import io.github.bi0qaw.vectorskript.vector.ExprSphericalVector;
import io.github.bi0qaw.vectorskript.vector.ExprVectorArithmetic;
import io.github.bi0qaw.vectorskript.vector.ExprVectorBetweenLocations;
import io.github.bi0qaw.vectorskript.vector.ExprVectorFromXYZ;
import io.github.bi0qaw.vectorskript.vector.ExprVectorFromYawAndPitch;
import io.github.bi0qaw.vectorskript.vector.ExprVectorLength;
import io.github.bi0qaw.vectorskript.vector.ExprVectorNormalize;
import io.github.bi0qaw.vectorskript.vector.ExprVectorOfLocation;
import io.github.bi0qaw.vectorskript.vector.ExprVectorSquaredLength;
import io.github.bi0qaw.vectorskript.vector.ExprVectorXYZ;
import io.github.bi0qaw.vectorskript.vector.ExprVectorYawPitch;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class VectorRegister {
    static {
        Skript.registerEffect(EffRotateVectorAroundAnother.class, (String[])new String[]{"rotate %vectors% around %vector% by %number% [degrees]"});
        Skript.registerEffect(EffRotateVectorXYZ.class, (String[])new String[]{"rotate %vectors% around (1\u00a6x|2\u00a6y|3\u00a6z)(-| )axis by %number% [degrees]"});
        Skript.registerExpression(ExprVectorArithmetic.class, Vector.class, (ExpressionType)ExpressionType.SIMPLE, (String[])ExprVectorArithmetic.patterns.getPatterns());
        Skript.registerExpression(ExprCylindricalVector.class, Vector.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[new] cylindrical vector [(from|with)] [radius] %number%, [yaw] %number%(,| and) [height] %number%"});
        Skript.registerExpression(ExprLocationVectorOffset.class, Location.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"%location%[ ]~[~][ ]%vectors%"});
        Skript.registerExpression(ExprSphericalVector.class, Vector.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[new] spherical vector [(from|with)] [radius] %number%, [yaw] %number%(,| and) [pitch] %number%"});
        Skript.registerExpression(ExprVectorBetweenLocations.class, Vector.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"vector (from|between) %location% (to|and) %location%"});
        Skript.registerExpression(ExprVectorFromYawAndPitch.class, Vector.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[new] vector from yaw %number% and pitch %number%"});
        Skript.registerExpression(ExprVectorYawPitch.class, Number.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"vector (0\u00a6yaw|1\u00a6pitch) of %vector%"});
        if (!VectorSkript.RandomSk) {
            Skript.registerExpression(ExprAngleBetweenVectors.class, Float.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"angle between %vector% and %vector%"});
            Skript.registerExpression(ExprCrossProduct.class, Vector.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"%vector% cross %vector%"});
            Skript.registerExpression(ExprDotProduct.class, Double.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"%vector% dot %vector%"});
            Skript.registerExpression(ExprLocationFromVector.class, Location.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"%vector% [to location] [in] %world%", "location (from|of) %vector% [(from|in)] %world%", "%vector% [to location] [in] %world% with yaw %number% and pitch %number%", "location (from|of) %vector% [(in|from)] %world% with yaw %number% and pitch %number%"});
            Skript.registerExpression(ExprRandomVector.class, Vector.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"random vector"});
            Skript.registerExpression(ExprVectorFromXYZ.class, Vector.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[new] vector [(from|at|to)] %number%,[ ]%number%(,[ ]| and )%number%"});
            Skript.registerExpression(ExprVectorLength.class, Double.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"(vector|standard|normal) length of %vector%", "%vector%['s] (vector|standard|normal) length"});
            Skript.registerExpression(ExprVectorNormalize.class, Vector.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"normalize %vector%", "%vector% normalized"});
            Skript.registerExpression(ExprVectorSquaredLength.class, Double.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"squared length of %vector%", "%vector%['s] squared length"});
            Skript.registerExpression(ExprVectorOfLocation.class, Vector.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"vector (of|from|to) %location%", "%location%['s] vector"});
            Skript.registerExpression(ExprVectorXYZ.class, Number.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"(0\u00a6x|1\u00a6y|2\u00a6z) of %vector%"});
        }
        Converters.registerConverter(Number.class, Vector.class, (Converter)new Converter<Number, Vector>(){

            public Vector convert(Number number) {
                if (number == null) {
                    return null;
                }
                return new Vector(number.doubleValue(), number.doubleValue(), number.doubleValue());
            }
        });
        Converters.registerConverter(Vector.class, Direction.class, (Converter)new Converter<Vector, Direction>(){

            public Direction convert(Vector vector) {
                if (vector == null) {
                    return null;
                }
                return new Direction(vector);
            }
        });
    }
}

