/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.vectorskript.vector;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprVectorXYZ
extends SimplePropertyExpression<Vector, Number> {
    private static final String[] axes = new String[]{"xx", "yy", "zz"};
    private int axis;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.axis = parseResult.mark;
        return true;
    }

    public Double convert(Vector v) {
        return this.axis == 0 ? v.getX() : (this.axis == 1 ? v.getY() : v.getZ());
    }

    protected String getPropertyName() {
        return "the " + axes[this.axis] + "-coordinate";
    }

    public Class<Number> getReturnType() {
        return Number.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if ((mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) && this.getExpr().isSingle() && Changer.ChangerUtils.acceptsChange((Expression)this.getExpr(), (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Vector.class})) {
            return new Class[]{Number.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        assert (delta != null);
        Vector v = (Vector)this.getExpr().getSingle(e);
        if (v == null) {
            return;
        }
        double n = ((Number)delta[0]).doubleValue();
        switch (mode) {
            case REMOVE: {
                n = -n;
            }
            case ADD: {
                if (this.axis == 0) {
                    v.setX(v.getX() + n);
                } else if (this.axis == 1) {
                    v.setY(v.getY() + n);
                } else {
                    v.setZ(v.getZ() + n);
                }
                this.getExpr().change(e, (Object[])new Vector[]{v}, Changer.ChangeMode.SET);
                break;
            }
            case SET: {
                if (this.axis == 0) {
                    v.setX(n);
                } else if (this.axis == 1) {
                    v.setY(n);
                } else {
                    v.setZ(n);
                }
                this.getExpr().change(e, (Object[])new Vector[]{v}, Changer.ChangeMode.SET);
                break;
            }
            case DELETE: 
            case REMOVE_ALL: 
            case RESET: {
                assert (false);
                break;
            }
        }
    }
}

