/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.vectorskript.vector;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.vectorskript.vector.VectorMath;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprVectorFromYawAndPitch
extends SimpleExpression<Vector> {
    private Expression<Number> pitch;
    private Expression<Number> yaw;

    protected Vector[] get(Event event) {
        Number y = (Number)this.yaw.getSingle(event);
        Number p = (Number)this.pitch.getSingle(event);
        if (y == null || p == null) {
            return null;
        }
        float yaw = VectorMath.fromSkriptYaw(VectorMath.wrapAngleDeg(y.floatValue()));
        float pitch = VectorMath.fromSkriptPitch(VectorMath.wrapAngleDeg(p.floatValue()));
        return new Vector[]{VectorMath.fromYawAndPitch(yaw, pitch)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public String toString(Event event, boolean b) {
        return "from yaw " + this.yaw.toString() + " and pitch " + this.pitch.toString();
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.yaw = expressions[0];
        this.pitch = expressions[1];
        return true;
    }
}

