/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.vectorskript.vector;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.vectorskript.vector.VectorMath;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprCylindricalVector
extends SimpleExpression<Vector> {
    private Expression<Number> radius;
    private Expression<Number> yaw;
    private Expression<Number> height;

    public boolean isSingle() {
        return true;
    }

    public String toString(Event event, boolean b) {
        return "cylindrical vector with radius " + this.radius.toString() + ", yaw " + this.yaw.toString() + " and height " + this.height.toString();
    }

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.radius = expressions[0];
        this.yaw = expressions[1];
        this.height = expressions[2];
        return true;
    }

    protected Vector[] get(Event event) {
        Number r = (Number)this.radius.getSingle(event);
        Number y = (Number)this.yaw.getSingle(event);
        Number h = (Number)this.height.getSingle(event);
        if (r == null || y == null || h == null) {
            return null;
        }
        return new Vector[]{VectorMath.fromCylindricalCoordinates(r.doubleValue(), VectorMath.fromSkriptYaw(y.floatValue()), h.doubleValue())};
    }
}

