/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.vector;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import io.github.bi0qaw.vector.VectorMath;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprVectorYawPitch
extends SimplePropertyExpression<Vector, Number> {
    private int mark;
    private static final String[] type = new String[]{"yyaw", "ppitch"};

    public Number convert(Vector vector) {
        if (vector != null) {
            switch (this.mark) {
                case 0: {
                    return Float.valueOf(VectorMath.skriptYaw(VectorMath.getYaw(vector)));
                }
                case 1: {
                    return Float.valueOf(VectorMath.skriptPitch(VectorMath.getPitch(vector)));
                }
            }
        }
        return null;
    }

    protected String getPropertyName() {
        return type[this.mark] + " of vector";
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.mark = parseResult.mark;
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if ((mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) && this.getExpr().isSingle() && Changer.ChangerUtils.acceptsChange((Expression)this.getExpr(), (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Vector.class})) {
            return new Class[]{Number.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Vector v = (Vector)this.getExpr().getSingle(e);
        if (v == null) {
            return;
        }
        float n = ((Number)delta[0]).floatValue();
        float yaw = VectorMath.getYaw(v);
        float pitch = VectorMath.getPitch(v);
        switch (mode) {
            case REMOVE: {
                n = -n;
            }
            case ADD: {
                if (this.mark == 0) {
                    yaw += n;
                } else if (this.mark == 1) {
                    pitch -= n;
                }
                v = VectorMath.fromYawAndPitch(yaw, pitch);
                this.getExpr().change(e, (Object[])new Vector[]{v}, Changer.ChangeMode.SET);
                break;
            }
            case SET: {
                if (this.mark == 0) {
                    yaw = VectorMath.fromSkriptYaw(n);
                } else if (this.mark == 1) {
                    pitch = VectorMath.fromSkriptPitch(n);
                }
                v = VectorMath.fromYawAndPitch(yaw, pitch);
                this.getExpr().change(e, (Object[])new Vector[]{v}, Changer.ChangeMode.SET);
                break;
            }
            case REMOVE_ALL: 
            case DELETE: 
            case RESET: {
                assert (false);
                break;
            }
        }
    }
}

