/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.UmbaskaCord.variables;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.plugin.Plugin;
import uk.co.umbaska.UmbaskaCord.UmbaskaCord;

public class VariableStorageJSON {
    private static JsonObject jsonObject = new JsonObject();
    private static Gson gson = new Gson();
    private static FileWriter fileWriter;
    private static BufferedReader bufferedReader;

    public VariableStorageJSON() {
        File file = new File(UmbaskaCord.umbcord.variableStorage + ".json");
        if (!file.exists()) {
            UmbaskaCord.umbcord.getLogger().info("JSON file not found! This is usually due to the plugin starting for the first time, or you renaming the variables file in the config.");
            UmbaskaCord.umbcord.getLogger().info("JSON file not found! This is usually due to the plugin starting for the first time, or you renaming the variables file in the config.");
            UmbaskaCord.umbcord.getLogger().info("JSON file not found! This is usually due to the plugin starting for the first time, or you renaming the variables file in the config.");
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                UmbaskaCord.umbcord.getLogger().info("Couldn't create JSON File!");
                UmbaskaCord.umbcord.getLogger().info("Couldn't create JSON File!");
                UmbaskaCord.umbcord.getLogger().info("Couldn't create JSON File!");
                e.printStackTrace();
                UmbaskaCord.umbcord.getLogger().info("Couldn't create JSON File!");
                UmbaskaCord.umbcord.getLogger().info("Couldn't create JSON File!");
                UmbaskaCord.umbcord.getLogger().info("Couldn't create JSON File!");
            }
        }
        BungeeCord.getInstance().getScheduler().schedule((Plugin)UmbaskaCord.umbcord, new Runnable(){

            @Override
            public void run() {
                VariableStorageJSON.this.readAgain();
            }
        }, 2L, TimeUnit.SECONDS);
    }

    public void readAgain() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(UmbaskaCord.umbcord.variableStorage + ".json"));
            String line = bufferedReader.readLine();
            UmbaskaCord.umbcord.getLogger().info(line);
            ArrayList<String> values = new ArrayList<String>();
            values.add(line);
            while ((line = bufferedReader.readLine()) != null) {
                values.add(line);
                UmbaskaCord.umbcord.getLogger().info(line);
            }
            if (values.size() >= 0) {
                UmbaskaCord.umbcord.getLogger().info("LOADING FROM .JSON FILE");
                UmbaskaCord.umbcord.getLogger().info("LOADING FROM .JSON FILE");
                UmbaskaCord.umbcord.getLogger().info("LOADING FROM .JSON FILE");
                for (String json : values) {
                    UmbaskaCord.umbcord.getLogger().info("LOADING FROM STRING " + json);
                    if (json == null) continue;
                    JsonParser parser = new JsonParser();
                    for (Map.Entry set : parser.parse(json).getAsJsonObject().entrySet()) {
                        String[] splitValues = ((JsonElement)set.getValue()).getAsString().split("@@UMB@@");
                        if (UmbaskaCord.debugMode.booleanValue()) {
                            UmbaskaCord.umbcord.getLogger().info("REGISTERING JSON MAP " + (String)set.getKey() + " (" + set.getValue() + " [" + splitValues.length + "])");
                        }
                        String trueValue = splitValues[splitValues.length - 1];
                        this.saveJson((String)set.getKey(), trueValue);
                    }
                }
            } else {
                UmbaskaCord.umbcord.getLogger().info("COULDN'T LOAD FROM .JSON FILE");
                UmbaskaCord.umbcord.getLogger().info("COULDN'T LOAD FROM .JSON FILE");
                UmbaskaCord.umbcord.getLogger().info("COULDN'T LOAD FROM .JSON FILE");
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.getData("UMBASKA_VERSION") == null || !this.getData("UMBASKA_VERSION").equals(UmbaskaCord.umbcord.version)) {
            this.saveData("UMBASKA_VERSION", UmbaskaCord.umbcord.version);
        }
    }

    public void close() {
        UmbaskaCord.umbcord.getLogger().info("Shut down VariableStorageJSON");
    }

    public void saveJson(String key, Object value) {
        if (!jsonObject.has(key = key.toLowerCase())) {
            jsonObject.add(key, gson.toJsonTree((Object)("@@UMB@@" + value)));
        } else {
            jsonObject.remove(key);
            jsonObject.add(key, gson.toJsonTree((Object)("@@UMB@@" + value)));
        }
    }

    public void saveData(String key, String value) {
        FileWriter fileWriter = null;
        key = key.toLowerCase();
        try {
            fileWriter = new FileWriter(UmbaskaCord.umbcord.variableStorage + ".json");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!jsonObject.has(key)) {
            jsonObject.add(key, gson.toJsonTree((Object)value));
        } else {
            jsonObject.remove(key);
            jsonObject.add(key, gson.toJsonTree((Object)value));
        }
        try {
            File file = new File(UmbaskaCord.umbcord.variableStorage + ".json");
            if (file.exists()) {
                file.delete();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            fileWriter = new FileWriter(UmbaskaCord.umbcord.variableStorage + ".json");
            fileWriter.write(jsonObject.toString());
            System.out.println("Successfully Saved to File...");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fileWriter.flush();
            fileWriter.close();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getData(String key) {
        if (!jsonObject.has(key = key.toLowerCase())) {
            return null;
        }
        return jsonObject.get(key).getAsString();
    }
}

