/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.UmbaskaCord;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import net.md_5.bungee.api.Favicon;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;
import uk.co.umbaska.UmbaskaCord.ClientListener;
import uk.co.umbaska.UmbaskaCord.ReadAgain;
import uk.co.umbaska.UmbaskaCord.TestCmd;
import uk.co.umbaska.UmbaskaCord.variables.VariableStorageJSON;

public class UmbaskaCord
extends Plugin
implements Listener {
    public static UmbaskaCord umbcord;
    public ServerSocket server;
    public Set<String> c = Collections.synchronizedSet(new HashSet());
    public List<String> oq = Collections.synchronizedList(new ArrayList());
    public Map<String, List<String>> pq = Collections.synchronizedMap(new HashMap());
    public Map<String, Integer> qc = Collections.synchronizedMap(new HashMap());
    public String spacer = "@@UMB@@";
    public String variableStorage;
    public VariableStorageJSON variableStorageJSON;
    public static Boolean debugMode;
    public String version = "1.5";
    public static String motd;
    public static String servericonURL;
    public static String playerList;

    public void onEnable() {
        umbcord = this;
        String[] data = this.loadConfig();
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new TestCmd());
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ReadAgain());
        this.getProxy().registerChannel("UmbaskaCord");
        if (data[3].equals("UNSET")) {
            this.getLogger().info("Oh no! You haven't set a custom Password! Fix plz.");
            return;
        }
        try {
            this.server = new ServerSocket(Integer.parseInt(data[1]), 50, InetAddress.getByName(data[0]));
            this.getLogger().info("ServerSocket opened on " + data[0] + ":" + data[1] + ".");
            new ClientListener(this, Integer.parseInt(data[2]), data[3]).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.variableStorageJSON = new VariableStorageJSON();
        ProxyServer.getInstance().getPluginManager().registerListener((Plugin)this, (Listener)this);
    }

    @EventHandler
    public void onPing(ProxyPingEvent ev) {
        this.getProxy().getLogger().info("ProxyPingEvent fired!");
        ServerPing ping = ev.getResponse();
        if (motd != "") {
            motd = motd.replace("@nl@", "\n");
            ping.setDescription(motd);
        }
        if (playerList != "") {
            playerList = playerList.replaceAll("\\|\\|", "@nl@");
            ArrayList<ServerPing.PlayerInfo> info = new ArrayList<ServerPing.PlayerInfo>();
            for (String s : playerList.split("@nl@")) {
                info.add(new ServerPing.PlayerInfo(s, ""));
            }
            ServerPing.PlayerInfo[] playerInfos = info.toArray(new ServerPing.PlayerInfo[info.size()]);
            ServerPing.Players players = new ServerPing.Players(ev.getResponse().getPlayers().getMax(), ev.getResponse().getPlayers().getOnline(), playerInfos);
            ping.setPlayers(players);
        }
        if (servericonURL != "") {
            Favicon favicon = null;
            try {
                favicon = Favicon.create((BufferedImage)ImageIO.read(new URL(servericonURL)));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (favicon != null) {
                ping.setFavicon(favicon);
            }
        }
        ev.setResponse(ping);
    }

    public void onDisable() {
        this.saveData();
        this.variableStorageJSON.close();
    }

    private String[] loadConfig() {
        String[] defaults = new String[]{"ip=localhost", "port=9190", "heartbeat=1000", "pass=UNSET", "debug=false", "variablestorage=variables"};
        String[] data = new String[defaults.length];
        try {
            File file;
            File folder = this.getDataFolder();
            if (!folder.exists()) {
                folder.mkdir();
            }
            if (!(file = new File(folder, "config.txt")).exists()) {
                file.createNewFile();
            }
            BufferedReader br = new BufferedReader(new FileReader(file));
            for (int i = 0; i < defaults.length; ++i) {
                String l = br.readLine();
                if (l == null || l.isEmpty()) {
                    data[i] = defaults[i].split("=")[1];
                    continue;
                }
                data[i] = l.split("=")[1];
                defaults[i] = l;
            }
            br.close();
            file.delete();
            file.createNewFile();
            PrintStream ps = new PrintStream(new FileOutputStream(file));
            for (int i = 0; i < defaults.length; ++i) {
                ps.println(defaults[i]);
            }
            ps.close();
            this.variableStorage = data[5];
            this.getLogger().info("Configuration file loaded.");
            debugMode = Boolean.getBoolean(data[4]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    private void saveData() {
        try {
            FileOutputStream os = new FileOutputStream(new File(this.getDataFolder(), "config.yml"));
            PrintStream ps = new PrintStream(os);
            for (String string : this.oq) {
                ps.println("oq:" + string);
            }
            for (Map.Entry entry : this.pq.entrySet()) {
                String name = (String)entry.getKey();
                for (String command : (List)entry.getValue()) {
                    ps.println("pq:" + name + this.spacer + command);
                }
            }
            for (Map.Entry entry : this.qc.entrySet()) {
                ps.println("qc:" + (String)entry.getKey() + this.spacer + String.valueOf(entry.getValue()));
            }
            ps.close();
            this.getLogger().info("All data saved.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadData() {
        block14: {
            try {
                File file = new File(this.getDataFolder(), "config.yml");
                if (file.exists()) {
                    try (BufferedReader br = new BufferedReader(new FileReader(file));){
                        String l = br.readLine();
                        while (l != null) {
                            String[] parts;
                            if (l.startsWith("oq:")) {
                                this.oq.add(new String(l.substring(3)));
                            } else if (l.startsWith("pq:")) {
                                List<String> commands;
                                parts = new String(l.substring(3)).split(this.spacer);
                                if (this.pq.containsKey(parts[0])) {
                                    commands = this.pq.get(parts[0]);
                                    commands.add(parts[1]);
                                    this.pq.put(parts[0], commands);
                                } else {
                                    commands = new ArrayList<String>(Arrays.asList(parts[1]));
                                    this.pq.put(parts[0], commands);
                                }
                            } else if (l.startsWith("qc:")) {
                                parts = new String(l.substring(3)).split(this.spacer);
                                this.qc.put(parts[0], Integer.parseInt(parts[1]));
                            }
                            l = br.readLine();
                        }
                        this.getLogger().info("All data loaded.");
                        break block14;
                    }
                }
                this.getLogger().info("A data file was not found. If this is your first start-up with the plugin, this is normal.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        debugMode = true;
        motd = "";
        servericonURL = "";
        playerList = "";
    }
}

