/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.utils;

import ch.njol.skript.ScriptLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang3.StringUtils;
import uk.co.umbaska.Umbaska;

public class TempScriptUtil {
    private static File tempDir;
    private static int lastId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadScriptFromLines(String[] lines) {
        try {
            File script;
            if (tempDir == null || !tempDir.exists() || !tempDir.isDirectory()) {
                TempScriptUtil.prepareTempDir();
            }
            if (!(script = new File(tempDir, lastId + "-" + System.currentTimeMillis() + ".sk")).createNewFile()) {
                return;
            }
            PrintStream out = new PrintStream(new FileOutputStream(script));
            out.print(StringUtils.join((Object[])lines, (char)'\n'));
            ScriptLoader.loadScripts((File[])new File[]{script});
            Umbaska.info("Loaded a temp script: " + script.getAbsolutePath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            ++lastId;
        }
    }

    public static void prepareTempDir() throws Exception {
        tempDir = new File(Umbaska.get().getDataFolder(), "temp-scripts");
        if (tempDir.exists()) {
            if (!tempDir.isDirectory()) {
                return;
            }
            tempDir.delete();
        }
        if (!tempDir.mkdirs()) {
            throw new IOException("Failed to create the directory for temp scripts");
        }
        tempDir.deleteOnExit();
    }

    static {
        lastId = 0;
    }
}

