/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.registration;

import org.apache.commons.lang.StringUtils;
import uk.co.umbaska.registration.annotations.Name;

public enum SkriptElementType {
    PROPERTY_CONDITION,
    CONDITION,
    EFFECT,
    SIMPLE_OR_OTHER_EXPRESSION,
    PROPERTY_EXPRESSION,
    SIMPLE_PROPERTY_EXPRESSION,
    TYPE,
    EVENT;


    public String toString() {
        switch (this) {
            case PROPERTY_CONDITION: {
                return "property condition";
            }
            case CONDITION: {
                return "condition";
            }
            case EFFECT: {
                return "effect";
            }
            case SIMPLE_OR_OTHER_EXPRESSION: {
                return "expression";
            }
            case PROPERTY_EXPRESSION: {
                return "property expression";
            }
            case SIMPLE_PROPERTY_EXPRESSION: {
                return "simple property expression";
            }
            case TYPE: {
                return "type";
            }
            case EVENT: {
                return "event";
            }
        }
        return "unknown syntax element";
    }

    public String getElementTypeSingleName() {
        if (StringUtils.containsIgnoreCase((String)this.name(), (String)"expression")) {
            return "expression";
        }
        return this.name().toLowerCase();
    }

    public String getElementTypePluralName() {
        return this.getElementTypeSingleName() + "s";
    }

    public String getName(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Name name = ((Object)((Object)this)).getClass().getAnnotation(Name.class);
        if (name == null || name.value().isEmpty()) {
            return this.toString() + " at " + clazz.getCanonicalName();
        }
        return name.value();
    }
}

