/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.commands;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import uk.co.umbaska.Umbaska;
import uk.co.umbaska.modules.ModuleManager;
import uk.co.umbaska.modules.UmbaskaModule;
import uk.co.umbaska.utils.ModuleUtil;

public class ModuleCommand {
    public static Boolean command(CommandSender sender, Command command, String alias, String[] args) {
        String[] subargs = Arrays.copyOfRange(args, 1, args.length);
        String[] help = Umbaska.get().color("&l&3Umbaska Modules", "&eModules add syntax and functionality to Umbaska 3", "&a/umbaska modules find [page|name]&aList Umbaska 3 Modules", "&a/umbaska modules info <id|name>&c WIP", "&a/umbaska modules install <name>");
        if (subargs.length == 0) {
            sender.sendMessage(help);
        } else {
            switch (subargs[0]) {
                case "find": {
                    List<ModuleUtil.Module> modules = ModuleUtil.getAllAvailableModules();
                    if (subargs.length == 1 || NumberUtils.isNumber((String)subargs[1])) {
                        Integer page = 1;
                        if (subargs.length > 1) {
                            page = Integer.parseInt(subargs[1]);
                        }
                        List modulesPartitioned = Lists.partition(modules, (int)10);
                        sender.sendMessage(Umbaska.get().color("&aUmbaska Modules (" + page + "/" + modulesPartitioned.size()) + ")");
                        for (ModuleUtil.Module module : (List)modulesPartitioned.get(page - 1)) {
                            Boolean installed = false;
                            for (UmbaskaModule umbaskaModule : ModuleManager.getEnabledModules()) {
                                if (!umbaskaModule.getModuleInfo().getName().equals(module.getName())) continue;
                                installed = true;
                                break;
                            }
                            sender.sendMessage(Umbaska.get().color("&6- &a" + module.getName() + (installed != false ? " &5(installed)" : "")));
                        }
                    } else {
                        for (ModuleUtil.Module module : modules) {
                            Boolean installed = false;
                            for (UmbaskaModule umbaskaModule : ModuleManager.getEnabledModules()) {
                                if (!umbaskaModule.getModuleInfo().getName().equals(module.getName())) continue;
                                installed = true;
                                break;
                            }
                            if (!module.getName().toLowerCase().contains(subargs[1].toLowerCase())) continue;
                            sender.sendMessage(Umbaska.get().color("&6- &a" + module.getName() + (installed != false ? " &5(installed)" : "")));
                        }
                    }
                    break;
                }
                case "info": {
                    sender.sendMessage("info");
                    break;
                }
                case "install": {
                    if (subargs.length < 2) {
                        sender.sendMessage(help);
                    }
                    for (ModuleUtil.Module module : ModuleUtil.getAllAvailableModules()) {
                        if (!module.getName().equals(subargs[1])) continue;
                        ModuleUtil.installModule(subargs[1]);
                        sender.sendMessage("Successfully installed the module!");
                        return true;
                    }
                    sender.sendMessage("Module not found!");
                    break;
                }
                default: {
                    sender.sendMessage(help);
                }
            }
        }
        return true;
    }
}

