/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.registration;

import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import uk.co.umbaska.Umbaska;
import uk.co.umbaska.registration.annotations.AtLeast;

public enum Version {
    V1_6_R1,
    V1_6_R2,
    V1_7_R1,
    V1_7_R2,
    V1_7_R3,
    V1_8_R1,
    V1_8_R3,
    V1_9_R1,
    V1_9_R2,
    V1_10_R1,
    V1_10_R2,
    V1_10_R3,
    V1_11_R1,
    V1_11_R2,
    V1_11_R3,
    V1_12_R1,
    V1_12_R2,
    V1_12_R3;

    public static Version serverVersion;

    public String toString() {
        return this.name().toLowerCase();
    }

    public static Version parse(String toParse) {
        for (Version version : Version.values()) {
            if (!StringUtils.containsIgnoreCase((CharSequence)version.name(), (CharSequence)toParse)) continue;
            return version;
        }
        return null;
    }

    public int getId() {
        int i = 1;
        for (Version v : Version.values()) {
            if (this == v) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static String getNMSPrefix() {
        return "net.minecraft.server." + Version.getNMSServerVersion() + ".";
    }

    public static String getNMSServerVersion() {
        return "r" + serverVersion.name().substring(1);
    }

    public static boolean isAtLeast(AtLeast atLeast) {
        return atLeast.value().getId() >= serverVersion.getId();
    }

    public static Version getById(int id) {
        for (Version version : Version.values()) {
            if (version.getId() != id) continue;
            return version;
        }
        return null;
    }

    public static void checkServerVersion() {
        String fullVersion = Bukkit.getServer().getClass().getPackage().getName();
        Umbaska.debug(fullVersion.substring(fullVersion.lastIndexOf(46) + 1));
        String versionCode = fullVersion.substring(fullVersion.lastIndexOf(46) + 1);
        serverVersion = Version.parse(versionCode);
    }

    static {
        serverVersion = null;
    }
}

