/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.modules;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.bukkit.configuration.file.YamlConfiguration;
import uk.co.umbaska.Umbaska;
import uk.co.umbaska.UmbaskaConfig;
import uk.co.umbaska.modules.ModuleClassLoader;
import uk.co.umbaska.modules.ModuleInfo;
import uk.co.umbaska.modules.UmbaskaModule;
import uk.co.umbaska.utils.ModuleUtil;
import uk.co.umbaska.utils.UmbaskaYamlLoadingException;

public class ModuleManager {
    public static File modulesDir = null;
    private static ArrayList<ModuleInfo> modulesToEnable = new ArrayList(3);
    public static ArrayList<UmbaskaModule> enabledModules = new ArrayList();

    public static boolean prepare() {
        modulesDir = new File(Umbaska.get().getDataFolder(), "modules");
        if (!modulesDir.exists()) {
            Umbaska.info("Creating directory ", modulesDir.getAbsolutePath());
            if (!modulesDir.mkdir()) {
                Umbaska.fail("Could not create the directory. Aborted loading modules");
                return false;
            }
        }
        return true;
    }

    public static void loadAndEnableModules() {
        ModuleManager.loadModules();
        ModuleManager.enableModules();
    }

    private static void loadModules() {
        File[] files = modulesDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            Umbaska.moduleManagerDebug("Checking ", file.getAbsolutePath());
            if (file.isDirectory()) {
                Umbaska.moduleManagerDebug("Ignoring, because it's a directory");
                continue;
            }
            if (!file.getName().endsWith(".jar")) {
                Umbaska.moduleManagerDebug("Ignoring, because it doesn't end with .jar");
                continue;
            }
            ModuleInfo info = ModuleManager.loadModule(file);
            if (info == null) continue;
            modulesToEnable.add(info);
        }
    }

    public static void enableModules() {
        for (ModuleInfo info : modulesToEnable) {
            UmbaskaModule module = ModuleManager.initMainClass(info);
            if (module == null) continue;
            module.enable();
            enabledModules.add(module);
        }
        if (modulesToEnable.size() > 0) {
            Umbaska.moduleManagerInfo("All modules have been enabled and hooked into Skript!");
            modulesToEnable.clear();
        } else {
            Umbaska.moduleManagerInfo("You don't have any modules in the folder of Umbaska, why don't you download one? Try the command /umb modules");
            Boolean installed = false;
            for (UmbaskaModule module : enabledModules) {
                if (!module.getModuleInfo().getName().equals("Core")) continue;
                installed = true;
                break;
            }
            if (!installed.booleanValue()) {
                Umbaska.moduleManagerInfo("WE ARE INSTALLING THE MODULE CORE FOR YOU, HOLD ON!");
                ModuleUtil.installModule("Core");
            }
        }
    }

    public static void disableModules() {
        for (ModuleInfo info : ModuleInfo.moduleInfos) {
            UmbaskaModule module = info.getUmbaskaModule();
            if (module == null || module.isEnabled()) continue;
            module.disable();
        }
    }

    public static UmbaskaModule initMainClass(ModuleInfo info) {
        UmbaskaModule moduleMain;
        Class<?> cla;
        Umbaska.moduleManagerInfo("Enabling module ", info.getName(), " v", info.getVersion(), " (", info.getVersionInteger(), ")");
        try {
            cla = info.getClassLoader().loadClass(info.getMainClassPath());
        }
        catch (ClassNotFoundException ex) {
            Umbaska.moduleManagerError("Could not load the main class of " + info.getName() + " - didn't find it");
            ex.printStackTrace();
            return null;
        }
        try {
            moduleMain = (UmbaskaModule)cla.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (ClassCastException ex) {
            Umbaska.moduleManagerError("The main class of ", info.getName(), " specified in its module.yml doesn't extend uk.co.umbaska.modules.UmbaskaModule");
            ex.printStackTrace();
            return null;
        }
        moduleMain.setModuleInfo(info);
        return moduleMain;
    }

    public static File downloadModuleFromUrl(String url) {
        try {
            File tempFile = File.createTempFile("umbaska-module", ".jar");
            FileUtils.copyURLToFile((URL)new URL(url), (File)tempFile);
            return tempFile;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static ModuleClassLoader getModuleClassLoader(File moduleFile) {
        URL url = null;
        String moduleFilePath = moduleFile.getAbsolutePath();
        moduleFilePath = moduleFilePath.replace(" ", "%20");
        try {
            url = new URL("jar:file:" + moduleFilePath + "!/");
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
            return null;
        }
        ModuleClassLoader cl = new ModuleClassLoader(((URLClassLoader)ModuleManager.class.getClassLoader()).getURLs(), ModuleManager.class.getClassLoader());
        cl.addURL(url);
        return cl;
    }

    public static ModuleInfo loadModule(File moduleFile) {
        YamlConfiguration moduleYml;
        try {
            moduleYml = UmbaskaConfig.loadConfigFromJar(moduleFile, "module.yml");
        }
        catch (UmbaskaYamlLoadingException e) {
            e.printStackTrace();
            return null;
        }
        if (moduleYml == null) {
            return null;
        }
        String name = moduleYml.getString("name");
        String mainClassPath = moduleYml.getString("main");
        String basePackage = moduleYml.getString("base-package");
        String version = moduleYml.getString("version");
        int versionInteger = moduleYml.getInt("version-integer");
        int minUmbaskaBuildNumber = moduleYml.getInt("min-umbaska-build-number");
        int minMajorJavaVersion = moduleYml.getInt("min-major-java-version");
        String loadOn = moduleYml.getString("loadOn", "start");
        if (minUmbaskaBuildNumber > 7) {
            Umbaska.moduleManagerWarning("The module ", name, " v", version, " (", versionInteger, ") requires the latest version of Umbaska to work properly. (current Umbaska.VERSION_INTEGER: ", 7, "; required at least: ", minUmbaskaBuildNumber, ")");
            return null;
        }
        Umbaska.moduleManagerInfo("Loading module ", name, " v", version, " (", versionInteger, ")");
        ModuleClassLoader loader = ModuleManager.getModuleClassLoader(moduleFile);
        ModuleManager.loadClasses(moduleFile, basePackage, loader);
        ModuleInfo info = ModuleInfo.getModuleInfoFor(moduleFile, basePackage, name, version, versionInteger, mainClassPath, minUmbaskaBuildNumber, minMajorJavaVersion, loader, loadOn);
        if (info == null) {
            Umbaska.error("Could not load the details of module at ", moduleFile.getAbsolutePath());
        }
        return info;
    }

    public static boolean loadClasses(File moduleFile, String basePackage, ModuleClassLoader loader) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(moduleFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (jarFile == null) {
            return false;
        }
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry je = e.nextElement();
            if (je.isDirectory() || !je.getName().endsWith(".class")) continue;
            String className = je.getName().substring(0, je.getName().length() - 6);
            className = className.replace('/', '.');
            try {
                if (!className.startsWith(basePackage)) continue;
                loader.loadClass(className);
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
                return false;
            }
            catch (NullPointerException e2) {
                Umbaska.fail("Did you just /reload? Not supported!");
                e2.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static ArrayList<UmbaskaModule> getEnabledModules() {
        return enabledModules;
    }
}

