/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska;

import ch.njol.skript.Skript;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import uk.co.umbaska.Umbaska;
import uk.co.umbaska.commands.ExportCommand;
import uk.co.umbaska.commands.ModuleCommand;

class UmbaskaCommandHandler
implements CommandExecutor {
    UmbaskaCommandHandler() {
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        UmbaskaCommand umbaskaCommand = UmbaskaCommand.parse(command);
        if (umbaskaCommand == null) {
            throw new IllegalArgumentException("The parsed UmbaskaCommand is null, used alias was: " + alias);
        }
        switch (umbaskaCommand) {
            case EXECUTE_SKRIPT_COMMAND: {
                if (this.validate(sender, "umbaska.command.skc")) {
                    String toExecute = "";
                    for (String arg : args) {
                        toExecute = toExecute + " " + arg;
                    }
                    if (toExecute.length() > 0) {
                        toExecute = toExecute.substring(1);
                    }
                    Skript.dispatchCommand((CommandSender)sender, (String)toExecute);
                }
                return true;
            }
            case UMBASKA: {
                UmbaskaSubCommand sub = UmbaskaSubCommand.parse(args);
                switch (sub) {
                    case HELP: {
                        sender.sendMessage(Umbaska.get().color("&l&3UMBASKA 3 -- &eCOMMANDS", "&a/umbaska help&c Get help", "&a/umbaska module[s]&c Get help about modules", "&a/umbaska info&c Get info about Umbaska"));
                        return true;
                    }
                    case MODULE: {
                        return ModuleCommand.command(sender, command, alias, args);
                    }
                    case INFO: {
                        sender.sendMessage(Umbaska.get().color("&l&3UMBASKA 3 -- &eINFO", "&eVersion: &a" + Umbaska.get().getDescription().getVersion(), "&a/umbaska help"));
                        return true;
                    }
                    case EXPORT: {
                        return ExportCommand.command(sender, command, alias, args);
                    }
                }
            }
        }
        return false;
    }

    private boolean validate(CommandSender sender, String permission, OnlyFor only) {
        if (only == OnlyFor.PLAYERS) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("This command can be executed only by players");
                return false;
            }
        } else if (only == OnlyFor.CONSOLE) {
            if (!(sender instanceof ConsoleCommandSender)) {
                sender.sendMessage("This command can be executed only from the console");
            }
        } else if (!(only != OnlyFor.CONSOLE_AND_BLOCKS || sender instanceof ConsoleCommandSender && sender instanceof BlockCommandSender)) {
            sender.sendMessage("This command can be executed only from the console and command blocks");
        }
        if (!(sender instanceof Player)) {
            return true;
        }
        if (sender.hasPermission(permission)) {
            return true;
        }
        sender.sendMessage("You are lacking the permission " + permission);
        return false;
    }

    private boolean validate(CommandSender sender, String permission) {
        return this.validate(sender, permission, OnlyFor.PLAYERS_AND_CONSOLE_AND_BLOCKS);
    }

    private static enum UmbaskaSubCommand {
        HELP,
        INFO,
        MODULE,
        EXPORT;


        public static UmbaskaSubCommand parse(String[] args) {
            if (args.length <= 0 || args[0].equalsIgnoreCase("info") || args[0].equalsIgnoreCase("i") || args[0].equalsIgnoreCase("about")) {
                return INFO;
            }
            if (args.length >= 1 && (args[0].equalsIgnoreCase("module") || args[0].equalsIgnoreCase("mod"))) {
                return MODULE;
            }
            if (args.length >= 1 && (args[0].equalsIgnoreCase("export") || args[0].equalsIgnoreCase("exp"))) {
                return EXPORT;
            }
            return HELP;
        }
    }

    private static enum UmbaskaCommand {
        UMBASKA,
        EXECUTE_SKRIPT_COMMAND;


        public static UmbaskaCommand parse(Command command) {
            if (command.getName().equals("executeskriptcommand")) {
                return EXECUTE_SKRIPT_COMMAND;
            }
            if (command.getName().equals("umbaska")) {
                return UMBASKA;
            }
            return null;
        }
    }

    private static enum OnlyFor {
        PLAYERS,
        CONSOLE,
        CONSOLE_AND_BLOCKS,
        PLAYERS_AND_CONSOLE_AND_BLOCKS;

    }
}

