/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import uk.co.umbaska.Umbaska;
import uk.co.umbaska.modules.ModuleInfo;
import uk.co.umbaska.modules.ModuleManager;
import uk.co.umbaska.modules.UmbaskaModule;

public class ModuleUtil {
    public static List<Module> getAllAvailableModules() {
        String rawJSON = null;
        try {
            URLConnection conn = null;
            InputStream inputStream = null;
            URL url = new URL("http://skriptrepo.com/modulejson");
            conn = url.openConnection();
            HttpURLConnection httpConn = (HttpURLConnection)conn;
            httpConn.setRequestMethod("GET");
            httpConn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36");
            httpConn.connect();
            if (httpConn.getResponseCode() == 200) {
                inputStream = httpConn.getInputStream();
            }
            rawJSON = IOUtils.toString(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<Module> modules = new ArrayList<Module>();
        JSONObject json = new JSONObject(rawJSON);
        Iterator<String> it = json.getJSONObject("modules").keys();
        while (it.hasNext()) {
            String id = it.next();
            JSONObject module = json.getJSONObject("modules").getJSONObject(id);
            modules.add(new Module(Integer.parseInt(id), module.getString("name"), module.getString("authors"), module.getString("version"), module.getString("umbversion"), module.getJSONObject("mcversions").getInt("max"), module.getJSONObject("mcversions").getInt("min"), module.getString("download")));
        }
        return modules;
    }

    public static void installModule(String name) {
        for (Module module : ModuleUtil.getAllAvailableModules()) {
            if (!module.getName().equals(name)) continue;
            String urlString = module.getDownload();
            try {
                URL url = new URL(urlString);
                URLConnection conn = null;
                InputStream inputStream = null;
                conn = url.openConnection();
                HttpURLConnection httpConn = (HttpURLConnection)conn;
                httpConn.setRequestMethod("GET");
                httpConn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36");
                httpConn.connect();
                if (httpConn.getResponseCode() == 200) {
                    inputStream = httpConn.getInputStream();
                }
                File target = new File(Umbaska.get().getDataFolder().getAbsolutePath() + "/modules/" + module.getName() + ".jar");
                Files.copy(inputStream, target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                inputStream.close();
                ModuleInfo moduleInfo = ModuleManager.loadModule(target);
                UmbaskaModule umodule = ModuleManager.initMainClass(moduleInfo);
                umodule.enable();
                ModuleManager.enabledModules.add(umodule);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class Module {
        int id;
        int maxMCVersion;
        int leastMCVersion;
        String name;
        String authors;
        String version;
        String umbaskaVersion;
        String download;

        public Module(int id, String name, String authors, String version, String umbaskaVersion, int maxMCVersion, int leastMCVersion, String download) {
            this.id = id;
            this.name = name;
            this.authors = authors;
            this.version = version;
            this.umbaskaVersion = umbaskaVersion;
            this.maxMCVersion = maxMCVersion;
            this.leastMCVersion = leastMCVersion;
            this.download = download;
        }

        public String getDownload() {
            return this.download;
        }

        public void setDownload(String download) {
            this.download = download;
        }

        public int getId() {
            return this.id;
        }

        public int getMaxMCVersion() {
            return this.maxMCVersion;
        }

        public void setMaxMCVersion(int maxMCVersion) {
            this.maxMCVersion = maxMCVersion;
        }

        public int getLeastMCVersion() {
            return this.leastMCVersion;
        }

        public void setLeastMCVersion(int leastMCVersion) {
            this.leastMCVersion = leastMCVersion;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAuthors() {
            return this.authors;
        }

        public void setAuthors(String authors) {
            this.authors = authors;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getUmbaskaVersion() {
            return this.umbaskaVersion;
        }

        public void setUmbaskaVersion(String umbaskaVersion) {
            this.umbaskaVersion = umbaskaVersion;
        }
    }
}

