/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.registration;

import ch.njol.skript.Skript;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.registrations.Classes;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.co.umbaska.Umbaska;
import uk.co.umbaska.UmbaskaConfig;
import uk.co.umbaska.modules.ModuleInfo;
import uk.co.umbaska.registration.SelfRegisteringUmbaskaElement;
import uk.co.umbaska.registration.SkriptElementType;
import uk.co.umbaska.registration.UmbaskaAnnotation;
import uk.co.umbaska.registration.UmbaskaType;
import uk.co.umbaska.registration.Version;
import uk.co.umbaska.registration.annotations.AtLeast;
import uk.co.umbaska.registration.annotations.BukkitEvent;
import uk.co.umbaska.registration.annotations.DisplaySyntaxes;
import uk.co.umbaska.registration.annotations.DoesNotSupportBensku;
import uk.co.umbaska.registration.annotations.DontRegister;
import uk.co.umbaska.registration.annotations.DynamicSyntaxes;
import uk.co.umbaska.registration.annotations.ExpressionsType;
import uk.co.umbaska.registration.annotations.Name;
import uk.co.umbaska.registration.annotations.PropertyConditionType;
import uk.co.umbaska.registration.annotations.PropertyExpressionType;
import uk.co.umbaska.registration.annotations.RequiredPlugins;
import uk.co.umbaska.registration.annotations.Syntaxes;

public class Register {
    private static PluginManager pluginManager = Bukkit.getPluginManager();
    private static Plugin plugin;
    private static HashMap<Class<? extends Annotation>, UmbaskaAnnotation> customAnnotations;
    private static JSONObject currentJsonDocs;
    public static HashMap<ModuleInfo, JSONObject> moduleJsonDocsMap;
    public static String emptyDocsPattern;
    public static String currentNode;

    public static void registerAnnotations() {
        Register.registerCustomAnnotation(DoesNotSupportBensku.class, new UmbaskaAnnotation(){

            @Override
            public boolean shouldBeRegistered(Class<?> clazz) {
                for (String author : Skript.getInstance().getDescription().getAuthors()) {
                    if (!author.equals("bensku")) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public static void registerCustomAnnotation(Class<? extends Annotation> annotation, UmbaskaAnnotation logic) {
        customAnnotations.put(annotation, logic);
    }

    public static void registerEverythingFrom(String pckg, @Nonnull ModuleInfo moduleInfo) {
        currentJsonDocs = moduleJsonDocsMap.get(moduleInfo);
        if (currentJsonDocs == null) {
            currentJsonDocs = new JSONObject(emptyDocsPattern);
            moduleJsonDocsMap.put(moduleInfo, currentJsonDocs);
        }
        if (!Register.setLateRegister(true)) {
            return;
        }
        try {
            ClassLoader clazzLoader = moduleInfo.getClassLoader();
            Class<?> clazz = clazzLoader.getClass().getSuperclass().getSuperclass().getSuperclass();
            Field f = clazz.getDeclaredField("classes");
            f.setAccessible(true);
            Vector classes = (Vector)((Vector)f.get(clazzLoader)).clone();
            ArrayList<Class> elements = new ArrayList<Class>(200);
            for (Class cla : classes) {
                if (!SelfRegisteringUmbaskaElement.class.isAssignableFrom(cla)) continue;
                elements.add(cla);
            }
            Umbaska.debug("Found ", elements.size(), " elements to register out of ", classes.size(), " classes in package ", pckg);
            for (Class cla : elements) {
                Register.registerElement(cla);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            ex.printStackTrace();
        }
        Register.setLateRegister(false);
    }

    public static <T> void registerElement(Class<? extends SelfRegisteringUmbaskaElement> clazz) {
        Umbaska.debug("Checking " + clazz.getCanonicalName());
        if (UmbaskaType.class.isAssignableFrom(clazz)) {
            Register.type(clazz);
        } else if (SimplePropertyExpression.class.isAssignableFrom(clazz)) {
            Register.simplePropertyExpression(clazz);
        } else if (Effect.class.isAssignableFrom(clazz)) {
            Register.effect(clazz);
        } else if (PropertyCondition.class.isAssignableFrom(clazz)) {
            Register.propertyCondition(clazz);
        } else if (Condition.class.isAssignableFrom(clazz)) {
            Register.condition(clazz);
        } else if (PropertyExpression.class.isAssignableFrom(clazz)) {
            Register.propertyExpression(clazz);
        } else if (Expression.class.isAssignableFrom(clazz)) {
            Register.expression(clazz);
        } else if (SkriptEvent.class.isAssignableFrom(clazz)) {
            Register.event(clazz);
        }
    }

    private static void type(Class<? extends UmbaskaType> clazz) {
        RequiredPlugins dependency = clazz.getAnnotation(RequiredPlugins.class);
        DontRegister dontRegister = clazz.getAnnotation(DontRegister.class);
        if (dontRegister != null) {
            return;
        }
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (dependency != null) {
            for (String pluginName : dependency.value()) {
                if (pluginManager.getPlugin(pluginName) != null) continue;
                Umbaska.debug(clazz, "The dependency ", pluginName, " cannot be resolved, so I'm not going to register this type");
                return;
            }
        }
        try {
            Classes.registerClass(clazz.newInstance().getClassInfo());
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    private static void condition(Class<? extends Condition> clazz) {
        String[] syntaxes = Register.validateAndGenerateDocs(SkriptElementType.CONDITION, clazz);
        if (syntaxes == null) {
            return;
        }
        Skript.registerCondition(clazz, (String[])syntaxes);
    }

    private static void propertyCondition(Class<? extends Condition> clazz) {
        PropertyConditionType type = clazz.getAnnotation(PropertyConditionType.class);
        String[] syntaxes = Register.validateAndGenerateDocs(SkriptElementType.PROPERTY_CONDITION, clazz);
        if (syntaxes == null) {
            return;
        }
        if (type == null) {
            Umbaska.fail(UmbaskaConfig.debug ? null : type, "Couldn't register this PropertyCondition because the type is null");
            return;
        }
        PropertyCondition.register(clazz, (String)syntaxes[0], (String)type.value()[0]);
    }

    private static void effect(Class<? extends Effect> clazz) {
        String[] syntaxes = Register.validateAndGenerateDocs(SkriptElementType.EFFECT, clazz);
        if (syntaxes == null) {
            return;
        }
        Skript.registerEffect(clazz, (String[])syntaxes);
    }

    private static void expression(Class<? extends Expression> clazz) {
        ExpressionsType type = clazz.getAnnotation(ExpressionsType.class);
        String[] syntaxes = Register.validateAndGenerateDocs(SkriptElementType.SIMPLE_OR_OTHER_EXPRESSION, clazz);
        if (syntaxes == null) {
            return;
        }
        Class returnClazz = Register.getExpressionReturnType(clazz);
        if (returnClazz == null) {
            Umbaska.fail(UmbaskaConfig.debug ? null : clazz, "Couldn't register this Expression because the returnClazz is null");
            return;
        }
        if (type == null) {
            Skript.registerExpression(clazz, (Class)returnClazz, (ExpressionType)ExpressionType.SIMPLE, (String[])syntaxes);
        } else {
            Skript.registerExpression(clazz, (Class)returnClazz, (ExpressionType)type.type(), (String[])syntaxes);
        }
    }

    private static void event(Class<? extends SkriptEvent> clazz) {
        String name;
        String[] syntaxes = Register.validateAndGenerateDocs(SkriptElementType.EVENT, clazz);
        if (syntaxes == null) {
            return;
        }
        Name nameAnnotation = clazz.getAnnotation(Name.class);
        String string = name = nameAnnotation == null ? "" : nameAnnotation.value();
        if (!clazz.isAnnotationPresent(BukkitEvent.class)) {
            Umbaska.fail("Couldn't register this Event because the annotation " + BukkitEvent.class.getCanonicalName() + " is not present");
            return;
        }
        Class<? extends Event> bukkitEvent = clazz.getAnnotation(BukkitEvent.class).value();
        Skript.registerEvent((String)name, clazz, bukkitEvent, (String[])syntaxes);
    }

    private static <T> void simplePropertyExpression(Class<? extends Expression<T>> clazz) {
        PropertyExpressionType type = clazz.getAnnotation(PropertyExpressionType.class);
        String[] syntaxes = Register.validateAndGenerateDocs(SkriptElementType.SIMPLE_PROPERTY_EXPRESSION, clazz);
        if (syntaxes == null) {
            return;
        }
        Class returnClazz = Register.getExpressionReturnType(clazz);
        if (returnClazz == null) {
            Umbaska.fail(UmbaskaConfig.debug ? null : clazz, "Couldn't register this SimplePropertyExpression because the returnClazz is null");
            return;
        }
        if (type == null) {
            Umbaska.fail(UmbaskaConfig.debug ? null : type, "Couldn't register this SimplePropertyExpression because the type is null");
            return;
        }
        for (int i = 0; i < syntaxes.length; ++i) {
            SimplePropertyExpression.register(clazz, (Class)returnClazz, (String)syntaxes[i], (String)type.value()[0]);
        }
    }

    private static void propertyExpression(Class<? extends PropertyExpression> clazz) {
        String[] syntaxes = Register.validateAndGenerateDocs(SkriptElementType.PROPERTY_EXPRESSION, clazz);
        if (syntaxes == null) {
            return;
        }
        Class returnClazz = Register.getExpressionReturnType(clazz);
        if (returnClazz == null) {
            Umbaska.fail(UmbaskaConfig.debug ? null : clazz, "Couldn't register this PropertyExpression because the returnClazz is null");
            return;
        }
        Skript.registerExpression(clazz, (Class)returnClazz, (ExpressionType)ExpressionType.PROPERTY, (String[])syntaxes);
    }

    private static String[] validateAndGenerateDocs(SkriptElementType element, Class<?> clazz) {
        Integer result = Register.validateAndGenerateDocsInner(element, clazz);
        Syntaxes syntaxes = clazz.getAnnotation(Syntaxes.class);
        DisplaySyntaxes displaySyntaxes = null;
        if (clazz.isAnnotationPresent(DisplaySyntaxes.class)) {
            displaySyntaxes = clazz.getAnnotation(DisplaySyntaxes.class);
        }
        if (UmbaskaConfig.generateDocs && (result == 0 || result == 1)) {
            Name name = clazz.getAnnotation(Name.class);
            if (name == null || name.value().isEmpty()) {
                Umbaska.logDocsGenerator(UmbaskaConfig.debug ? null : clazz, "WARNING > The Name annotation of this ", element.toString(), " is ", name == null ? "not set" : "empty", ", so it won't be added to the documentation");
            } else {
                JSONArray array = currentJsonDocs.getJSONArray(element.getElementTypePluralName());
                JSONObject elementJson = new JSONObject();
                elementJson.put("name", name.value());
                JSONArray syntaxesJson = new JSONArray();
                if (displaySyntaxes == null) {
                    for (String syntax : syntaxes.value()) {
                        syntaxesJson.put(syntax);
                    }
                } else {
                    for (String syntax : displaySyntaxes.value()) {
                        syntaxesJson.put(syntax);
                    }
                }
                elementJson.put("syntaxes", syntaxesJson);
                JSONArray reqPlugins = new JSONArray();
                RequiredPlugins dependency = clazz.getAnnotation(RequiredPlugins.class);
                if (dependency != null) {
                    for (String plugin : dependency.value()) {
                        reqPlugins.put(plugin);
                    }
                }
                elementJson.put("req-plugins", reqPlugins);
                array.put(elementJson);
            }
        }
        if (result == 0) {
            String[] syntaxArray = null;
            int i = 0;
            if (syntaxes != null) {
                syntaxArray = new String[syntaxes.value().length];
                for (String syntax : syntaxes.value()) {
                    syntaxArray[i] = "[umb[aska]] " + (String)syntax;
                    ++i;
                }
            } else if (DynamicSyntaxes.class.isAssignableFrom(clazz)) {
                try {
                    String[] noPrefixSyntaxes = ((DynamicSyntaxes)clazz.newInstance()).getSyntaxes();
                    syntaxArray = new String[noPrefixSyntaxes.length];
                    for (String syntax : noPrefixSyntaxes) {
                        syntaxArray[i] = "[umb[aska]] " + syntax;
                        ++i;
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return syntaxArray;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Integer validateAndGenerateDocsInner(SkriptElementType element, Class<?> clazz) {
        Name name = clazz.getAnnotation(Name.class);
        Syntaxes syntaxes = clazz.getAnnotation(Syntaxes.class);
        DontRegister dontRegister = clazz.getAnnotation(DontRegister.class);
        RequiredPlugins dependency = clazz.getAnnotation(RequiredPlugins.class);
        AtLeast atLeast = clazz.getAnnotation(AtLeast.class);
        if (dontRegister != null) {
            Umbaska.debug(clazz, "Detected annotation DontRegister. Aborting.");
            return 3;
        }
        for (Map.Entry<Class<? extends Annotation>, UmbaskaAnnotation> entry : customAnnotations.entrySet()) {
            if (!clazz.isAnnotationPresent(entry.getKey()) || entry.getValue().shouldBeRegistered(clazz)) continue;
            Umbaska.debug(clazz, "The annotation ", entry.getValue().getClass().getCanonicalName(), " aborted registering this ", element.toString());
            return 1;
        }
        String clazzName = clazz.getName();
        if (Version.parse(clazzName.substring(clazzName.length() - 8, clazzName.length() - 6)) != null) {
            Umbaska.debug(clazz, "This class is only for one MC version, and should have been already registered before");
            return 1;
        }
        if (atLeast != null && !Version.isAtLeast(atLeast)) {
            Umbaska.debug(clazz, new Object[]{"This element requires Minecraft server core version greater than ", atLeast.value(), " while your is ", Version.serverVersion});
            return 1;
        }
        if (dependency != null) {
            for (String pluginName : dependency.value()) {
                plugin = pluginManager.getPlugin(pluginName);
                if (plugin != null) continue;
                Umbaska.debug("The dependency ", pluginName, " cannot be resolved, so I'm not going to register this ", element.toString());
                return 1;
            }
        }
        if (DynamicSyntaxes.class.isAssignableFrom(clazz)) {
            try {
                boolean bl = false;
                for (String syntax : ((DynamicSyntaxes)clazz.newInstance()).getSyntaxes()) {
                    void var8_12;
                    if (++var8_12 <= 0) {
                        Umbaska.debug("Registering a(n) ", element.toString(), " with dynamic syntax: ", syntax);
                        continue;
                    }
                    Umbaska.debug("And: ", syntax);
                }
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
                return 2;
            }
        } else if (syntaxes == null) {
            if (name == null) {
                Umbaska.fail(UmbaskaConfig.debug ? null : clazz, "Couldn't register this ", element.toString(), " because the Syntaxes annotation is null");
            } else {
                Umbaska.fail(UmbaskaConfig.debug ? null : clazz, "Couldn't register this ", element.toString(), " with name ", name.value(), " because the Syntaxes annotation is null");
            }
            return 2;
        }
        boolean bl = false;
        for (String syntax : syntaxes.value()) {
            void var8_15;
            if (var8_15 <= 0) {
                Umbaska.debug("Registering a(n) ", element.toString(), " with syntax: ", syntax);
            } else {
                Umbaska.debug("And: ", syntax);
            }
            ++var8_15;
        }
        return 0;
    }

    private static Class getExpressionReturnType(Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("getReturnType", new Class[0]);
            Object o = clazz.newInstance();
            Object returnType = method.invoke(o, new Object[0]);
            return (Class)returnType;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static boolean setLateRegister(boolean b) {
        if (!Umbaska.wasServerFullyLoaded) {
            return true;
        }
        try {
            Field field = Skript.class.getDeclaredField("acceptRegistrations");
            field.setAccessible(true);
            field.setBoolean((Object)Umbaska.get(), b);
            return true;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Umbaska.fail("Could not force Skript to ", b ? "start" : "stop", "accepting registration of new classes");
            e.printStackTrace();
            return false;
        }
    }

    static {
        customAnnotations = new HashMap(5);
        moduleJsonDocsMap = new HashMap(5);
        emptyDocsPattern = "{\"expressions\":[],\"effects\":[],\"conditions\":[],\"events\":[],\"types\":[]}";
        currentNode = "<nothing>";
    }
}

