/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.modules;

import java.io.File;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import uk.co.umbaska.Umbaska;
import uk.co.umbaska.modules.UmbaskaModule;

public class ModuleInfo {
    public static ArrayList<ModuleInfo> moduleInfos = new ArrayList(5);
    private String name;
    private String mainClassPath;
    private String basePackage;
    private String version;
    private int versionInteger;
    private int minMajorJavaVersion;
    private int minUmbaskaBuildNumber;
    private File moduleFile;
    private ClassLoader classLoader;
    private UmbaskaModule umbaskaModule;

    @Nullable
    public static ModuleInfo getInfoByName(String name) {
        for (ModuleInfo info : moduleInfos) {
            if (!info.getName().equals(name)) continue;
            return info;
        }
        return null;
    }

    public static ModuleInfo getModuleInfoFor(File moduleFile, String basePackage, String name, String version, int versionInteger, String mainClassPath, int minUmbaskaBuildNumber, int minMajorJavaVersion, ClassLoader classLoader) {
        for (ModuleInfo info : moduleInfos) {
            if (info.getModuleFile().getAbsolutePath().equals(moduleFile.getAbsolutePath())) {
                return info;
            }
            if (!info.getName().equals(name)) continue;
            Umbaska.error("Two different modules tried to load with the same name - '", name, "'");
            Umbaska.error("Location of the one which tried to load: ", moduleFile.getAbsolutePath());
            Umbaska.error("Location of the already loaded one: ", info.getModuleFile().getAbsolutePath());
            return null;
        }
        ModuleInfo outInfo = new ModuleInfo(moduleFile, basePackage, name, version, versionInteger, mainClassPath, minUmbaskaBuildNumber, minMajorJavaVersion, classLoader);
        moduleInfos.add(outInfo);
        return outInfo;
    }

    private ModuleInfo(File moduleFile, String basePackage, String name, String version, int versionInteger, String mainClassPath, int minUmbaskaBuildNumber, int minMajorJavaVersion, ClassLoader classLoader) {
        this.moduleFile = moduleFile;
        this.basePackage = basePackage;
        this.name = name;
        this.version = version;
        this.versionInteger = versionInteger;
        this.minUmbaskaBuildNumber = minUmbaskaBuildNumber;
        this.mainClassPath = mainClassPath;
        this.minMajorJavaVersion = minMajorJavaVersion;
        this.classLoader = classLoader;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public int getVersionInteger() {
        return this.versionInteger;
    }

    public UmbaskaModule getUmbaskaModule() {
        return this.umbaskaModule;
    }

    public int getMinUmbaskaBuildNumber() {
        return this.minUmbaskaBuildNumber;
    }

    public String getMainClassPath() {
        return this.mainClassPath;
    }

    public File getModuleFile() {
        return this.moduleFile;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public int getMinMajorJavaVersion() {
        return this.minMajorJavaVersion;
    }

    public void setUmbaskaModule(@Nonnull UmbaskaModule umbaskaModule) {
        this.umbaskaModule = umbaskaModule;
    }
}

