/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.logs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class LogUtil {
    public boolean wasPrepared = false;
    private FileWriter fileWriter;
    private BufferedWriter bufferedWriter;
    private PrintWriter printWriter;
    private File logFile;
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");

    public LogUtil(File logFile) {
        this.logFile = logFile;
    }

    public void log(String toLog) {
        if (!this.shouldWorkFine()) {
            this.prepare();
            if (!this.shouldWorkFine()) {
                return;
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        builder.append(this.simpleDateFormat.format(Calendar.getInstance().getTime()));
        builder.append("] ");
        builder.append(toLog.substring(10));
        this.printWriter.println(builder.toString());
    }

    public boolean shouldWorkFine() {
        if (!this.wasPrepared) {
            return false;
        }
        return this.printWriter != null;
    }

    public void prepare() {
        try {
            if (!this.logFile.exists()) {
                this.logFile.getParentFile().mkdirs();
                this.logFile.createNewFile();
            }
            this.fileWriter = new FileWriter(this.logFile);
            this.bufferedWriter = new BufferedWriter(this.fileWriter);
            this.printWriter = new PrintWriter(this.bufferedWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.wasPrepared = true;
    }

    public void close() {
        this.wasPrepared = false;
        this.printWriter.close();
        try {
            this.fileWriter.close();
            this.bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void flush() {
        try {
            this.bufferedWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

