/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import uk.co.umbaska.Umbaska;
import uk.co.umbaska.utils.UmbaskaYamlLoadingException;

public class UmbaskaConfig {
    private static File mainConfigFile;
    private static YamlConfiguration mainConfig;
    public static boolean debug;
    public static boolean moduleManagerDebug;
    public static boolean generateDocs;
    public static boolean activeDevelopmentMode;
    public static String activeDevelopmentCommand;
    private static final int CURRENT_CONFIG_VERSION = 6;

    static boolean loadMainConfig() throws UmbaskaYamlLoadingException {
        mainConfigFile = new File(Umbaska.get().getDataFolder(), "config.yml");
        mainConfig = UmbaskaConfig.getConfig(Umbaska.umbaskaJarFile, mainConfigFile, "config.yml", 6, true, true);
        if (mainConfig == null) {
            Umbaska.error("Could not load the main config of Umbaska");
            return false;
        }
        moduleManagerDebug = mainConfig.getBoolean("module-manager-debug-mode");
        generateDocs = mainConfig.getBoolean("generate-docs");
        activeDevelopmentMode = mainConfig.getBoolean("active-development-mode.enabled");
        activeDevelopmentCommand = mainConfig.getString("active-development-mode.command");
        return true;
    }

    public static YamlConfiguration loadConfigFromJar(File jarWithConfig, String configPath) throws UmbaskaYamlLoadingException {
        try {
            JarFile jarFile = new JarFile(jarWithConfig);
            JarEntry configJarEntry = jarFile.getJarEntry(configPath);
            if (configJarEntry == null) {
                return null;
            }
            InputStream moduleYmlStream = jarFile.getInputStream(configJarEntry);
            return YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(moduleYmlStream));
        }
        catch (IOException e) {
            throw new UmbaskaYamlLoadingException("Error loading: " + configPath + " from " + jarWithConfig.getPath() + ". " + e);
        }
    }

    @Nullable
    public static YamlConfiguration getConfig(File jarWithDefault, File configFile, String pathOfDefaultInJar, int currentConfigVersion, boolean restoreValues, boolean createBackup) {
        if (jarWithDefault == null || jarWithDefault.isDirectory() || !jarWithDefault.getName().endsWith(".jar")) {
            return null;
        }
        YamlConfiguration oldConfig = null;
        if (configFile.exists()) {
            File copyCopyTo;
            oldConfig = YamlConfiguration.loadConfiguration((File)configFile);
            int oldConfigVersion = oldConfig.getInt("config-version");
            if (oldConfigVersion == currentConfigVersion) {
                Umbaska.debug("The config ", configFile.getAbsolutePath(), " is up to date (version ", oldConfigVersion, ")");
                return oldConfig;
            }
            if (createBackup && !configFile.renameTo(copyCopyTo = new File(configFile.getParentFile(), "config-old-v" + oldConfig.getInt("config-version") + "-" + System.currentTimeMillis() + ".yml"))) {
                Umbaska.warning("Couldn't create a copy of the old config file, overriding it now.");
                Umbaska.warning("^ Tried to copy ", configFile.getAbsolutePath(), " to ", copyCopyTo.getAbsolutePath());
            }
            configFile.delete();
        }
        Umbaska.info("Creating/updating the config file ", configFile.getAbsolutePath());
        try {
            JarFile jarFile = new JarFile(jarWithDefault);
            JarEntry configJarEntry = jarFile.getJarEntry(pathOfDefaultInJar);
            if (configJarEntry == null) {
                return null;
            }
            configFile.createNewFile();
            Umbaska.debug(configFile.exists());
            FileUtils.copyInputStreamToFile((InputStream)jarFile.getInputStream(configJarEntry), (File)configFile);
        }
        catch (IOException e) {
            new UmbaskaYamlLoadingException(e).printStackTrace();
            return null;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        if (!config.contains("config-version")) {
            Umbaska.warning("The config has no config-version value, so it can't be auto-updated");
        }
        if (restoreValues && oldConfig != null) {
            Map map = oldConfig.getValues(true);
            for (Map.Entry entry : map.entrySet()) {
                String path = (String)entry.getKey();
                Object value = entry.getValue();
                if (path.equals("config-version")) {
                    Umbaska.debug("Path: config-version, ignoring");
                    continue;
                }
                if (value instanceof ConfigurationSection) {
                    Umbaska.debug("Path: ", path, " is a section, ignoring");
                    continue;
                }
                if (config.contains(path)) {
                    config.set(path, value);
                    Umbaska.debug("Path: ", path, " was set to ", value);
                    continue;
                }
                Umbaska.debug("Path: ", path, " is not present in new version of the config");
            }
        }
        return config;
    }

    static {
        mainConfig = null;
        debug = true;
        moduleManagerDebug = true;
        generateDocs = false;
        activeDevelopmentMode = false;
        activeDevelopmentCommand = "stop";
    }
}

